/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.manager;

import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import androidx.core.app.NotificationCompat;
import androidx.core.app.NotificationManagerCompat;
import androidx.core.app.TaskStackBuilder;
import com.tenqube.visual_third.R;
import com.tenqube.visual_third.entity.VisualNotification;
import com.tenqube.visual_third.manager.PrefManager;
import com.tenqube.visual_third.repository.RepositoryHolder;
import com.tenqube.visual_third.repository.VisualRepository;
import com.tenqube.visual_third.ui.VisualWebActivity;
import com.tenqube.visual_third.util.Utils;
import java.util.Calendar;

public class VisualNotificationManager {
    public static final String TAG = VisualNotificationManager.class.getSimpleName();
    public static final int NOTI_ID = 1080;
    private VisualRepository repository;
    private PrefManager prefManager;
    private Context context;
    private static VisualNotificationManager mInstance = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VisualNotificationManager getInstance(Context ctx) {
        Class<VisualNotificationManager> clazz = VisualNotificationManager.class;
        synchronized (VisualNotificationManager.class) {
            if (mInstance == null) {
                mInstance = new VisualNotificationManager(ctx.getApplicationContext());
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return mInstance;
        }
    }

    private VisualNotificationManager(Context context) {
        this.context = context;
        this.repository = RepositoryHolder.getInstance(context).getVisualRepository();
        this.prefManager = PrefManager.getInstance(context);
    }

    public void showNotification(VisualNotification notification) {
        Utils.LOGD("showNotification", "notification: start");
        if (Utils.isSDKDisabled(this.context)) {
            return;
        }
        String[] dates = this.getDateRanges(notification);
        double sum = this.repository.getSum(dates[0], dates[1]);
        this.notifyNotification(notification.getTicker().contains("%") ? String.format(notification.getTicker(), Utils.threeComma(sum)) : notification.getTicker(), notification.getTitle(), notification.getContent().contains("%") ? String.format(notification.getContent(), Utils.threeComma(sum)) : notification.getContent(), this.getStackBuilder(this.getPath(notification.getName())));
    }

    private String getPath(String name) {
        switch (name) {
            case "monthly": {
                return "&monthly=true";
            }
            case "weekly_fri": 
            case "weekly_mon": {
                return "&weekly=true ";
            }
        }
        return "&daily=true";
    }

    private String[] getDateRanges(VisualNotification notification) {
        String fromAt = "";
        String toAt = "";
        Calendar calendar = Calendar.getInstance();
        calendar.set(10, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        long currentTime = calendar.getTimeInMillis();
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        int day = calendar.get(5);
        switch (notification.getName()) {
            case "monthly": {
                int fromYear = year;
                int fromMonth = month - 1;
                if (fromMonth == 0) {
                    fromYear = year - 1;
                    fromMonth = 12;
                }
                fromAt = fromYear + "-" + Utils.DECIMAL_FORMAT.format(fromMonth) + "-01";
                toAt = year + "-" + Utils.DECIMAL_FORMAT.format(month) + "-01";
                break;
            }
            case "weekly_mon": {
                calendar.set(7, 2);
                if (currentTime < calendar.getTimeInMillis()) {
                    calendar.add(3, -2);
                } else if (currentTime == calendar.getTimeInMillis()) {
                    calendar.add(3, -1);
                }
                fromAt = Utils.getYMD(calendar);
                calendar.add(3, 1);
                toAt = Utils.getYMD(calendar);
                break;
            }
            case "weekly_fri": {
                calendar.set(7, 2);
                if (currentTime < calendar.getTimeInMillis()) {
                    calendar.add(3, -1);
                }
                fromAt = Utils.getYMD(calendar);
                calendar.add(3, 1);
                toAt = Utils.getYMD(calendar);
                break;
            }
            case "daily": {
                fromAt = Utils.getYMD(calendar);
                calendar.add(5, 1);
                toAt = Utils.getYMD(calendar);
            }
        }
        return new String[]{fromAt, toAt};
    }

    private void createNotificationChannel() {
        if (Build.VERSION.SDK_INT >= 26) {
            int importance = 3;
            NotificationChannel channel = new NotificationChannel(this.prefManager.loadStringValue("TENQUBE_NOTI_CHANNEL", "visual"), (CharSequence)this.prefManager.loadStringValue("TENQUBE_NOTI_CHANNEL_NAME", "visual"), importance);
            NotificationManager notificationManager = (NotificationManager)this.context.getSystemService(NotificationManager.class);
            if (notificationManager != null) {
                notificationManager.createNotificationChannel(channel);
            }
        }
    }

    private boolean hasChannel() {
        NotificationManager notificationManager;
        if (Build.VERSION.SDK_INT >= 26 && (notificationManager = (NotificationManager)this.context.getSystemService(NotificationManager.class)) != null) {
            return notificationManager.getNotificationChannel(this.prefManager.loadStringValue("TENQUBE_NOTI_CHANNEL", "visual")) != null;
        }
        return true;
    }

    private void notifyNotification(String ticker, String title, String content, TaskStackBuilder stackBuilder) {
        if (this.hasChannel()) {
            PendingIntent pi = stackBuilder.getPendingIntent(1080, 0x8000000);
            Utils.LOGD("notifyNotification", "channel \uc874\uc7ac\uc5ec\ubd80 true");
            int color2 = this.prefManager.loadIntValue("TENQUBE_NOTI_COLOR", 0);
            NotificationCompat.Builder mBuilder = new NotificationCompat.Builder(this.context, this.prefManager.loadStringValue("TENQUBE_NOTI_CHANNEL", "TENQUBE_NOTI_CHANNEL")).setSmallIcon(this.prefManager.loadIntValue("TENQUBE_NOTI_ICON_RES", R.drawable.ic_status)).setContentTitle((CharSequence)title).setContentText((CharSequence)content).setTicker((CharSequence)ticker).setAutoCancel(true).setContentIntent(pi).setDefaults(5).setVibrate(new long[]{0L}).setStyle((NotificationCompat.Style)new NotificationCompat.BigTextStyle().bigText((CharSequence)content));
            if (color2 != 0) {
                mBuilder.setColor(color2);
            }
            NotificationManagerCompat notificationManager = NotificationManagerCompat.from((Context)this.context);
            notificationManager.notify(1080, mBuilder.build());
        } else {
            Utils.LOGD("notifyNotification", "channel \uc874\uc7ac\uc5ec\ubd80 false");
        }
    }

    private Intent getDeepLinkIntent(String path) {
        Intent intent = new Intent();
        intent.putExtra("ARG_PATH", path);
        String deepLink = "visual://popup";
        intent.setAction("android.intent.action.VIEW");
        intent.setData(Uri.parse((String)deepLink));
        intent.addFlags(335675392);
        return intent;
    }

    private TaskStackBuilder getStackBuilder(String path) {
        Intent intent = new Intent(this.context, VisualWebActivity.class);
        intent.putExtra("ARG_PATH", path);
        intent.addFlags(335675392);
        TaskStackBuilder stackBuilder = TaskStackBuilder.create((Context)this.context);
        stackBuilder.addNextIntent(intent);
        return stackBuilder;
    }
}

