/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.api.resource;

import com.tenqube.visual_third.api.resource.ResourceApi;
import com.tenqube.visual_third.api.resource.ResourceService;
import com.tenqube.visual_third.manager.SignatureManager;
import com.tenqube.visual_third.model.api.AnalysisResponse;
import com.tenqube.visual_third.model.api.NotificationPkgResponse;
import com.tenqube.visual_third.model.api.NotificationResponse;
import com.tenqube.visual_third.model.api.ParsingRuleKey;
import com.tenqube.visual_third.model.api.ParsingRuleResponse;
import com.tenqube.visual_third.model.api.SyncCategoryResponse;
import com.tenqube.visual_third.model.api.VersionResponse;
import com.tenqube.visual_third.util.Utils;
import java.io.IOException;
import okhttp3.ResponseBody;
import org.json.JSONException;
import org.json.JSONObject;
import retrofit2.Response;
import tenqube.parser.model.ParsingRule;

public class ResourceServiceImpl
implements ResourceService {
    private static final String TAG = ResourceServiceImpl.class.getSimpleName();
    private final ResourceApi resourceApi;
    private final SignatureManager signatureManager;
    private static ResourceService mInstance;

    private ResourceServiceImpl(ResourceApi resourceApi, SignatureManager signatureManager) {
        this.resourceApi = resourceApi;
        this.signatureManager = signatureManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResourceService getInstance(ResourceApi resourceApi, SignatureManager signatureManager) {
        Class<ResourceServiceImpl> clazz = ResourceServiceImpl.class;
        synchronized (ResourceServiceImpl.class) {
            if (mInstance == null) {
                mInstance = new ResourceServiceImpl(resourceApi, signatureManager);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return mInstance;
        }
    }

    @Override
    public VersionResponse syncVersion() {
        try {
            Response response = this.resourceApi.syncVersion().execute();
            if (response != null && response.isSuccessful()) {
                return (VersionResponse)response.body();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public SyncCategoryResponse syncCategory(int clientVersion, int serverVersion) {
        if (serverVersion > clientVersion) {
            try {
                Response response = this.resourceApi.syncCategory("category", clientVersion, serverVersion).execute();
                if (response.isSuccessful()) {
                    return (SyncCategoryResponse)response.body();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public NotificationPkgResponse syncNotificationApps() {
        try {
            Response response = this.resourceApi.syncNotificationApps().execute();
            if (response.isSuccessful()) {
                return (NotificationPkgResponse)response.body();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Override
    public AnalysisResponse syncAnalysis(int clientVersion, int serverVersion) {
        if (serverVersion > clientVersion) {
            try {
                Response response = this.resourceApi.syncAnalysis("analysis", clientVersion, serverVersion).execute();
                if (response.isSuccessful()) {
                    return (AnalysisResponse)response.body();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public NotificationResponse syncNotification() {
        try {
            Response response = this.resourceApi.syncNotification().execute();
            if (response.isSuccessful()) {
                return (NotificationResponse)response.body();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Override
    public ParsingRule syncParsingRule(int clientVersion, int serverVersion) {
        block5: {
            try {
                ResponseBody response;
                Response ruleResponse;
                Utils.LOGD("syncParsingRule", "syncParsingRule" + clientVersion + "server" + serverVersion);
                if (serverVersion <= clientVersion || !(ruleResponse = this.resourceApi.syncParsingRule("parsingRule", clientVersion, serverVersion).execute()).isSuccessful() || (response = (ResponseBody)ruleResponse.body()) == null) break block5;
                try {
                    JSONObject jsonObject = new JSONObject(response.string());
                    String signature = jsonObject.getString("signature");
                    String resource = jsonObject.getString("resource");
                    ParsingRuleResponse parsingRuleResponse = Utils.fromJson(resource, ParsingRuleResponse.class);
                    boolean isValid = this.signatureManager.isValid(clientVersion, parsingRuleResponse.securityKey, serverVersion, resource, signature);
                    Utils.LOGD("VisualFlow", "syncParsingRule/isValid" + isValid);
                    if (isValid) {
                        ParsingRule parsingRule = new ParsingRule(parsingRuleResponse.securityKey, parsingRuleResponse.tranCount, parsingRuleResponse.ruleVersion, parsingRuleResponse.regDatas, parsingRuleResponse.senders, parsingRuleResponse.banks);
                        return parsingRule;
                    }
                }
                catch (JSONException jSONException) {}
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public ParsingRuleKey syncParsingRuleKey() {
        try {
            Response response = this.resourceApi.syncParsingRuleKey().execute();
            if (response != null && response.isSuccessful()) {
                return (ParsingRuleKey)response.body();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }
}

