package com.tenqube.visual_third.db.dao;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteException;

import com.tenqube.visual_third.db.Db;
import com.tenqube.visual_third.db.QueryGenerator;
import com.tenqube.visual_third.db.ReaderContract;
import com.tenqube.visual_third.entity.Advertisement;

import java.util.ArrayList;

import static tenqube.parser.core.ParserService.mIsDebug;
import static tenqube.parser.util.LogUtil.LOGI;

public class AdvertisementDao {

    private final Db db;

    public AdvertisementDao(Db db) {
        this.db = db;
    }

    public boolean isSatisfied(String query) {
        Cursor c = null;

        try {
            c = db.runQuery(query);
            if (c != null) {
                if (c.moveToFirst()) {
                    return c.getInt(0) == 1;
                }
            }
        } catch (SQLException e) {

        } finally {
            if (c != null)
                c.close();
        }

        return false;
    }

    public ArrayList<Advertisement> loadAds() {
        String query = QueryGenerator.advertisement();
        ArrayList<Advertisement> results = new ArrayList<>();
        Cursor c = null;

        try {
            c = db.runQuery(query);
            if(c != null) {
                if(c.moveToFirst()) {
                    while (!c.isAfterLast()) {
                        results.add(ReaderContract.AdvertisementTable.populateModel(c));
                        c.moveToNext();
                    }
                }
            }
        } catch (SQLiteException e) {

        } finally {
            if(c != null) {
                c.close();
            }
        }

        return results;
    }

    public void merge(Advertisement advertisement) {

        try {
            ContentValues values = new ContentValues();
            values.put(ReaderContract.AdvertisementTable.COLUMN_ID, advertisement.getId());
            values.put(ReaderContract.AdvertisementTable.COLUMN_TITLE, advertisement.getTitle());
            values.put(ReaderContract.AdvertisementTable.COLUMN_LABEL, advertisement.getLabel());
            values.put(ReaderContract.AdvertisementTable.COLUMN_CONTENT, advertisement.getContent());
            values.put(ReaderContract.AdvertisementTable.COLUMN_LINKTO, advertisement.getLinkTo());
            values.put(ReaderContract.AdvertisementTable.COLUMN_LINKTO_TYPE, advertisement.getLinkToType());
            values.put(ReaderContract.AdvertisementTable.COLUMN_LINKTO_STR, advertisement.getLinkToStr());

            values.put(ReaderContract.AdvertisementTable.COLUMN_IMAGE, advertisement.getImage());
            values.put(ReaderContract.AdvertisementTable.COLUMN_ICON_IMAGE, advertisement.getImage());

            values.put(ReaderContract.AdvertisementTable.COLUMN_PRIORITY, advertisement.getPriority());
            values.put(ReaderContract.AdvertisementTable.COLUMN_QUERY, advertisement.getQuery());

            values.put(ReaderContract.AdvertisementTable.COLUMN_BG_COLOR, advertisement.getColors().getBgColor());
            values.put(ReaderContract.AdvertisementTable.COLUMN_TITLE_COLOR, advertisement.getColors().getTitleColor());
            values.put(ReaderContract.AdvertisementTable.COLUMN_CONTENT_COLOR, advertisement.getColors().getContentColor());
            values.put(ReaderContract.AdvertisementTable.COLUMN_LABEL_COLOR, advertisement.getColors().getLabelColor());
            values.put(ReaderContract.AdvertisementTable.COLUMN_LINK_COLOR, advertisement.getColors().getLinkToColor());


            db.insertOnReplace(ReaderContract.AdvertisementTable.TABLE_NAME, values);
        } catch (Exception e) {

        }

    }

}
