package com.tenqube.visual_third.db;

import android.text.TextUtils;

import com.tenqube.visual_third.Constants;
import com.tenqube.visual_third.model.js.TransactionByIdsRequest;
import com.tenqube.visual_third.model.js.TransactionRequest;
import com.tenqube.visual_third.util.Utils;

import java.util.ArrayList;
import java.util.List;

import static com.tenqube.visual_third.Constants.TO;

public final class QueryGenerator {

    private static final String COMMON_CONDITION = ReaderContract.TransactionsTable.COLUMN_IS_DELETED + " = 0 ";

    public static final String SELECT = " SELECT  ";
    public static final String FROM = " FROM  ";
    public static final String WHERE = " WHERE  ";
    public static final String LIMIT = " LIMIT  ";
    public static final String JOIN = " JOIN  ";
    public static final String ON = " ON  ";
    public static final String AND = " AND  ";
    public static final String IN = " IN  ";
    public static final String GROUP_BY = " GROUP BY  ";
    public static final String ORDER_BY = " ORDER BY  ";

    public static String deletedTranIds() {
        return  SELECT + ReaderContract.TransactionsTable.COLUMN_TRAN_ID +
                FROM + ReaderContract.TransactionsTable.TABLE_NAME +
                WHERE + ReaderContract.TransactionsTable.COLUMN_IS_DELETED + " = 1 " + AND +
                ReaderContract.TransactionsTable.COLUMN_IS_SYNCED + " = 1";
    }

    public static String applyAllTran() {
        return  SELECT + " * " +
                FROM + ReaderContract.TransactionsTable.TABLE_NAME +
                WHERE + ReaderContract.TransactionsTable.COLUMN_IS_UPDATE_ALL + " = 1" + AND +
                            ReaderContract.TransactionsTable.COLUMN_KEYWORD + " = ? " + AND +
                            COMMON_CONDITION +
                LIMIT + " 1 ";

    }

    public static String tranId() {
        String whereCondition = ReaderContract.TransactionsTable.COLUMN_IDENTIFIER + "= ? " + AND + COMMON_CONDITION;
        return  SELECT + ReaderContract.TransactionsTable.COLUMN_TRAN_ID +
                FROM + ReaderContract.TransactionsTable.TABLE_NAME +
                WHERE + whereCondition;

    }

    public static String sum(String fromAt, String toAt, int groupBy) {

        String whereCondition = ReaderContract.TransactionsTable.COLUMN_DW_TYPE + "= 1 " + AND +
                ReaderContract.TransactionsTable.COLUMN_SPENT_DATE + " >= " + fromAt + "" + AND +
                ReaderContract.TransactionsTable.COLUMN_SPENT_DATE + " < " + toAt + "" +  AND +
                ReaderContract.CardTable.ALIAS + ReaderContract.CardTable.COLUMN_IS_EXCEPT + "= 0" + AND +
                ReaderContract.UserCategoryTable.ALIAS + ReaderContract.UserCategoryTable.COLUMN_IS_EXCEPT + "= 0" + AND +
                COMMON_CONDITION;

        String groupColumn = "";
        ArrayList<String> groupTitles = new ArrayList<>();

        switch (groupBy) {

            case Constants.ProviderType.CARD:
                groupColumn = ReaderContract.TransactionsTable.ALIAS + ReaderContract.TransactionsTable.COLUMN_CARD_ID;
                groupTitles.add(ReaderContract.CardTable.ALIAS + ReaderContract.CardTable.COLUMN_CARD_NAME);
                groupTitles.add(ReaderContract.CardTable.ALIAS + ReaderContract.CardTable.COLUMN_CARD_TYPE);
                break;

            case Constants.ProviderType.CATEGORY:
                groupColumn = ReaderContract.TransactionsTable.ALIAS + ReaderContract.TransactionsTable.COLUMN_USER_CATEGORY_ID;
                groupTitles.add(ReaderContract.CategoryTable.ALIAS + ReaderContract.CategoryTable.COLUMN_LARGE);
                break;

            case Constants.ProviderType.KEYWORD:
                groupColumn = ReaderContract.TransactionsTable.ALIAS + ReaderContract.TransactionsTable.COLUMN_KEYWORD;
                groupTitles.add(ReaderContract.TransactionsTable.ALIAS + ReaderContract.TransactionsTable.COLUMN_KEYWORD);
                break;
        }

        String groupTitle = groupTitles.size() == 0 ? "" : "," + TextUtils.join(",", groupTitles);


        String query =
                SELECT + " SUM(" +ReaderContract.TransactionsTable.COLUMN_SPENT_MONEY + ") " + groupTitle +
                FROM + ReaderContract.TransactionsTable.TABLE_NAME + ReaderContract.TransactionsTable.AS_ALIAS +
                JOIN + ReaderContract.CardTable.TABLE_NAME + ReaderContract.CardTable.AS_ALIAS +
                ON + ReaderContract.TransactionsTable.ALIAS + ReaderContract.TransactionsTable.COLUMN_CARD_ID + "=" + ReaderContract.CardTable.ALIAS + ReaderContract.CardTable.COLUMN_CARD_ID +

                JOIN + ReaderContract.UserCategoryTable.TABLE_NAME + ReaderContract.UserCategoryTable.AS_ALIAS +
                ON + ReaderContract.TransactionsTable.ALIAS + ReaderContract.TransactionsTable.COLUMN_USER_CATEGORY_ID + "=" + ReaderContract.UserCategoryTable.ALIAS + ReaderContract.UserCategoryTable.COLUMN_USER_CATE_ID +

                JOIN + ReaderContract.CategoryTable.TABLE_NAME + ReaderContract.CategoryTable.AS_ALIAS +
                ON + ReaderContract.TransactionsTable.ALIAS + ReaderContract.TransactionsTable.COLUMN_CATEGORY_CODE + "=" + ReaderContract.CategoryTable.ALIAS + ReaderContract.CategoryTable.COLUMN_CODE +

                WHERE + whereCondition;

        if(!TextUtils.isEmpty(groupColumn)) {
            query += GROUP_BY + groupColumn;
        }

        return query;


    }

    public static String sum() {

        String whereCondition = ReaderContract.TransactionsTable.COLUMN_DW_TYPE + "= 1 " + AND +
                ReaderContract.TransactionsTable.COLUMN_SPENT_DATE + ">= ? " + AND +
                ReaderContract.TransactionsTable.COLUMN_SPENT_DATE + "< ? " +  AND +
                ReaderContract.CardTable.ALIAS + ReaderContract.CardTable.COLUMN_IS_EXCEPT + "= 0" + AND +
                ReaderContract.UserCategoryTable.ALIAS + ReaderContract.UserCategoryTable.COLUMN_IS_EXCEPT + "= 0" + AND +
                COMMON_CONDITION;

        return  SELECT + " SUM(" +ReaderContract.TransactionsTable.COLUMN_SPENT_MONEY + ")" +
                FROM + ReaderContract.TransactionsTable.TABLE_NAME + ReaderContract.TransactionsTable.AS_ALIAS +
                JOIN + ReaderContract.CardTable.TABLE_NAME + ReaderContract.CardTable.AS_ALIAS +
                ON + ReaderContract.TransactionsTable.ALIAS + ReaderContract.TransactionsTable.COLUMN_CARD_ID + "=" + ReaderContract.CardTable.ALIAS + ReaderContract.CardTable.COLUMN_CARD_ID +

                JOIN + ReaderContract.UserCategoryTable.TABLE_NAME + ReaderContract.UserCategoryTable.AS_ALIAS +
                ON + ReaderContract.TransactionsTable.ALIAS + ReaderContract.TransactionsTable.COLUMN_USER_CATEGORY_ID + "=" + ReaderContract.UserCategoryTable.ALIAS + ReaderContract.UserCategoryTable.COLUMN_USER_CATE_ID +
                WHERE + whereCondition;

    }

    public static String transaction() {
        return  SELECT + " * " +
                FROM + ReaderContract.TransactionsTable.TABLE_NAME +
                WHERE + COMMON_CONDITION;

    }

    public static String failedSearchTransaction() {

        String whereCondition = ReaderContract.TransactionsTable.COLUMN_SHOULD_RETRY_SEARCH  + "= 1"  +
                AND + ReaderContract.TransactionsTable.COLUMN_IS_USER_UPDATE + " = 0";
//        +

        return  SELECT + " * " +
                FROM + ReaderContract.TransactionsTable.TABLE_NAME + ReaderContract.TransactionsTable.AS_ALIAS +

                JOIN + ReaderContract.CardTable.TABLE_NAME + ReaderContract.CardTable.AS_ALIAS +
                ON + ReaderContract.TransactionsTable.ALIAS + ReaderContract.TransactionsTable.COLUMN_CARD_ID + "=" + ReaderContract.CardTable.ALIAS + ReaderContract.CardTable.COLUMN_CARD_ID +

                JOIN + ReaderContract.UserCategoryTable.TABLE_NAME + ReaderContract.UserCategoryTable.AS_ALIAS +
                ON + ReaderContract.TransactionsTable.ALIAS + ReaderContract.TransactionsTable.COLUMN_USER_CATEGORY_ID + "=" + ReaderContract.UserCategoryTable.ALIAS + ReaderContract.UserCategoryTable.COLUMN_USER_CATE_ID +

                JOIN + ReaderContract.CategoryTable.TABLE_NAME + ReaderContract.CategoryTable.AS_ALIAS +
                ON + ReaderContract.TransactionsTable.ALIAS + ReaderContract.TransactionsTable.COLUMN_CATEGORY_CODE + "=" + ReaderContract.CategoryTable.ALIAS + ReaderContract.CategoryTable.COLUMN_CODE +

                WHERE + whereCondition;
    }

    public static String joinedTransaction(TransactionByIdsRequest transactionRequest) {

        String whereCondition = ReaderContract.TransactionsTable.COLUMN_TRAN_ID  + " IN (" + TextUtils.join(",", transactionRequest.getTranIds()) + ")" +
                AND + COMMON_CONDITION;
//        +
//                " AND " + ReaderContract.UserCategoryTable.ALIAS + ReaderContract.UserCategoryTable.COLUMN_IS_EXCEPT + "= 0" +
//                " AND " + ReaderContract.CardTable.ALIAS + ReaderContract.CardTable.COLUMN_IS_EXCEPT + "= 0";

        return  SELECT + " * " +

                FROM + ReaderContract.TransactionsTable.TABLE_NAME + ReaderContract.TransactionsTable.AS_ALIAS +

                JOIN + ReaderContract.CardTable.TABLE_NAME + ReaderContract.CardTable.AS_ALIAS +
                ON + ReaderContract.TransactionsTable.ALIAS + ReaderContract.TransactionsTable.COLUMN_CARD_ID + "=" + ReaderContract.CardTable.ALIAS + ReaderContract.CardTable.COLUMN_CARD_ID +

                JOIN + ReaderContract.UserCategoryTable.TABLE_NAME + ReaderContract.UserCategoryTable.AS_ALIAS +
                ON + ReaderContract.TransactionsTable.ALIAS + ReaderContract.TransactionsTable.COLUMN_USER_CATEGORY_ID + "=" + ReaderContract.UserCategoryTable.ALIAS + ReaderContract.UserCategoryTable.COLUMN_USER_CATE_ID +

                JOIN + ReaderContract.CategoryTable.TABLE_NAME + ReaderContract.CategoryTable.AS_ALIAS +
                ON + ReaderContract.TransactionsTable.ALIAS + ReaderContract.TransactionsTable.COLUMN_CATEGORY_CODE + "=" + ReaderContract.CategoryTable.ALIAS + ReaderContract.CategoryTable.COLUMN_CODE +

                WHERE + whereCondition;
    }

    public static String joinedTransaction(TransactionRequest transactionRequest) {

        String[] dates = Utils.getDateRange(transactionRequest.getYear(),
                transactionRequest.getMonth(),
                transactionRequest.getBefore(),
                transactionRequest.getStartDay());

//        Log.i("getTransactions", "FROM : " + dates[Constants.FROM]);
//        Log.i("getTransactions", "TO : " + dates[TO]);


        String whereCondition = ReaderContract.TransactionsTable.COLUMN_SPENT_DATE  + ">= '" + dates[Constants.FROM] + "'" +
                AND + ReaderContract.TransactionsTable.COLUMN_SPENT_DATE + " < '" + dates[TO] + "' ";
        if(transactionRequest.getDwType() != -1) {
            whereCondition += AND + ReaderContract.TransactionsTable.COLUMN_DW_TYPE + " = " + transactionRequest.getDwType();
        }

        if(transactionRequest.getExceptType() != -1)
            whereCondition += AND + ReaderContract.UserCategoryTable.ALIAS + ReaderContract.UserCategoryTable.COLUMN_IS_EXCEPT + "= " + transactionRequest.getExceptType();

        whereCondition +=  AND + COMMON_CONDITION;
        return  SELECT + " * " +
                FROM + ReaderContract.TransactionsTable.TABLE_NAME + ReaderContract.TransactionsTable.AS_ALIAS +
                JOIN + ReaderContract.CardTable.TABLE_NAME + ReaderContract.CardTable.AS_ALIAS +
                ON + ReaderContract.TransactionsTable.ALIAS + ReaderContract.TransactionsTable.COLUMN_CARD_ID + "=" + ReaderContract.CardTable.ALIAS + ReaderContract.CardTable.COLUMN_CARD_ID +

                JOIN + ReaderContract.UserCategoryTable.TABLE_NAME + ReaderContract.UserCategoryTable.AS_ALIAS +
                ON + ReaderContract.TransactionsTable.ALIAS + ReaderContract.TransactionsTable.COLUMN_USER_CATEGORY_ID + "=" + ReaderContract.UserCategoryTable.ALIAS + ReaderContract.UserCategoryTable.COLUMN_USER_CATE_ID +

                JOIN + ReaderContract.CategoryTable.TABLE_NAME + ReaderContract.CategoryTable.AS_ALIAS +
                ON + ReaderContract.TransactionsTable.ALIAS + ReaderContract.TransactionsTable.COLUMN_CATEGORY_CODE + "=" + ReaderContract.CategoryTable.ALIAS + ReaderContract.CategoryTable.COLUMN_CODE +

                WHERE + whereCondition;
    }

    public static String joinedTransaction() {

        String whereCondition = ReaderContract.TransactionsTable.COLUMN_TRAN_ID  + " = ?";
        whereCondition +=  AND + COMMON_CONDITION;
        return  SELECT + " * " +
                FROM + ReaderContract.TransactionsTable.TABLE_NAME + ReaderContract.TransactionsTable.AS_ALIAS +

                JOIN + ReaderContract.CardTable.TABLE_NAME + ReaderContract.CardTable.AS_ALIAS +
                ON + ReaderContract.TransactionsTable.ALIAS + ReaderContract.TransactionsTable.COLUMN_CARD_ID + "=" + ReaderContract.CardTable.ALIAS + ReaderContract.CardTable.COLUMN_CARD_ID +

                JOIN + ReaderContract.UserCategoryTable.TABLE_NAME + ReaderContract.UserCategoryTable.AS_ALIAS +
                ON + ReaderContract.TransactionsTable.ALIAS + ReaderContract.TransactionsTable.COLUMN_USER_CATEGORY_ID + "=" + ReaderContract.UserCategoryTable.ALIAS + ReaderContract.UserCategoryTable.COLUMN_USER_CATE_ID +

                JOIN + ReaderContract.CategoryTable.TABLE_NAME + ReaderContract.CategoryTable.AS_ALIAS +
                ON + ReaderContract.TransactionsTable.ALIAS + ReaderContract.TransactionsTable.COLUMN_CATEGORY_CODE + "=" + ReaderContract.CategoryTable.ALIAS + ReaderContract.CategoryTable.COLUMN_CODE +

                WHERE + whereCondition;
    }

    public static String allTransactions() {


        return  SELECT + " * " +
                FROM + ReaderContract.TransactionsTable.TABLE_NAME + ReaderContract.TransactionsTable.AS_ALIAS +

                JOIN + ReaderContract.CardTable.TABLE_NAME + ReaderContract.CardTable.AS_ALIAS +
                ON + ReaderContract.TransactionsTable.ALIAS + ReaderContract.TransactionsTable.COLUMN_CARD_ID + "=" + ReaderContract.CardTable.ALIAS + ReaderContract.CardTable.COLUMN_CARD_ID +

                JOIN + ReaderContract.UserCategoryTable.TABLE_NAME + ReaderContract.UserCategoryTable.AS_ALIAS +
                ON + ReaderContract.TransactionsTable.ALIAS + ReaderContract.TransactionsTable.COLUMN_USER_CATEGORY_ID + "=" + ReaderContract.UserCategoryTable.ALIAS + ReaderContract.UserCategoryTable.COLUMN_USER_CATE_ID +

                JOIN + ReaderContract.CategoryTable.TABLE_NAME + ReaderContract.CategoryTable.AS_ALIAS +
                ON + ReaderContract.TransactionsTable.ALIAS + ReaderContract.TransactionsTable.COLUMN_CATEGORY_CODE + "=" + ReaderContract.CategoryTable.ALIAS + ReaderContract.CategoryTable.COLUMN_CODE +
                ORDER_BY + ReaderContract.TransactionsTable.ALIAS + ReaderContract.TransactionsTable.COLUMN_SPENT_DATE + " DESC ";

    }

    public static String notSyncedTransactions() {

        String whereCondition = ReaderContract.TransactionsTable.COLUMN_IS_SYNCED  + "= 0 " + AND +
                ReaderContract.TransactionsTable.COLUMN_COMPANY_ID + " != 0 ";

        return  SELECT + " * " +
                FROM + ReaderContract.TransactionsTable.TABLE_NAME + ReaderContract.TransactionsTable.AS_ALIAS +

                JOIN + ReaderContract.CardTable.TABLE_NAME + ReaderContract.CardTable.AS_ALIAS +
                ON + ReaderContract.TransactionsTable.ALIAS + ReaderContract.TransactionsTable.COLUMN_CARD_ID + "=" + ReaderContract.CardTable.ALIAS + ReaderContract.CardTable.COLUMN_CARD_ID +

                JOIN + ReaderContract.UserCategoryTable.TABLE_NAME + ReaderContract.UserCategoryTable.AS_ALIAS +
                ON + ReaderContract.TransactionsTable.ALIAS + ReaderContract.TransactionsTable.COLUMN_USER_CATEGORY_ID + "=" + ReaderContract.UserCategoryTable.ALIAS + ReaderContract.UserCategoryTable.COLUMN_USER_CATE_ID +

                JOIN + ReaderContract.CategoryTable.TABLE_NAME + ReaderContract.CategoryTable.AS_ALIAS +
                ON + ReaderContract.TransactionsTable.ALIAS + ReaderContract.TransactionsTable.COLUMN_CATEGORY_CODE + "=" + ReaderContract.CategoryTable.ALIAS + ReaderContract.CategoryTable.COLUMN_CODE +

                WHERE + whereCondition +
                LIMIT + " 30 ";
    }

    public static String card() {
        return  SELECT + " * " +
                FROM + ReaderContract.CardTable.TABLE_NAME;
    }

    public static String senderTransactionByIds(List<String> ids) {

        ArrayList<String> identifiers = new ArrayList<>();

        for(String id: ids) {
            identifiers.add("'" + id + "'");
        }
        return  SELECT + " * " +
                FROM + ReaderContract.SenderTransactionTable.TABLE_NAME +
                WHERE + ReaderContract.SenderTransactionTable.COLUMN_TRAN_IDENTIFIER + IN + "(" + TextUtils.join(",", identifiers) + ")";
    }

    public static String cardId() {
        String whereCondition =
                ReaderContract.CardTable.COLUMN_CARD_NAME + " = ? " + AND +
                ReaderContract.CardTable.COLUMN_CARD_TYPE + " = ?"  + AND +
                ReaderContract.CardTable.COLUMN_CARD_SUB_TYPE + " = ?" ;

        return  SELECT + ReaderContract.CardTable.COLUMN_CARD_ID +
                FROM + ReaderContract.CardTable.TABLE_NAME +
                WHERE + whereCondition;
    }

    public static String category() {

//        String whereCondition = isWithdraw ? ReaderContract.CategoryTable.COLUMN_CODE + " < 900000 "
//                : ReaderContract.CategoryTable.COLUMN_CODE + " > 900000 ";

        return  SELECT + " * " +
                FROM + ReaderContract.CategoryTable.TABLE_NAME;

    }

    public static String categoryByMedium() {

//        String whereCondition = isWithdraw ? ReaderContract.CategoryTable.COLUMN_CODE + " < 900000 "
//                : ReaderContract.CategoryTable.COLUMN_CODE + " > 900000 ";

        return  SELECT + " * " +
                FROM + ReaderContract.CategoryTable.TABLE_NAME +
                GROUP_BY + " substr( " + ReaderContract.CategoryTable.COLUMN_CODE+", 1, 4)" ;

    }

    public static String categoryByCode() {

        String whereCondition = ReaderContract.CategoryTable.COLUMN_CODE + "= ?";

        return  SELECT + " * " +
                FROM + ReaderContract.CategoryTable.TABLE_NAME +
                WHERE + whereCondition;

    }

    public static String userCategory() {
        return  SELECT + " * " +
                FROM + ReaderContract.UserCategoryTable.TABLE_NAME;
    }

    public static String userCategoryByCode() {
        String whereCondition = ReaderContract.UserCategoryTable.COLUMN_CODE + "= ?";

        return  SELECT + ReaderContract.UserCategoryTable.COLUMN_USER_CATE_ID +
                FROM + ReaderContract.UserCategoryTable.TABLE_NAME +
                WHERE + whereCondition;
    }

    public static String contents() {

        return  SELECT + " * " +
                FROM + ReaderContract.ContentTable.TABLE_NAME;

    }

    public static String conditions() {

        return  SELECT + " * " +
                FROM + ReaderContract.ConditionTable.TABLE_NAME;
    }

    public static String currency() {
        String whereCondition =  ReaderContract.CurrencyTable.COLUMN_FROM + "= ?" +
                AND + ReaderContract.CurrencyTable.COLUMN_TO + "= ?";

        return  SELECT + "*" +
                FROM + ReaderContract.CurrencyTable.TABLE_NAME +
                WHERE + whereCondition;
    }

    public static String isActive() {

        String whereCondition =  ReaderContract.NotificationsTable.COLUMN_NAME + " like ? ";

        return  SELECT + ReaderContract.NotificationsTable.COLUMN_ENABLE +
                FROM + ReaderContract.NotificationsTable.TABLE_NAME +
                WHERE + whereCondition;
    }

    public static String notification() {

        return  SELECT + "*" +
                FROM + ReaderContract.NotificationsTable.TABLE_NAME;
    }

    public static String notificationById() {

        String whereCondition =  ReaderContract.NotificationsTable.COLUMN_NOTI_ID + " = ?";

        return  SELECT + "*" +
                FROM + ReaderContract.NotificationsTable.TABLE_NAME +
                WHERE + whereCondition;
    }

    public static String notificationByName() {
        String whereCondition =  ReaderContract.NotificationsTable.COLUMN_NAME + " like ?";

        return  SELECT + "*" +
                FROM + ReaderContract.NotificationsTable.TABLE_NAME +
                WHERE + whereCondition;
    }

    public static String notification(boolean enabled) {
        int value = enabled ? 1 : 0;

        String whereCondition =  ReaderContract.NotificationsTable.COLUMN_ENABLE + "=" + value;

        return  SELECT + "*" +
                FROM + ReaderContract.NotificationsTable.TABLE_NAME +
                WHERE + whereCondition;
    }

    public static String advertisement(int id) {

        String whereCondition =  ReaderContract.AdvertisementTable.COLUMN_ID + "=" + id;

        return  SELECT + " * " +
                FROM + ReaderContract.AdvertisementTable.TABLE_NAME +
                WHERE + whereCondition;

    }

    public static String advertisement() {
        String whereCondition =  ReaderContract.AdvertisementTable.COLUMN_ID + "!=0";

        return  SELECT + " * " +
                FROM + ReaderContract.AdvertisementTable.TABLE_NAME +
                WHERE + whereCondition +
                ORDER_BY + ReaderContract.AdvertisementTable.COLUMN_PRIORITY + " DESC ";

    }

    public static String notificationApp() {
        return  SELECT + "*" +
                FROM + ReaderContract.NotificationAppTable.TABLE_NAME +
                ORDER_BY + ReaderContract.NotificationAppTable.COLUMN_PRIORITY + " DESC ";
    }
}
