/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.repository;

import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.tenqube.visual_third.Callback;
import com.tenqube.visual_third.Constants;
import com.tenqube.visual_third.VisualCallback;
import com.tenqube.visual_third.VisualUserInfo;
import com.tenqube.visual_third.api.auth.AuthApi;
import com.tenqube.visual_third.api.auth.AuthService;
import com.tenqube.visual_third.api.auth.AuthServiceImpl;
import com.tenqube.visual_third.api.search.SearchApi;
import com.tenqube.visual_third.api.search.SearchService;
import com.tenqube.visual_third.api.search.SearchServiceImpl;
import com.tenqube.visual_third.api.visual.VisualApi;
import com.tenqube.visual_third.api.visual.VisualApiService;
import com.tenqube.visual_third.api.visual.VisualApiServiceImpl;
import com.tenqube.visual_third.db.dao.AdvertisementDao;
import com.tenqube.visual_third.db.dao.CardDao;
import com.tenqube.visual_third.db.dao.CategoryDao;
import com.tenqube.visual_third.db.dao.CurrencyDao;
import com.tenqube.visual_third.db.dao.NotificationAppDao;
import com.tenqube.visual_third.db.dao.NotificationDao;
import com.tenqube.visual_third.db.dao.SenderTransactionDao;
import com.tenqube.visual_third.db.dao.TransactionDao;
import com.tenqube.visual_third.db.dao.UserCategoryDao;
import com.tenqube.visual_third.entity.Advertisement;
import com.tenqube.visual_third.entity.Card;
import com.tenqube.visual_third.entity.Category;
import com.tenqube.visual_third.entity.Currency;
import com.tenqube.visual_third.entity.JoinedTransaction;
import com.tenqube.visual_third.entity.NotificationApp;
import com.tenqube.visual_third.entity.SenderTransaction;
import com.tenqube.visual_third.entity.UserCategory;
import com.tenqube.visual_third.entity.VisualNotification;
import com.tenqube.visual_third.exception.ParameterException;
import com.tenqube.visual_third.manager.AnswerManager;
import com.tenqube.visual_third.manager.PrefManager;
import com.tenqube.visual_third.manager.SecretKeyManager;
import com.tenqube.visual_third.model.analysis.Transaction;
import com.tenqube.visual_third.model.api.AdInfoResponse;
import com.tenqube.visual_third.model.api.AdResponse;
import com.tenqube.visual_third.model.api.CurrencyResponse;
import com.tenqube.visual_third.model.api.SearchCompanyRequest;
import com.tenqube.visual_third.model.api.SearchCompanyResponse;
import com.tenqube.visual_third.model.api.TransactionRequest;
import com.tenqube.visual_third.model.api.UserInfoRequest;
import com.tenqube.visual_third.model.api.UserRequest;
import com.tenqube.visual_third.model.js.Cards;
import com.tenqube.visual_third.model.js.CategoryInfo;
import com.tenqube.visual_third.model.js.InsertTransactionRequest;
import com.tenqube.visual_third.model.js.LogRequest;
import com.tenqube.visual_third.model.js.TransactionByIdsRequest;
import com.tenqube.visual_third.model.js.Transactions;
import com.tenqube.visual_third.model.js.UpdateTransactionRequest;
import com.tenqube.visual_third.model.parser.SyncTransaction;
import com.tenqube.visual_third.ui.OnResultListener;
import com.tenqube.visual_third.util.AppExecutors;
import com.tenqube.visual_third.util.Mapper;
import com.tenqube.visual_third.util.Utils;
import com.tenqube.visual_third.util.VisualInjection;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import retrofit2.Call;
import retrofit2.Response;
import tenqube.parser.OnNetworkResultListener;
import tenqube.parser.constants.Constants;

public class VisualRepository {
    private Context context;
    private static VisualRepository mInstance;
    private final PrefManager prefManager;
    private final SenderTransactionDao senderTransactionDao;
    private final CardDao cardDao;
    private final CategoryDao categoryDao;
    private final TransactionDao transactionDao;
    private final UserCategoryDao userCategoryDao;
    private final CurrencyDao currencyDao;
    private final NotificationDao notificationDao;
    private final NotificationAppDao notificationAppDao;
    private final SecretKeyManager secretKeyManager;
    @Nullable
    private VisualCallback visualCallback;
    @Nullable
    private AuthService authService;
    @Nullable
    private VisualApiService visualService;
    @Nullable
    private SearchService searchService;
    private final AdvertisementDao advertisementDao;
    private AppExecutors appExecutors;
    private boolean isVisualActive;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VisualRepository getInstance(Context context, PrefManager prefManager, SenderTransactionDao senderTransactionDao, CardDao cardDao, CategoryDao categoryDao, TransactionDao transactionDao, UserCategoryDao userCategoryDao, CurrencyDao currencyDao, NotificationDao notificationDao, AdvertisementDao advertisementDao, NotificationAppDao notificationAppDao, AppExecutors appExecutor, SecretKeyManager secretKeyManager) {
        Class<VisualRepository> clazz = VisualRepository.class;
        synchronized (VisualRepository.class) {
            if (mInstance == null) {
                mInstance = new VisualRepository(context, prefManager, senderTransactionDao, cardDao, categoryDao, transactionDao, userCategoryDao, currencyDao, notificationDao, advertisementDao, notificationAppDao, appExecutor, secretKeyManager);
            }
            // ** MonitorExit[var13_13] (shouldn't be in output)
            return mInstance;
        }
    }

    private VisualRepository(Context context, PrefManager prefManager, SenderTransactionDao senderTransactionDao, CardDao cardDao, CategoryDao categoryDao, TransactionDao transactionDao, UserCategoryDao userCategoryDao, CurrencyDao currencyDao, NotificationDao notificationDao, AdvertisementDao advertisementDao, NotificationAppDao notificationAppDao, AppExecutors appExecutors, SecretKeyManager secretKeyManager) {
        this.context = context;
        this.prefManager = prefManager;
        this.senderTransactionDao = senderTransactionDao;
        this.cardDao = cardDao;
        this.categoryDao = categoryDao;
        this.transactionDao = transactionDao;
        this.userCategoryDao = userCategoryDao;
        this.currencyDao = currencyDao;
        this.notificationDao = notificationDao;
        this.advertisementDao = advertisementDao;
        this.notificationAppDao = notificationAppDao;
        this.appExecutors = appExecutors;
        this.secretKeyManager = secretKeyManager;
    }

    public String getSyncStatus() {
        return this.prefManager.loadStringValue("TENQUBE_RESTORE_STATUS", "none");
    }

    public void setVisualCallback(VisualCallback callback) {
        this.visualCallback = callback;
    }

    public void setVisualActive(boolean isVisualActive) {
        this.isVisualActive = isVisualActive;
    }

    public void syncAd(final Callback<Boolean> callback) {
        this.appExecutors.networkIO().execute(new Runnable(){

            @Override
            public void run() {
                AdInfoResponse versionResponse;
                boolean shouldLoad = true;
                AdInfoResponse adInfoResponse = versionResponse = VisualRepository.this.visualService == null ? null : VisualRepository.this.visualService.getAdInfo();
                if (versionResponse != null && !versionResponse.shouldShowAd()) {
                    shouldLoad = false;
                } else {
                    int version = VisualRepository.this.prefManager.loadIntValue("TENQUBE_AD_VERSION", 0);
                    if (versionResponse != null && versionResponse.getVersion() > version) {
                        AdResponse adResponse;
                        AdResponse adResponse2 = adResponse = VisualRepository.this.visualService == null ? null : VisualRepository.this.visualService.getAds(versionResponse.getVersion());
                        if (adResponse != null) {
                            VisualRepository.this.mergeAdvertisement(adResponse, versionResponse.getVersion());
                        }
                    }
                }
                final boolean finalShouldLoad = shouldLoad;
                VisualRepository.this.appExecutors.mainThread().execute(new Runnable(){

                    @Override
                    public void run() {
                        callback.onDataLoaded(finalShouldLoad);
                    }
                });
            }
        });
    }

    public double getCurrencyRate(String from, String to, double rate) {
        CurrencyResponse currencyResponse;
        CurrencyResponse currencyResponse2 = currencyResponse = this.visualService == null ? null : this.visualService.getCurrencyRate(from, to);
        if (currencyResponse != null) {
            this.currencyDao.mergeCurrency(new Currency(0, from, to, rate, Utils.getStringDateAsYYYYMMddHHmmss(Calendar.getInstance())));
            return currencyResponse.getRate();
        }
        return rate;
    }

    public void onTransactionReceived(int tranId) {
        Intent intent = new Intent("ACTION_BROADCAST_TRANSACTION");
        intent.putExtra("tranId", tranId);
        LocalBroadcastManager.getInstance((Context)this.context).sendBroadcast(intent);
        this.appExecutors.mainThread().execute(new Runnable(){

            @Override
            public void run() {
                if (VisualRepository.this.visualCallback != null) {
                    VisualRepository.this.visualCallback.onTransactionReceived();
                }
            }
        });
    }

    public void syncTransactions(final OnNetworkResultListener callback) {
        if (this.visualService == null) {
            if (callback != null) {
                callback.onResult(false);
            }
            return;
        }
        final TransactionRequest transactionRequest = this.loadNotSyncedTransactions();
        if (transactionRequest != null && !Utils.isEmpty(transactionRequest.getTransactions())) {
            this.visualService.saveTransactions(transactionRequest, new retrofit2.Callback<Void>(){

                public void onResponse(Call<Void> call, Response<Void> response) {
                    VisualRepository.this.updateSyncedTransactions(transactionRequest);
                    VisualRepository.this.deleteTransactions();
                    if (callback != null) {
                        callback.onResult(true);
                    }
                }

                public void onFailure(Call<Void> call, Throwable t) {
                    VisualRepository.this.updateSyncedTransactions(transactionRequest);
                    VisualRepository.this.deleteTransactions();
                    if (callback != null) {
                        callback.onResult(true);
                    }
                }
            });
        } else if (callback != null) {
            callback.onResult(true);
        }
    }

    public SearchCompanyResponse searchCompany(SearchCompanyRequest request) {
        if (this.searchService == null) {
            this.createSearchService();
        }
        return this.searchService.searchCompany(request);
    }

    public void signUp(final String uid, final VisualUserInfo visualUserInfo, final OnResultListener listener) {
        Utils.LOGD("signUp", "uid: " + uid);
        this.appExecutors.diskIO().execute(new Runnable(){

            @Override
            public void run() {
                String msg;
                int resultCode;
                try {
                    if (VisualRepository.this.isJoined()) {
                        resultCode = 3;
                        msg = "already joined";
                    } else {
                        boolean success;
                        String adId = Utils.getAdId(VisualRepository.this.context);
                        UserRequest signUpRequest = new UserRequest(uid, adId);
                        AnswerManager.onKeyMetric(new LogRequest("signUp"));
                        boolean bl = success = VisualRepository.this.authService != null && VisualRepository.this.authService.signUp(signUpRequest);
                        if (success) {
                            VisualRepository.this.saveUserInfo(visualUserInfo);
                            VisualRepository.this.setTranPopup(false);
                            VisualRepository.this.setActiveNoti(Constants.ReportAlarmType.DAILY.name().toLowerCase(), false);
                            VisualRepository.this.setActiveNoti(Constants.ReportAlarmType.WEEKLY.name().toLowerCase(), false);
                            VisualRepository.this.setActiveNoti(Constants.ReportAlarmType.MONTHLY.name().toLowerCase(), false);
                            resultCode = 0;
                            msg = "success";
                        } else {
                            resultCode = 1;
                            msg = "server error";
                        }
                    }
                }
                catch (IOException e) {
                    resultCode = 2;
                    msg = "network error";
                }
                catch (ParameterException e) {
                    resultCode = 1;
                    msg = "parameter error";
                }
                catch (Exception e) {
                    resultCode = 1;
                    msg = e.toString();
                }
                final int finalResultCode = resultCode;
                final String finalMsg = msg;
                VisualRepository.this.appExecutors.mainThread().execute(new Runnable(){

                    @Override
                    public void run() {
                        Utils.LOGD("signUp", "onResult finalResultCode: " + finalResultCode);
                        Utils.LOGD("signUp", "onResult finalMsg: " + finalMsg);
                        listener.onResult(finalResultCode, finalMsg);
                    }
                });
            }
        });
    }

    private void saveUserInfo(VisualUserInfo visualUserInfo) {
        try {
            UserInfoRequest userInfoRequest = new UserInfoRequest(visualUserInfo.getBirth(), visualUserInfo.getGender().name().toLowerCase());
            this.visualService.saveUserInfo(userInfoRequest);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void createApiService() {
        AuthApi authApi = VisualInjection.provideApiService(AuthApi.class, this.getUrl("https://b1nsk1uqng.execute-api.ap-northeast-2.amazonaws.com/"), null, VisualInjection.getAuthInterceptors(this.prefManager));
        this.authService = AuthServiceImpl.getInstance(this.context, authApi, this.prefManager, this.secretKeyManager);
        VisualApi visualApi = VisualInjection.provideApiService(VisualApi.class, this.getUrl("https://b1nsk1uqng.execute-api.ap-northeast-2.amazonaws.com/"), this.authService, VisualInjection.getVisualInterceptors(this.prefManager, this.authService));
        this.visualService = VisualApiServiceImpl.getInstance(this.context, visualApi, this.prefManager);
    }

    private String getUrl(String url) {
        return url + this.prefManager.loadStringValue("TENQUBE_QUALIFIER", "dev") + "/";
    }

    private void createSearchService() {
        SearchApi searchApi = VisualInjection.provideApiService(SearchApi.class, this.prefManager.loadStringValue("TENQUBE_SEARCH_URL", ""), this.authService, VisualInjection.getSearchInterceptors(this.prefManager, this.secretKeyManager));
        this.searchService = SearchServiceImpl.getInstance(this.context, searchApi, this.prefManager);
    }

    public void initialize(final Callback<Boolean> callback) {
        this.appExecutors.diskIO().execute(new Runnable(){

            @Override
            public void run() {
                VisualRepository.this.deleteCard();
                VisualRepository.this.insertCash();
                VisualRepository.this.deleteTransactions();
                VisualRepository.this.senderTransactionDao.deleteAll();
                VisualRepository.this.appExecutors.mainThread().execute(new Runnable(){

                    @Override
                    public void run() {
                        callback.onDataLoaded(true);
                    }
                });
            }
        });
    }

    public void cancelAlarms() {
        this.notificationDao.updateAllNotiEnable(false);
    }

    public void signOut(final Callback<Boolean> callback) {
        this.appExecutors.diskIO().execute(new Runnable(){

            @Override
            public void run() {
                VisualRepository.this.secretKeyManager.save("TENQUBE_ACCESS_TOKEN", "");
                VisualRepository.this.secretKeyManager.save("TENQUBE_REFRESH_TOKEN", "");
                VisualRepository.this.prefManager.saveBoolean("TENQUBE_TRAN_POPUP", false);
                VisualRepository.this.notificationDao.updateAllNotiEnable(false);
                VisualRepository.this.prefManager.saveBoolean("TENQUBE_BULK_EXECUTED_2", false);
                VisualRepository.this.initialize(new Callback<Boolean>(){

                    @Override
                    public void onDataLoaded(Boolean value) {
                        if (VisualRepository.this.visualCallback != null && VisualRepository.this.isVisualActive) {
                            VisualRepository.this.visualCallback.onSignOut();
                        }
                        callback.onDataLoaded(value);
                    }
                });
            }
        });
    }

    public String getUid() {
        return this.prefManager.loadStringValue("TENQUBE_USER_ID", UUID.randomUUID().toString());
    }

    public int getDivider() {
        return this.prefManager.loadIntValue("TENQUBE_NOTIFICATION_DIVIDER", 120);
    }

    public boolean isSatisfied(String queryAll) {
        String[] queries = queryAll.split(";");
        boolean isSatisfied = true;
        for (String query : queries) {
            boolean bl = isSatisfied = !this.isInvalid(query) && this.advertisementDao.isSatisfied(query);
            if (!isSatisfied) break;
        }
        return isSatisfied;
    }

    private boolean isInvalid(String query) {
        return TextUtils.isEmpty((CharSequence)query) || query.toLowerCase().contains("delete") || query.toLowerCase().contains("update") || query.toLowerCase().contains("insert") || query.toLowerCase().contains("`") || !query.toLowerCase().contains("select");
    }

    public ArrayList<Advertisement> loadAds() {
        return this.advertisementDao.loadAds();
    }

    private void mergeAdvertisement(AdResponse ad, int version) {
        this.prefManager.saveIntValue("TENQUBE_AD_VERSION", version);
        String ratio = TextUtils.isEmpty((CharSequence)ad.getRatio()) ? "2:8" : ad.getRatio();
        this.prefManager.saveStringValue("TENQUBE_AD_RATIO", ratio);
        if (ad.getAdmob() != null) {
            this.prefManager.saveStringValue("TENQUBE_ADMOB_BG_COLOR", ad.getAdmob().getBgColor());
            this.prefManager.saveStringValue("TENQUBE_ADMOB_TITLE_COLOR", ad.getAdmob().getTitleColor());
            this.prefManager.saveStringValue("TENQUBE_ADMOB_CONTENT_COLOR", ad.getAdmob().getContentColor());
            this.prefManager.saveStringValue("TENQUBE_ADMOB_LABEL_COLOR", ad.getAdmob().getLabelColor());
            this.prefManager.saveStringValue("TENQUBE_ADMOB_LINK_COLOR", ad.getAdmob().getLinkToColor());
        }
        if (!Utils.isEmpty(ad.getAds())) {
            for (Advertisement a : ad.getAds()) {
                this.advertisementDao.merge(a);
            }
        }
    }

    public String getAdmobColor(String key, String defaultColor) {
        return this.prefManager.loadStringValue(key, defaultColor);
    }

    public Cursor getSum(String fromAt, String toAt, int groupBy) {
        return this.transactionDao.getSum(fromAt, toAt, groupBy);
    }

    public void settingNotification(int smallIcon, String channel, int color2) {
        this.prefManager.saveIntValue("TENQUBE_NOTI_ICON_RES", smallIcon);
        this.prefManager.saveStringValue("TENQUBE_NOTI_CHANNEL", channel);
        this.prefManager.saveIntValue("TENQUBE_NOTI_COLOR", color2);
    }

    public void setEnabled(boolean enabled) {
        this.prefManager.saveBoolean("TENQUBE_SDK_ENABLED", enabled);
    }

    public void saveSDKInfo(String apiKey, String qualifier, String authority) {
        this.prefManager.saveStringValue("TENQUBE_API_KEY", apiKey);
        this.prefManager.saveStringValue("TENQUBE_QUALIFIER", qualifier);
        this.prefManager.saveStringValue("TENQUBE_AUTHORITY", authority);
        this.createApiService();
    }

    public double getSum(String fromAt, String toAt) {
        return this.transactionDao.getSum(fromAt, toAt);
    }

    public boolean isActiveNoti(String name) {
        return this.notificationDao.isActiveNoti(name);
    }

    public void setNotiAll(boolean isActive) {
        this.notificationDao.updateAllNotiEnable(isActive);
    }

    public void setActiveNoti(String name, boolean isActive) {
        this.notificationDao.setActiveNoti(name, isActive);
        this.onSettingChange(name, isActive);
    }

    private void onSettingChange(String name, boolean isActive) {
        if (!TextUtils.isEmpty((CharSequence)name) && this.visualCallback != null) {
            Constants.ReportAlarmType type = null;
            if (name.contains("daily")) {
                type = Constants.ReportAlarmType.DAILY;
            } else if (name.contains("weekly")) {
                type = Constants.ReportAlarmType.WEEKLY;
            } else if (name.contains("monthly")) {
                Constants.ReportAlarmType reportAlarmType = Constants.ReportAlarmType.MONTHLY;
            }
        }
    }

    public void updateNotiHour(String name, int hour) {
        this.notificationDao.updateNotiHour(name, hour);
    }

    public ArrayList<VisualNotification> loadNotifications() {
        return this.notificationDao.loadNotifications();
    }

    public VisualNotification loadNotification(int id2) {
        return this.notificationDao.loadNotification(id2);
    }

    public VisualNotification loadDailyNoti() {
        return this.notificationDao.loadNotification(Constants.ReportAlarmType.DAILY.name().toLowerCase());
    }

    public void updateNotiStatus(int id2, boolean enabled) {
        this.notificationDao.updateNotiStatus(id2, enabled);
    }

    public boolean isActiveTranPopup() {
        return this.prefManager.isEnabled("TENQUBE_TRAN_POPUP", false);
    }

    public void setTranPopup(boolean shouldShow) {
        this.prefManager.saveBoolean("TENQUBE_TRAN_POPUP", shouldShow);
    }

    public Currency loadCurrencyInfo(String from, String to) {
        return this.currencyDao.loadCurrencyInfo(from, to);
    }

    public void updateDeletedTransactionById(Integer[] ids) {
        this.transactionDao.updateDeletedTransactionById(ids);
    }

    private void deleteTransactions() {
        ArrayList<Integer> ids = this.transactionDao.loadDeletedTranIds();
        if (!Utils.isEmpty(ids)) {
            this.transactionDao.deleteTransactions(ids);
        }
    }

    public int insertTransaction(InsertTransactionRequest insertTransactionRequest) {
        return this.transactionDao.insertTransaction(insertTransactionRequest);
    }

    public JoinedTransaction loadJoinedTransaction(int tranId) {
        return this.transactionDao.loadJoinedTransaction(tranId);
    }

    public ArrayList<JoinedTransaction> loadJoinedTransactions() {
        return this.transactionDao.loadJoinedTransactions();
    }

    public int loadTranId(String identifier) {
        return this.transactionDao.loadTranId(identifier);
    }

    public com.tenqube.visual_third.entity.Transaction loadApplyAllTran(String keyword) {
        if (TextUtils.isEmpty((CharSequence)keyword)) {
            return null;
        }
        return this.transactionDao.loadApplyAllTran(keyword);
    }

    public ArrayList<Transactions.Transaction> loadTransactions(com.tenqube.visual_third.model.js.TransactionRequest transactionRequest) {
        if (transactionRequest.hasStartDay()) {
            transactionRequest.setStartDay(this.getStartDay());
        }
        ArrayList<JoinedTransaction> transactions = this.transactionDao.loadJoinedTransactions(transactionRequest);
        List<SenderTransaction> senderTransactions = this.senderTransactionDao.loadSendersByIdentifiers(this.getIdentifiers(transactions));
        return Mapper.toJsTransactions(this.context, transactions, this.toOwnerMap(senderTransactions));
    }

    private HashMap<String, Boolean> toOwnerMap(List<SenderTransaction> senderTransactions) {
        HashMap<String, Boolean> ownerMap = new HashMap<String, Boolean>();
        for (SenderTransaction senderTransaction : senderTransactions) {
            Boolean isOwner = ownerMap.get(senderTransaction.getIdentifier());
            if (isOwner != null && isOwner.booleanValue()) continue;
            ownerMap.put(senderTransaction.getIdentifier(), "com.lge.lgpay".equals(senderTransaction.getSender()));
        }
        return ownerMap;
    }

    private List<String> getIdentifiers(ArrayList<JoinedTransaction> transactions) {
        ArrayList<String> ids = new ArrayList<String>();
        for (JoinedTransaction joinedTransaction : transactions) {
            ids.add(joinedTransaction.getTransaction().getIdentifier() + "");
        }
        return ids;
    }

    public ArrayList<Transaction> loadAnalysisTransactions(com.tenqube.visual_third.model.js.TransactionRequest transactionRequest) {
        if (transactionRequest.hasStartDay()) {
            transactionRequest.setStartDay(this.getStartDay());
        }
        ArrayList<JoinedTransaction> transactions = this.transactionDao.loadJoinedTransactions(transactionRequest);
        return Mapper.toAnalysisTran(transactions);
    }

    public ArrayList<Transactions.Transaction> loadTransactions(TransactionByIdsRequest transactionRequest) {
        ArrayList<JoinedTransaction> transactions = this.transactionDao.loadJoinedTransactions(transactionRequest);
        List<SenderTransaction> senderTransactions = this.senderTransactionDao.loadSendersByIdentifiers(this.getIdentifiers(transactions));
        return Mapper.toJsTransactions(this.context, transactions, this.toOwnerMap(senderTransactions));
    }

    private TransactionRequest loadNotSyncedTransactions() {
        ArrayList<JoinedTransaction> transactions = this.transactionDao.loadNotSyncedTransactions();
        if (!transactions.isEmpty()) {
            return new TransactionRequest(Mapper.toApiTransactions(transactions));
        }
        return null;
    }

    public ArrayList<Cards.Card> loadCards() {
        ArrayList<Card> cards = this.cardDao.loadCards();
        return Mapper.toJsCards(cards);
    }

    private void deleteCard() {
        this.cardDao.deleteAll();
    }

    private void insertCash() {
        this.cardDao.insertCash();
    }

    public ArrayList<CategoryInfo.ServerCategory> loadCategories() {
        ArrayList<Category> categories = this.categoryDao.loadCategories();
        return Mapper.toJsCategories(categories);
    }

    public Category loadCategory(String categoryCode) {
        return this.categoryDao.loadCategory(categoryCode);
    }

    public ArrayList<CategoryInfo.UserCategory> loadUserCategories() {
        ArrayList<UserCategory> categories = this.userCategoryDao.loadUserCategories();
        return Mapper.toJsUserCategories(categories);
    }

    public ArrayList<NotificationApp> loadNotiCatchedApps() {
        ArrayList<NotificationApp> results = this.notificationAppDao.findAll();
        if (results.isEmpty()) {
            this.notificationAppDao.insertNotificationApp(this.context);
        }
        return this.notificationAppDao.findAll();
    }

    private void updateSyncedTransactions(TransactionRequest transactionRequest) {
        ArrayList<String> ids = new ArrayList<String>();
        ArrayList<TransactionRequest.Transaction> transactions = transactionRequest.getTransactions();
        for (TransactionRequest.Transaction tran : transactions) {
            ids.add(tran.getIdentifier());
        }
        this.transactionDao.updateSyncedTransactions(ids);
    }

    public void updateTransaction(UpdateTransactionRequest updateTransactionRequest) {
        this.transactionDao.updateTransaction(updateTransactionRequest);
    }

    private int loadCardId(String cardName, int cardType, int cardSubType) {
        int cardId = this.cardDao.getCardId(cardName, cardType, cardSubType);
        if (cardId == -1) {
            cardId = this.cardDao.insert(cardName, cardType, cardSubType);
        }
        return cardId;
    }

    public void mergeTransactions(ArrayList<com.tenqube.visual_third.model.parser.Transaction> transactions) {
        try {
            for (com.tenqube.visual_third.model.parser.Transaction parsedTran : transactions) {
                int cardId = this.loadCardId(parsedTran.getParsedTransaction().cardName, parsedTran.getParsedTransaction().cardType, parsedTran.getParsedTransaction().cardSubType);
                parsedTran.setCardId(cardId);
                int userCateId = this.userCategoryDao.getCategoryId(parsedTran.getParsedTransaction().dwType == Constants.DWType.DEPOSIT.ordinal() ? "901010" : "101010");
                parsedTran.setUserCateId(userCateId);
                this.senderTransactionDao.insert(parsedTran.getParsedTransaction().sender, parsedTran.getParsedTransaction().identifier);
                this.transactionDao.mergeTransaction(parsedTran);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void insertTransaction(SyncTransaction syncTransaction) {
        try {
            int cardId = this.loadCardId(syncTransaction.cardName, syncTransaction.cardType, syncTransaction.cardSubType);
            String repCode = syncTransaction.categoryCode / 10000 + "1010";
            int userCateId = this.userCategoryDao.getCategoryId(repCode);
            if (cardId != -1 && userCateId != -1) {
                this.transactionDao.insertTransaction(syncTransaction, cardId, userCateId);
                this.senderTransactionDao.insert(syncTransaction.sender, syncTransaction.identifier);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void updateTransactions(SearchCompanyResponse response) {
        try {
            for (SearchCompanyResponse.TranCompany tranCompany : response.getResults()) {
                int userCateId = this.userCategoryDao.getCategoryId(tranCompany.getCategory().getRepCode());
                this.transactionDao.updateTransaction(tranCompany, userCateId);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void updateTransaction(SearchCompanyResponse.TranCompany tranCompany, boolean isAll) {
        try {
            int userCateId = this.userCategoryDao.getCategoryId(tranCompany.getCategory().getRepCode());
            if (isAll) {
                this.transactionDao.updateTransactionByKeyword(tranCompany, userCateId);
            } else {
                this.transactionDao.updateTransaction(tranCompany, userCateId);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void saveStartDay(int startDay) {
        this.prefManager.saveIntValue("TENQUBE_START_DAY", startDay);
    }

    public int getStartDay() {
        return this.prefManager.loadIntValue("TENQUBE_START_DAY", 1);
    }

    public int insertCard(String name, int type) {
        return this.cardDao.insert(name, type, 0);
    }

    public boolean isDev() {
        return "dev".equals(this.prefManager.loadStringValue("TENQUBE_QUALIFIER", "dev"));
    }

    public boolean shouldBulk() {
        return !this.prefManager.isEnabled("TENQUBE_BULK_EXECUTED_2", false);
    }

    public void saveBulk() {
        this.prefManager.saveBoolean("TENQUBE_BULK_EXECUTED_2", true);
    }

    public String getAuthority() {
        return this.prefManager.loadStringValue("TENQUBE_AUTHORITY", this.context.getApplicationContext().getPackageName());
    }

    public String getAdType() {
        return this.prefManager.loadStringValue("TENQUBE_AD_RATIO", "2:8");
    }

    public void setAppNoti(boolean isActive) {
        this.prefManager.saveBoolean("TENQUBE_APP_NOTI", isActive);
    }

    public boolean isAppNoti() {
        return this.prefManager.isEnabled("TENQUBE_APP_NOTI", true);
    }

    public boolean isJoined() {
        return !TextUtils.isEmpty((CharSequence)this.secretKeyManager.getKey("TENQUBE_ACCESS_TOKEN"));
    }
}

