package com.tenqube.visual_third.util;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;

/**
 * Created by tenqube on 2016. 8. 30..
 */

public class GoOpenMarketUtil {

    private static final String MARKET_GOOGLE_URL = "market://details?id=";
    private static final String WEB_GOOGLE_URL = "http://play.google.com/store/apps/details?id=";


    private static void openOnMarket(String market, String web, Context context, String packageName) {

        try {
            Intent intent = new Intent(Intent.ACTION_VIEW, Uri.parse(market + packageName));
            intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
            context.startActivity(intent);
        } catch (android.content.ActivityNotFoundException anfe) {
            Intent intent = new Intent(Intent.ACTION_VIEW, Uri.parse(web + packageName));
            intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
            context.startActivity(intent);
        }

    }
    private static void openOnMarket(String market, String web, Context context) {

        try {
            Intent intent = new Intent(Intent.ACTION_VIEW, Uri.parse(market));
            intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
            context.startActivity(intent);
        } catch (android.content.ActivityNotFoundException anfe) {
            Intent intent = new Intent(Intent.ACTION_VIEW, Uri.parse(web));
            intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
            context.startActivity(intent);
        }

    }

    public static void openOnGooglePlayMarket(Context context, String packageName) {
        openOnMarket(MARKET_GOOGLE_URL, WEB_GOOGLE_URL, context, packageName);
    }


}
