package com.tenqube.visual_third.ui;

import android.app.Activity;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Handler;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.Switch;
import android.widget.TextView;

import com.tenqube.visual_third.R;


public class NotiIntroActivity extends Activity {

    public static final String TAG = "NotiIntroActivity";

    private Switch switch1;
    private boolean mEnable;
    private Handler handler;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        setContentView(R.layout.visual_activity_noti_intro);

        setAppInfo();

        final Button nextButton = findViewById(R.id.next);
        switch1 = findViewById(R.id.visual_switch_1);

        startAnimation();

        nextButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                finish();
            }
        });
    }

    private void setAppInfo() {
        PackageManager packageManager = getApplicationContext().getPackageManager();

        try {
            ImageView logoImageView = findViewById(R.id.visual_logo);
            TextView appNameTextView = findViewById(R.id.visual_app_name);

            String pkgName = getApplicationContext().getPackageName();
            ApplicationInfo appInfo = packageManager.getApplicationInfo(pkgName, PackageManager.GET_META_DATA);
            Drawable icon = packageManager.getApplicationIcon(pkgName);
            logoImageView.setImageDrawable(icon);
            String appName = (String) packageManager.getApplicationLabel(appInfo);
            appNameTextView.setText(appName);

            TextView descTextView = findViewById(R.id.visual_description);
            descTextView.setText(getString(R.string.visual_notification_catch_dialog_title, appName));

        } catch (PackageManager.NameNotFoundException e) {

        }
    }

    private void startAnimation(){

        if(switch1 != null) {
            switch1.setChecked(!mEnable);
        }

        handler = new Handler();
        handler.postDelayed(repeatRunnable, 600);
    }

    private Runnable repeatRunnable = new Runnable() {
        @Override
        public void run() {
            setSwitch(switch1);
            if (!isFinishing()) handler.postDelayed(this, 2*1000);
            mEnable = !mEnable;
        }
    };

    private void setSwitch(final Switch switch1) {
        if(switch1 != null) {

            if(!mEnable) {
                switch1.setVisibility(View.INVISIBLE);
                switch1.setChecked(mEnable);
                Handler handler = new Handler();
                handler.postDelayed(new Runnable() {
                    @Override
                    public void run() {
                        switch1.setVisibility(View.VISIBLE);
                    }
                }, 250);
            } else {
                switch1.setChecked(true);
            }


        }
    }


}
