package com.tenqube.visual_third.api.resource;

import com.tenqube.visual_third.Constants;
import com.tenqube.visual_third.manager.SignatureManager;
import com.tenqube.visual_third.model.api.AnalysisResponse;
import com.tenqube.visual_third.model.api.NotificationPkgResponse;
import com.tenqube.visual_third.model.api.NotificationResponse;
import com.tenqube.visual_third.model.api.ParsingRuleKey;
import com.tenqube.visual_third.model.api.ParsingRuleResponse;
import com.tenqube.visual_third.model.api.SyncCategoryResponse;
import com.tenqube.visual_third.model.api.VersionResponse;
import com.tenqube.visual_third.util.Utils;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.IOException;

import okhttp3.ResponseBody;
import retrofit2.Response;
import tenqube.parser.model.ParsingRule;

public class ResourceServiceImpl implements ResourceService {

    private static final String TAG = ResourceServiceImpl.class.getSimpleName();

    private final ResourceApi resourceApi;

    private final SignatureManager signatureManager;

    private ResourceServiceImpl(ResourceApi resourceApi, SignatureManager signatureManager) {

        this.resourceApi = resourceApi;
        this.signatureManager = signatureManager;
    }

    private static ResourceService mInstance;

    public static ResourceService getInstance(ResourceApi resourceApi, SignatureManager signatureManager) {
        synchronized (ResourceServiceImpl.class) {
            if (mInstance == null) {
                mInstance = new ResourceServiceImpl(resourceApi, signatureManager);
            }
        }
        return mInstance;
    }

    @Override
    public VersionResponse syncVersion() {
        try {
            Response<VersionResponse> response = resourceApi.syncVersion().execute();
            if (response != null) {
                if (response.isSuccessful()) {
                    return response.body();
                }
            }

        } catch (IOException e) {

        }

        return null;

    }

    @Override
    public SyncCategoryResponse syncCategory(int clientVersion, int serverVersion) {
        if(serverVersion > clientVersion) {

            try {
                Response<SyncCategoryResponse> response = resourceApi.syncCategory(ResourceApi.CATEGORY,
                        clientVersion,
                        serverVersion).execute();

                if (response.isSuccessful()) {
                    return response.body();
                }
            } catch (Exception e) {

            }

        }

        return null;
    }

    @Override
    public NotificationPkgResponse syncNotificationApps() {

        try {
            Response<NotificationPkgResponse> response = resourceApi.syncNotificationApps().execute();

            if (response.isSuccessful()) {

                return response.body();
            }
        } catch (Exception e) {
        }

        return null;

    }

    @Override
    public AnalysisResponse syncAnalysis(int clientVersion, int serverVersion) {
        if(serverVersion > clientVersion) {

            try {
                Response<AnalysisResponse> response = resourceApi.syncAnalysis(ResourceApi.ANALYSIS,
                        clientVersion,
                        serverVersion).execute();

                if (response.isSuccessful()) {

                    return response.body();
                }
            } catch (Exception e) {

            }

        }

        return null;
    }

    @Override
    public NotificationResponse syncNotification() {
        try {
            Response<NotificationResponse> response = resourceApi.syncNotification().execute();

            if (response.isSuccessful()) {

                return response.body();
            }
        } catch (Exception e) {

        }

        return null;
    }

    @Override
    public ParsingRule syncParsingRule(int clientVersion, int serverVersion) {
        try {

             Utils.LOGD("syncParsingRule", "syncParsingRule" + clientVersion + "server" + serverVersion);

            if(serverVersion > clientVersion) {
                Response<ResponseBody> ruleResponse = resourceApi.syncParsingRule(
                        ResourceApi.PARSING_RULE,
                        clientVersion,
                        serverVersion).execute();


                if(ruleResponse.isSuccessful()) {
                    ResponseBody response = ruleResponse.body();

                    if(response != null) {
                        try {
                            JSONObject jsonObject = new JSONObject(response.string());
                            String signature = jsonObject.getString("signature");
                            String resource = jsonObject.getString("resource");

                            ParsingRuleResponse parsingRuleResponse = Utils.fromJson(resource, ParsingRuleResponse.class);

                            boolean isValid = signatureManager.isValid(clientVersion, parsingRuleResponse.securityKey, serverVersion, resource, signature);
                             Utils.LOGD(Constants.VISUAL_TAG, "syncParsingRule/" + "isValid" + isValid);

                            if(isValid) {
                                ParsingRule parsingRule = new ParsingRule(parsingRuleResponse.securityKey,
                                        parsingRuleResponse.tranCount,
                                        parsingRuleResponse.ruleVersion,
                                        parsingRuleResponse.regDatas,
                                        parsingRuleResponse.senders,
                                        parsingRuleResponse.banks);

                                return parsingRule;
                            }
                        } catch (JSONException e) {
                        }

                    }
                }
            }

        } catch (IOException e) {

        }

        return null;
    }

    @Override
    public ParsingRuleKey syncParsingRuleKey() {

        try {
            Response<ParsingRuleKey> response = resourceApi.syncParsingRuleKey().execute();
            if (response != null) {
                if (response.isSuccessful()) {
                    return response.body();
                }
            }

        } catch (IOException e) {

        }
        return null;
    }

}
