package com.tenqube.visual_third.api;

import android.text.TextUtils;

import com.tenqube.visual_third.manager.PrefManager;

import java.io.IOException;

import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

import static com.tenqube.visual_third.api.search.SearchHeaderInterceptor.X_API_KEY;

public class ApiKeyInterceptor implements Interceptor {

    private final PrefManager prefManager;

    public ApiKeyInterceptor(PrefManager prefManager) {
        this.prefManager = prefManager;
    }

    @Override
    public Response intercept(Chain chain) throws IOException {

        String apiKey = prefManager.loadStringValue(PrefManager.API_KEY, "");
        if(TextUtils.isEmpty(apiKey)) {
            throw new IOException("apiKey is empty");
        }
        Request.Builder builder = chain.request()
                .newBuilder()
                .addHeader(X_API_KEY, apiKey);

        return chain.proceed(builder.build());
    }



}
