/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.model.js;

import com.tenqube.visual_third.exception.ParameterException;
import com.tenqube.visual_third.model.js.Request;
import com.tenqube.visual_third.util.Validator;
import java.io.Serializable;

public class TransactionRequest
extends Request
implements Serializable {
    private int year;
    private int month;
    private int before;
    private boolean hasStartDay;
    private String callbackJS;
    private int startDay = 1;
    private int dwType;
    private int exceptType;

    public TransactionRequest(int year, int month, int before, boolean hasStartDay, String callbackJS) {
        this.year = year;
        this.month = month;
        this.before = before;
        this.hasStartDay = hasStartDay;
        this.callbackJS = callbackJS;
    }

    public boolean hasStartDay() {
        return this.hasStartDay;
    }

    public int getStartDay() {
        return this.startDay == 0 ? 1 : this.startDay;
    }

    public void setStartDay(int startDay) {
        this.startDay = startDay;
    }

    public int getDwType() {
        return this.dwType;
    }

    public void setDwType(int dwType) {
        this.dwType = dwType;
    }

    public int getExceptType() {
        return this.exceptType;
    }

    public void setExceptType(int exceptType) {
        this.exceptType = exceptType;
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public int getBefore() {
        return this.before;
    }

    public String getCallbackJS() {
        return this.callbackJS;
    }

    @Override
    public void checkParams() throws ParameterException {
        Validator.gt(this.year, 2010);
        Validator.lt(this.month, 12);
        Validator.gt(this.month, 1);
        Validator.lt(this.before, 12);
        Validator.notNull(this.callbackJS);
    }

    public String toString() {
        return "TransactionRequest{year=" + this.year + ", month=" + this.month + ", before=" + this.before + ", hasStartDay=" + this.hasStartDay + ", callbackJS='" + this.callbackJS + '\'' + ", startDay=" + this.startDay + ", dwType=" + this.dwType + ", exceptType=" + this.exceptType + '}';
    }
}

