/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.api.auth;

import android.content.Context;
import com.tenqube.visual_third.api.auth.AuthApi;
import com.tenqube.visual_third.api.auth.AuthService;
import com.tenqube.visual_third.api.data.ResultBody;
import com.tenqube.visual_third.api.data.Token;
import com.tenqube.visual_third.manager.PrefManager;
import com.tenqube.visual_third.manager.SecretKeyManager;
import com.tenqube.visual_third.model.api.UserRequest;
import com.tenqube.visual_third.model.api.UserResult;
import com.tenqube.visual_third.util.Validator;
import java.io.IOException;
import java.util.Calendar;
import retrofit2.Response;

public class AuthServiceImpl
implements AuthService {
    private static final String TAG = AuthServiceImpl.class.getSimpleName();
    private final AuthApi authApi;
    private final PrefManager prefManager;
    private final SecretKeyManager secretKeyManager;
    private final Context context;
    private static AuthService mInstance;

    private AuthServiceImpl(Context context, AuthApi authApi, PrefManager prefManager, SecretKeyManager secretKeyManager) {
        this.context = context;
        this.authApi = authApi;
        this.prefManager = prefManager;
        this.secretKeyManager = secretKeyManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AuthService getInstance(Context context, AuthApi authApi, PrefManager prefManager, SecretKeyManager secretKeyManager) {
        Class<AuthService> clazz = AuthService.class;
        synchronized (AuthService.class) {
            if (mInstance == null) {
                mInstance = new AuthServiceImpl(context, authApi, prefManager, secretKeyManager);
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return mInstance;
        }
    }

    @Override
    public boolean signUp(UserRequest request) throws IOException {
        ResultBody result;
        Response response = this.authApi.signUp(request).execute();
        if (response.isSuccessful() && (result = (ResultBody)response.body()) != null && result.results != null) {
            this.saveUserInfo(request, (UserResult)result.results);
            return true;
        }
        return false;
    }

    @Override
    public boolean reissueToken() throws Exception {
        String refreshToken = this.secretKeyManager.getKey("TENQUBE_REFRESH_TOKEN");
        Validator.isNotEmpty(refreshToken);
        Response result = this.authApi.reissueToken(refreshToken).execute();
        if (result.isSuccessful()) {
            ResultBody results = (ResultBody)result.body();
            if (results != null && results.results != null) {
                this.saveToken((Token)results.results);
                return true;
            }
        } else {
            UserRequest userRequest;
            boolean success;
            int statusCode = result.code();
            if (statusCode == 403) {
                this.signOut();
            } else if (statusCode == 401 && (success = this.signUp(userRequest = new UserRequest(this.prefManager.loadStringValue("TENQUBE_USER_ID", ""), this.prefManager.loadStringValue("TENQUBE_USER_AD_ID", ""))))) {
                return true;
            }
        }
        return false;
    }

    @Override
    public String getAccessToken() {
        return this.secretKeyManager.getKey("TENQUBE_ACCESS_TOKEN");
    }

    private void saveUserInfo(UserRequest user, UserResult response) {
        if (user != null) {
            this.prefManager.saveStringValue("TENQUBE_USER_ID", user.getUid());
            this.prefManager.saveStringValue("TENQUBE_USER_AD_ID", user.getAdId());
        }
        tenqube.parser.core.SecretKeyManager.getInstance((Context)this.context).saveKey(response.getSecretKey());
        this.saveToken(response.getAuthorization().getSdk());
        this.prefManager.saveStringValue("TENQUBE_RESOURCE_URL", response.getResource().getUrl());
        this.prefManager.saveStringValue("TENQUBE_RESOURCE_API_KEY", response.getResource().getApiKey());
        this.prefManager.saveStringValue("TENQUBE_SEARCH_URL", response.getSearch().getUrl());
        this.prefManager.saveStringValue("TENQUBE_SEARCH_API_KEY", response.getSearch().getApiKey());
        this.prefManager.saveLongValue("TENQUBE_SIGN_UP_TIME", Calendar.getInstance().getTimeInMillis());
        if (response.getWeb() != null) {
            this.prefManager.saveStringValue("TENQUBE_WEB_URL", response.getWeb().getUrl());
        }
    }

    private void saveToken(Token token) {
        if (token == null) {
            return;
        }
        this.secretKeyManager.save("TENQUBE_REFRESH_TOKEN", token.getAccess());
        this.secretKeyManager.save("TENQUBE_ACCESS_TOKEN", token.getRefresh());
    }

    @Override
    public void signOut() {
        this.prefManager.saveStringValue("TENQUBE_REFRESH_TOKEN", "");
        this.prefManager.saveStringValue("TENQUBE_ACCESS_TOKEN", "");
    }
}

