package com.tenqube.visual_third.model.js;

import com.tenqube.visual_third.exception.ParameterException;

import java.io.Serializable;
import java.util.ArrayList;

import static com.tenqube.visual_third.util.Validator.notNull;

public class ConfirmBoxRequest extends Request implements Serializable {

    private String message;
    private ArrayList<ConfirmBox> data;

    public String getMessage() {
        return message;
    }

    public ArrayList<ConfirmBox> getData() {
        return data;
    }

    @Override
    public void checkParams() throws ParameterException {
        notNull(data);
    }

    public static class ConfirmBox implements Serializable {

        private String buttonText;
        private String callbackJS;

        public String getButtonText() {
            return buttonText;
        }

        public String getCallbackJS() {
            return callbackJS;
        }
    }
}
