package com.tenqube.visual_third.repository;

import android.content.Context;
import androidx.annotation.Nullable;

import com.tenqube.visual_third.db.Db;
import com.tenqube.visual_third.db.dao.AdvertisementDao;
import com.tenqube.visual_third.db.dao.CardDao;
import com.tenqube.visual_third.db.dao.CategoryDao;
import com.tenqube.visual_third.db.dao.ContentsDao;
import com.tenqube.visual_third.db.dao.CurrencyDao;
import com.tenqube.visual_third.db.dao.NotificationAppDao;
import com.tenqube.visual_third.db.dao.NotificationDao;
import com.tenqube.visual_third.db.dao.TransactionDao;
import com.tenqube.visual_third.db.dao.UserCategoryDao;
import com.tenqube.visual_third.manager.PrefManager;
import com.tenqube.visual_third.manager.SecretKeyManager;
import com.tenqube.visual_third.manager.SignatureManager;
import com.tenqube.visual_third.util.AppExecutors;
import com.tenqube.visual_third.util.VisualInjection;

import tenqube.parser.core.ParserService;

public class RepositoryHolder {


    private Context context;

    private VisualRepository visualRepository;

    @Nullable
    private ResourceRepository resourceRepository;

    private AnalysisRepository analysisRepository;

    private static RepositoryHolder mInstance;

    private Db db;

    private AppExecutors appExecutor;

    private PrefManager prefManager;

    private NotificationAppDao notificationAppDao;

    private AdvertisementDao advertisementDao;

    private NotificationDao notificationDao;

    private CategoryDao categoryDao;

    private ContentsDao contentsDao;

    private SecretKeyManager secretKeyManager;

    private SignatureManager signatureManager;

    public static RepositoryHolder getInstance(Context context){
        synchronized (RepositoryHolder.class) {
            if(mInstance == null){
                mInstance = new RepositoryHolder(context);
            }
        }
        return mInstance;
    }

    private RepositoryHolder(Context context) {

        this.context = context;
        prefManager = VisualInjection.providePrefManager(context);
        db = VisualInjection.provideDb(context);
        appExecutor = VisualInjection.provideAppExecutors();
        secretKeyManager = VisualInjection.provideSecretKeyManager(context);

        notificationAppDao = VisualInjection.provideNotificationAppDao(db);

        advertisementDao = VisualInjection.provideAdvertisementDao(db);

        notificationDao = VisualInjection.provideNotificationDao(db);

        CurrencyDao currencyDao = VisualInjection.provideCurrencyDao(db);

        UserCategoryDao userCategoryDao = VisualInjection.provideUserCategoryDao(db);

        TransactionDao transactionDao = VisualInjection.provideTransactionDao(db);

        categoryDao = VisualInjection.provideCategoryDao(db);

        CardDao cardDao = VisualInjection.provideCardDao(db);

        contentsDao = VisualInjection.provideContentsDao(db);


        visualRepository = VisualInjection.provideVisualRepository(context,
                prefManager,
                cardDao,
                categoryDao,
                transactionDao,
                userCategoryDao,
                currencyDao,
                notificationDao,
                advertisementDao,
                notificationAppDao,
                appExecutor,
                secretKeyManager);

        ParserService parserService = VisualInjection.provideParserService(context);

        SignatureManager signatureManager = VisualInjection.provideSignatureManager();
        resourceRepository = VisualInjection.provideResourceRepository(prefManager,
                parserService,
                appExecutor,
                notificationAppDao,
                categoryDao,
                notificationDao,
                contentsDao,
                signatureManager);

        analysisRepository = VisualInjection.provideAnalysisRepository(contentsDao);

    }

    public VisualRepository getVisualRepository() {
        return visualRepository;
    }

    public ResourceRepository getResourceRepository() {
        return resourceRepository;
    }

    public AnalysisRepository getAnalysisRepository() {
        return analysisRepository;
    }


}
