/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.ui;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Configuration;
import android.graphics.Color;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.Parcelable;
import android.text.TextUtils;
import android.view.View;
import android.webkit.WebResourceRequest;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.LinearLayout;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatActivity;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout;
import com.tenqube.visual_third.Constants;
import com.tenqube.visual_third.R;
import com.tenqube.visual_third.VisualServiceImpl;
import com.tenqube.visual_third.analysis.AnalysisServiceImpl;
import com.tenqube.visual_third.exception.AuthException;
import com.tenqube.visual_third.exception.ParameterException;
import com.tenqube.visual_third.manager.ExcelManager;
import com.tenqube.visual_third.manager.PrefManager;
import com.tenqube.visual_third.manager.SecretKeyManager;
import com.tenqube.visual_third.manager.VisualAlarmManager;
import com.tenqube.visual_third.model.parser.PopupData;
import com.tenqube.visual_third.parser.loader.BulkLoader;
import com.tenqube.visual_third.repository.RepositoryHolder;
import com.tenqube.visual_third.repository.ResourceRepository;
import com.tenqube.visual_third.repository.VisualRepository;
import com.tenqube.visual_third.ui.BottomDialog;
import com.tenqube.visual_third.ui.DatePickerFragment;
import com.tenqube.visual_third.ui.TimePickerFragment;
import com.tenqube.visual_third.ui.VisualPermissionActivity;
import com.tenqube.visual_third.util.PathUtil;
import com.tenqube.visual_third.util.Utils;
import com.tenqube.visual_third.util.Validator;
import com.tenqube.visual_third.util.WebViewHelper;
import com.tenqube.visual_third.util.permission.AfterPermissionGranted;
import com.tenqube.visual_third.util.permission.PermissionUtil;
import com.tenqube.visual_third.web.ActionImpl;
import com.tenqube.visual_third.web.Completion;
import com.tenqube.visual_third.web.ErrorImpl;
import com.tenqube.visual_third.web.LogImpl;
import com.tenqube.visual_third.web.RepoImpl;
import com.tenqube.visual_third.web.SystemImpl;
import com.tenqube.visual_third.web.UiImpl;
import com.tenqube.visual_third.web.VisualInterface;
import java.io.File;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class VisualWebActivity
extends AppCompatActivity
implements TimePickerFragment.Callback,
DatePickerFragment.Callback,
PermissionUtil.PermissionCallbacks {
    public static final String ARG_PATH = "ARG_PATH";
    public static final String ACTION_BROADCAST_TRANSACTION = "ACTION_BROADCAST_TRANSACTION";
    public static final String TAG = VisualServiceImpl.class.getSimpleName();
    public static final int NOTIFICATION_REQUEST_CODE = 10;
    public static final int VISUAL_REQUEST_CODE = 512;
    public static final int PERMISSION_REQUEST_CODE = 0;
    public static final int FINISH = 10;
    public static final int PROGRESS = 11;
    public static final int SHOW_PROGRESS_BAR = 12;
    public static final int ERROR = 13;
    public static final int SYNC_ERROR = 14;
    public static final int SYNC_PROGRESS = 15;
    public static final int SHOW_SYNC_PROGRESS_BAR = 16;
    public static final int CLOSE_SYNC_PROGRESS_BAR = 17;
    private BulkLoader bulkLoader;
    private VisualRepository repository;
    private ResourceRepository resourceRepository;
    private VisualAlarmManager alarmManager;
    private boolean isPageLoaded;
    private String mFailingUrl;
    private String baseUrl = "";
    private String webUrl = "";
    private String path;
    private WebView webview;
    private VisualInterface.Repo repoInterface;
    private VisualInterface.UI uiInterface;
    private VisualInterface.System systemInterface;
    private VisualInterface.Error errorInterface;
    private VisualInterface.Log logInterface;
    private VisualInterface.Action actionInterface;
    private SwipeRefreshLayout swipeRefreshLayout;
    private LinearLayout errorView;
    private boolean isError;
    private PrefManager prefManager;
    private boolean isLoading;
    private long startTime;
    private BroadcastReceiver transactionReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            try {
                final int tranId = intent.getIntExtra("tranId", 0);
                VisualWebActivity.this.webview.post(new Runnable(){

                    @Override
                    public void run() {
                        if (tranId != 0) {
                            VisualWebActivity.this.webview.loadUrl("javascript:window.onTransactionReceived(" + tranId + ");");
                        }
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    };
    private Handler handler = new Handler(new Handler.Callback(){

        public boolean handleMessage(Message msg) {
            try {
                switch (msg.what) {
                    case 11: {
                        Bundle bundle;
                        if (VisualWebActivity.this.webview != null && (bundle = msg.getData()) != null) {
                            VisualWebActivity.this.webview.loadUrl("javascript:window.onProgress(" + bundle.getInt("now") + "," + bundle.getInt("total") + ");");
                        }
                        break;
                    }
                    case 15: {
                        break;
                    }
                    case 12: {
                        VisualWebActivity.this.isLoading = true;
                        Utils.LOGD("BulkHandler", "startBulk handleMessage SHOW_PROGRESS_BAR");
                        VisualWebActivity.this.loadProgressUrl(Constants.ProgressType.BULK);
                        break;
                    }
                    case 16: {
                        VisualWebActivity.this.loadProgressUrl(Constants.ProgressType.SYNC);
                        VisualWebActivity.this.isLoading = true;
                        break;
                    }
                    case 17: {
                        VisualWebActivity.this.isLoading = false;
                        break;
                    }
                    case 14: {
                        VisualWebActivity.this.onSyncError();
                        VisualWebActivity.this.onBulkFinish(false, false);
                        break;
                    }
                    case 10: {
                        VisualWebActivity.this.onBulkFinish(true, true);
                        break;
                    }
                    default: {
                        VisualWebActivity.this.onBulkFinish(false, true);
                    }
                }
            }
            catch (Exception e) {
                VisualWebActivity.this.onBulkFinish(false, true);
            }
            return false;
        }
    });
    public static final String[] PERMISSIONS_STORAGE = new String[]{"android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE"};
    public static final int STORAGE = 1;
    public Completion<Boolean> completion;

    @SuppressLint(value={"JavascriptInterface", "AddJavascriptInterface", "SetJavaScriptEnabled"})
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        try {
            this.startTime = System.currentTimeMillis();
            this.prefManager = PrefManager.getInstance(this.getApplicationContext());
            Utils.LOGD("onCreate", "start VisualActivity");
            if (Utils.isSDKDisabled(this.getApplicationContext())) {
                throw new Exception("SDK disabled");
            }
            this.repository = RepositoryHolder.getInstance(this.getApplicationContext()).getVisualRepository();
            this.resourceRepository = RepositoryHolder.getInstance(this.getApplicationContext()).getResourceRepository();
            this.alarmManager = VisualAlarmManager.getInstance(this.getApplicationContext());
            this.path = this.getIntent().getStringExtra(ARG_PATH);
            if (this.path == null) {
                this.path = "";
            }
            this.setContentView(R.layout.activity_visual_web);
            this.swipeRefreshLayout = (SwipeRefreshLayout)this.findViewById(R.id.swipe_refresh_layout);
            this.swipeRefreshLayout.setEnabled(false);
            this.swipeRefreshLayout.setColorSchemeResources(new int[]{R.color.colorPopupRed, R.color.colorPopupRed, R.color.colorPopupRed});
            this.swipeRefreshLayout.setOnRefreshListener(new SwipeRefreshLayout.OnRefreshListener(){

                public void onRefresh() {
                    VisualWebActivity.this.swipeRefreshLayout.setRefreshing(false);
                    AnalysisServiceImpl.shouldRefresh = true;
                    VisualWebActivity.this.webview.reload();
                }
            });
            this.errorView = (LinearLayout)this.findViewById(R.id.error_container);
            this.errorView.setVisibility(8);
            this.findViewById(R.id.retry).setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    VisualWebActivity.this.retry();
                }
            });
            this.webview = (WebView)this.findViewById(R.id.visual_web_view);
            this.errorInterface = new ErrorImpl(this, this.webview);
            this.logInterface = new LogImpl(this, this.webview, this.errorInterface);
            this.repoInterface = new RepoImpl(this, this.webview, this.errorInterface, this.repository, new AnalysisServiceImpl((Context)this, ""), this.alarmManager);
            this.uiInterface = new UiImpl(this, this.webview, this.errorInterface, new BottomDialog((Activity)this));
            this.systemInterface = new SystemImpl(this, this.webview, this.errorInterface);
            this.actionInterface = new ActionImpl(this, this.webview);
            this.webview.setBackgroundColor(0);
            this.webview.addJavascriptInterface((Object)this.errorInterface, "visualError");
            this.webview.addJavascriptInterface((Object)this.repoInterface, "visualRepo");
            this.webview.addJavascriptInterface((Object)this.uiInterface, "visualUI");
            this.webview.addJavascriptInterface((Object)this.systemInterface, "visualSystem");
            this.webview.addJavascriptInterface((Object)this.logInterface, "visualLog");
            this.webview.addJavascriptInterface((Object)this.actionInterface, "visualAction");
            WebViewHelper.settings(this.webview, this.repository.isDev());
            this.webview.setWebViewClient(new WebViewClient(){

                public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
                    Utils.LOGD("shouldOverrideUrlLoading", "\uc218\ud589\uc2dc\uac04: " + (System.currentTimeMillis() - VisualWebActivity.this.startTime) / 1000L + "\ucd08");
                    if (!view.getUrl().contains(VisualWebActivity.this.webUrl)) {
                        VisualWebActivity.this.finish();
                        return true;
                    }
                    return super.shouldOverrideUrlLoading(view, request);
                }

                public boolean shouldOverrideUrlLoading(WebView view, String url) {
                    if (!url.contains(VisualWebActivity.this.webUrl)) {
                        VisualWebActivity.this.finish();
                        return true;
                    }
                    return super.shouldOverrideUrlLoading(view, url);
                }

                public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
                    VisualWebActivity.this.isError = true;
                    VisualWebActivity.this.mFailingUrl = failingUrl;
                    VisualWebActivity.this.loadErrorUrl();
                }

                public void onPageFinished(WebView view, String url) {
                    if (!VisualWebActivity.this.isError) {
                        VisualWebActivity.this.errorView.setVisibility(8);
                    }
                    VisualWebActivity.this.isError = false;
                    Utils.LOGD("onPageFinished", "\uc218\ud589\uc2dc\uac04: " + (System.currentTimeMillis() - VisualWebActivity.this.startTime) / 1000L + "\ucd08, url:" + url);
                    super.onPageFinished(view, url);
                }
            });
            if (this.shouldRequestOverlayPermission()) {
                VisualPermissionActivity.startActivity((Activity)this, 0);
            } else {
                this.startVisual();
            }
        }
        catch (Exception e) {
            this.finish();
        }
    }

    private void startVisual() {
        this.loadUrl(this.path);
        if (this.repository.shouldBulk()) {
            this.startBulkParsing(true);
        } else {
            this.alarmManager.setAlarms();
            this.resourceRepository.sync();
        }
    }

    private void onSyncError() {
        if (this.isLoading) {
            this.webview.postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (VisualWebActivity.this.webview != null) {
                        VisualWebActivity.this.webview.loadUrl("javascript:window.onSyncError();");
                    }
                }
            }, 200L);
        }
    }

    private void onBulkFinish(boolean isSuccess, boolean shouldReload) {
        Utils.LOGD("BulkHandler", "onBulkFinish");
        this.isLoading = false;
        this.repository.saveBulk();
        if (this.webview != null && shouldReload) {
            this.startVisual();
        }
        if (this.completion != null) {
            this.completion.onDataLoaded(isSuccess);
            this.completion = null;
        }
    }

    private void startBulkParsing(final boolean isInit) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    if (isInit) {
                        VisualWebActivity.this.handler.sendEmptyMessage(16);
                    } else {
                        VisualWebActivity.this.handler.sendEmptyMessage(12);
                    }
                    VisualWebActivity.this.bulkLoader = new BulkLoader((Context)VisualWebActivity.this, VisualWebActivity.this.handler, new BulkLoader.OnSmsLoadFinished(){

                        @Override
                        public void onFinished(boolean isError) {
                            try {
                                if (VisualWebActivity.this.handler != null) {
                                    VisualWebActivity.this.handler.sendEmptyMessage(10);
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    });
                    VisualWebActivity.this.bulkLoader.doParsing(isInit);
                }
                catch (Exception e) {
                    VisualWebActivity.this.handler.sendEmptyMessage(13);
                }
            }
        }).start();
    }

    public void changeStatusBarColor(String color2) {
        if (Build.VERSION.SDK_INT >= 21) {
            try {
                this.getWindow().setStatusBarColor(Color.parseColor((String)color2));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void onPagedLoaded() {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                VisualWebActivity.this.isPageLoaded = true;
            }
        });
    }

    private void loadUrl(String path) {
        if (this.webview != null && !this.isLoading) {
            this.isPageLoaded = false;
            if (path == null) {
                path = "";
            }
            this.webUrl = this.prefManager.loadStringValue("TENQUBE_WEB_URL", "");
            if (TextUtils.isEmpty((CharSequence)this.webUrl)) {
                this.finish();
                return;
            }
            this.baseUrl = WebViewHelper.getBaseUrl(this.webUrl);
            Utils.LOGD("loadUrl", "\uc218\ud589\uc2dc\uac04: " + (System.currentTimeMillis() - this.startTime) / 1000L + "\ucd08, url:" + this.baseUrl);
            this.webview.loadUrl(this.baseUrl + path);
        }
    }

    private void loadProgressUrl(Constants.ProgressType progressType) {
        if (this.webview != null) {
            this.isPageLoaded = false;
            this.webUrl = this.prefManager.loadStringValue("TENQUBE_WEB_URL", "");
            if (TextUtils.isEmpty((CharSequence)this.webUrl)) {
                this.finish();
                return;
            }
            this.baseUrl = WebViewHelper.getProgressUrl(this.webUrl, progressType);
            this.webview.loadUrl(this.baseUrl);
        }
    }

    private void loadErrorUrl() {
        this.isPageLoaded = false;
        if (this.swipeRefreshLayout != null) {
            this.swipeRefreshLayout.setEnabled(false);
        }
        this.errorView.setVisibility(0);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 10) {
            boolean isEnabled = Utils.isNotiEnabled(this.getApplicationContext());
            JSONObject jsonObject = new JSONObject();
            try {
                jsonObject.put("isNotiEnabled", isEnabled);
                String json = jsonObject.toString();
                if (this.systemInterface != null) {
                    this.systemInterface.onNotiCallback(json);
                }
            }
            catch (JSONException jSONException) {}
        } else if (requestCode == 0) {
            if (this.shouldRequestOverlayPermission()) {
                this.finish();
            } else {
                this.startVisual();
            }
        }
    }

    public void onBackPressed() {
        try {
            if (this.isPageLoaded && this.uiInterface != null) {
                this.uiInterface.onFinish();
            } else {
                super.onBackPressed();
            }
        }
        catch (Exception e) {
            super.onBackPressed();
        }
    }

    public void onResume() {
        super.onResume();
        LocalBroadcastManager.getInstance((Context)this).registerReceiver(this.transactionReceiver, new IntentFilter(ACTION_BROADCAST_TRANSACTION));
        this.repository.setVisualActive(true);
        this.overridePendingTransition(0, 0);
    }

    public void onPause() {
        super.onPause();
        LocalBroadcastManager.getInstance((Context)this).unregisterReceiver(this.transactionReceiver);
        this.repository.setVisualActive(false);
        this.overridePendingTransition(0, 0);
    }

    @Override
    public void onCalendar(String date, String callback) {
        this.uiInterface.onCalendar(date, callback);
    }

    public void onScrollChanged(int pos) {
    }

    public void setRefreshEnabled(final boolean enabled) {
        this.swipeRefreshLayout.post(new Runnable(){

            @Override
            public void run() {
                VisualWebActivity.this.swipeRefreshLayout.setEnabled(enabled);
            }
        });
    }

    public void reload() {
        if (this.webview != null) {
            this.webview.post(new Runnable(){

                @Override
                public void run() {
                    VisualWebActivity.this.webview.reload();
                }
            });
        }
    }

    public void retry() {
        if (this.webview != null) {
            this.webview.post(new Runnable(){

                @Override
                public void run() {
                    VisualWebActivity.this.webview.loadUrl(VisualWebActivity.this.mFailingUrl);
                }
            });
        }
    }

    public void exportExcel(Completion<Boolean> completion) {
        this.completion = completion;
        this.exportExcel();
    }

    public void restore(Completion<Boolean> completion) {
        this.completion = completion;
        this.startBulkParsing(false);
    }

    @AfterPermissionGranted(value=1)
    public void exportExcel() {
        if (PermissionUtil.hasPermissions((Context)this, PERMISSIONS_STORAGE)) {
            ExcelManager.getInstance((Context)this).export(new ExcelManager.Callback(){

                @Override
                public void onCompleted(File file) {
                    boolean isSuccess;
                    boolean bl = isSuccess = file != null;
                    if (isSuccess) {
                        String authority = VisualWebActivity.this.repository.getAuthority();
                        try {
                            Intent intent = new Intent("android.intent.action.SEND");
                            intent.setType("application/octet-stream");
                            intent.putExtra("android.intent.extra.STREAM", (Parcelable)Utils.getUri(VisualWebActivity.this.getApplicationContext(), authority, file));
                            VisualWebActivity.this.startActivity(Intent.createChooser((Intent)intent, (CharSequence)"\uacf5\uc720"));
                            Toast.makeText((Context)VisualWebActivity.this.getApplicationContext(), (CharSequence)VisualWebActivity.this.getString(R.string.visual_export_excel_success_msg, new Object[]{file.getName()}), (int)0).show();
                        }
                        catch (Exception e) {
                            String log = "authority:" + authority + "\n FileProvider Error";
                            Toast.makeText((Context)VisualWebActivity.this.getApplicationContext(), (CharSequence)log, (int)0).show();
                            VisualWebActivity.this.completion.onDataLoaded(false);
                            return;
                        }
                    }
                    VisualWebActivity.this.completion.onDataLoaded(isSuccess);
                }
            });
        } else {
            PermissionUtil.requestPermissions((Activity)this, 1, PERMISSIONS_STORAGE);
        }
    }

    @Override
    public void onPermissionsGranted(int requestCode, List<String> list) {
        if (requestCode == 1) {
            this.exportExcel();
        }
    }

    @Override
    public void onPermissionsDenied(int requestCode, List<String> list) {
        Toast.makeText((Context)this.getApplicationContext(), (CharSequence)"\uc5d1\uc140 \ud30c\uc77c \ub0b4\ubcf4\ub0b4\uae30\ub97c \uc704\ud574 \uc678\ubd80 \uc800\uc7a5\uc18c\uc5d0 \ub300\ud55c \uad8c\ud55c\uc774 \ud544\uc694\ud569\ub2c8\ub2e4. \uad8c\ud55c\uc774 \uc5c6\ub294 \uacbd\uc6b0 \uc5d1\uc140 \ud30c\uc77c \ub0b4\ubcf4\ub0b4\uae30 \uc0ac\uc6a9\uc774 \ubd88\uac00\ud569\ub2c8\ub2e4.", (int)0).show();
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        PermissionUtil.onRequestPermissionsResult(requestCode, permissions, grantResults, this);
    }

    public static void startActivity(Activity activity, String path) throws AuthException {
        if (TextUtils.isEmpty((CharSequence)SecretKeyManager.getInstance((Context)activity).getKey("TENQUBE_ACCESS_TOKEN"))) {
            throw new AuthException("Need to sign up");
        }
        Intent intent = new Intent((Context)activity, VisualWebActivity.class);
        intent.putExtra(ARG_PATH, path);
        intent.addFlags(0x4020000);
        activity.startActivityForResult(intent, 512);
    }

    public static void startActivity(Context context, String path) throws AuthException {
        if (TextUtils.isEmpty((CharSequence)SecretKeyManager.getInstance(context).getKey("TENQUBE_ACCESS_TOKEN"))) {
            throw new AuthException("Need to sign up");
        }
        Intent intent = new Intent(context, VisualWebActivity.class);
        intent.putExtra(ARG_PATH, path);
        intent.addFlags(335675392);
        context.startActivity(intent);
    }

    public static void startActivity(@NonNull Context context, @NonNull PopupData popupData) throws AuthException, ParameterException {
        Validator.notNull(context);
        Validator.notNull(popupData);
        if (TextUtils.isEmpty((CharSequence)SecretKeyManager.getInstance(context).getKey("TENQUBE_ACCESS_TOKEN"))) {
            throw new AuthException("Need to sign up");
        }
        Intent intent = new Intent(context, VisualWebActivity.class);
        intent.putExtra(ARG_PATH, PathUtil.makePath(popupData));
        intent.addFlags(335675392);
        context.startActivity(intent);
    }

    public boolean shouldRequestOverlayPermission() {
        return PermissionUtil.shouldRequestOverlayPermission(this.getApplication().getApplicationContext()) && this.repository.isActiveTranPopup();
    }

    protected void onRestoreInstanceState(Bundle savedInstanceState) {
        super.onRestoreInstanceState(savedInstanceState);
        Utils.LOGD("onRestoreInstanceState", "");
        this.finish();
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        Utils.LOGD("onConfigurationChanged", "");
        this.finish();
    }
}

