package com.tenqube.visual_third.manager;

import android.content.Context;

import androidx.work.Data;
import androidx.work.ExistingWorkPolicy;
import androidx.work.OneTimeWorkRequest;
import androidx.work.WorkManager;

import com.tenqube.visual_third.entity.VisualNotification;
import com.tenqube.visual_third.repository.RepositoryHolder;
import com.tenqube.visual_third.repository.ResourceRepository;
import com.tenqube.visual_third.repository.VisualRepository;
import com.tenqube.visual_third.worker.ReportWorker;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;

public class VisualAlarmManager {

    public static final String TAG = VisualAlarmManager.class.getSimpleName();
    private static final int ALARM_SET = 0;
    private static final int ALARM_REPEAT = 1;

    private Context context;
    private static VisualAlarmManager mInstance = null;
    private VisualRepository repository;

    private ResourceRepository resourceRepository;

    public static VisualAlarmManager getInstance(Context ctx) {
        synchronized (VisualAlarmManager.class) {
            if (mInstance == null) {
                mInstance = new VisualAlarmManager(ctx.getApplicationContext());
            }
        }
        return mInstance;
    }

    private VisualAlarmManager(Context context) {
        this.context = context;
        repository = RepositoryHolder.getInstance(context).getVisualRepository();
        resourceRepository = RepositoryHolder.getInstance(context).getResourceRepository();
    }

    public void setReportTest(String type, int second) {

        boolean isAppNoti = repository.isAppNoti();

        ArrayList<VisualNotification> notifications = repository.loadNotifications();
        for(VisualNotification notification : notifications) {

            if(notification.getName().contains(type)) {

                if (notification.isEnable() && isAppNoti) {
                    notification.isTest = true;
                    startWorker(notification.getName(), notification.getId(), true, second * 1000);
                }
            }
        }
    }

    public VisualNotification getNotification(int id) {
        return repository.loadNotification(id);
    }

    public void syncNotification() {
        resourceRepository.syncNotification();
    }

    /**
     * 호출 시점
     * 1. 처음 진입시
     * 2. 설정 변경시
     */
    public void setAlarms() {

        try {
            boolean isAppNoti = repository.isAppNoti();

            int minute = getMinute();
            ArrayList<VisualNotification> notifications = repository.loadNotifications();

            for(VisualNotification notification : notifications) {
                if(notification.isEnable() && isAppNoti) {
                    long alarmTime = calculateAlarmTime(notification, minute);
                    startWorker(notification.getName(), notification.getId(), false, alarmTime);
                }
            }
        } catch (Exception e) {

        }
    }

    public void setAlarm(VisualNotification notification) {

        try {
            boolean isAppNoti = repository.isAppNoti();

            int minute = getMinute();

            if(notification.isEnable() && isAppNoti) {
                long alarmTime = calculateAlarmTime(notification, minute);
                startWorker(notification.getName(), notification.getId(), false, alarmTime);
            }

        } catch (Exception e) {

        }
    }

    private void startWorker(String reportName, int notiId, boolean isTest, long duration) {
        Data myData = new Data.Builder()
                // We need to pass three integers: X, Y, and Z
                .putString(ReportWorker.ARG_ACTION, ReportWorker.ACTION_TENQUBE_NOTIFICATION)
                .putInt(ReportWorker.ARG_NOTI_ID, notiId)
                .putBoolean(ReportWorker.ARG_NOTI_TEST, isTest)
                // ... and build the actual Data object:
                .build();

// ...then create and enqueue a OneTimeWorkRequest that uses those arguments
        OneTimeWorkRequest mathWork = new OneTimeWorkRequest.Builder(ReportWorker.class)
                .setInputData(myData)
                .addTag(reportName)
                .setInitialDelay(duration/ 1000, TimeUnit.SECONDS)
                .build();

        WorkManager.getInstance(context).enqueueUniqueWork(reportName, ExistingWorkPolicy.REPLACE, mathWork);
    }

    private long calculateAlarmTime(VisualNotification notification, int minute) {

        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));

        long currentTime = calendar.getTimeInMillis();
        int currentDay = calendar.get(Calendar.DATE);

        int currentHour = calendar.get(Calendar.HOUR_OF_DAY);

        calendar.set(Calendar.MINUTE, 0);
        calendar.set(Calendar.SECOND, 0);

        int day = notification.getDay();
        int dayOfWeek = notification.getDayOfWeek();
        int hour = notification.getHour();

        switch (notification.getName()) {
            case "monthly":
                if(day == currentDay) { // 1일로같음
                    if(currentHour >= hour) { // 알람설정 시간을 지나침
                        calendar.add(Calendar.MONTH, 1);
                    }
                } else {
                    calendar.add(Calendar.MONTH, 1);
                }

                calendar.set(Calendar.DATE, day);
                calendar.set(Calendar.HOUR_OF_DAY, hour);
                break;

            case "weekly_mon":
            case "weekly_fri":
                calendar.set(Calendar.HOUR_OF_DAY, hour);
                calendar.set(Calendar.DAY_OF_WEEK, dayOfWeek);

                if(currentTime >= calendar.getTimeInMillis()) {
                    calendar.add(Calendar.WEEK_OF_YEAR, 1);
                }
                break;

            case "daily":
                calendar.set(Calendar.HOUR_OF_DAY, hour);
//                calendar.set(Calendar.MINUTE, Calendar.getInstance().get(Calendar.MINUTE));
//                calendar.add(Calendar.MINUTE, 1);
                if(currentTime >= calendar.getTimeInMillis()) {
                    calendar.add(Calendar.DATE, 1);
                }
                break;
        }

        int beforeDay = calendar.get(Calendar.DATE);

        calendar.add(Calendar.MINUTE, minute);

        int afterDay = calendar.get(Calendar.DATE);

        if(beforeDay < afterDay) { // 하루가 지나가 버리면 다시 0으로 설정
            calendar.add(Calendar.MINUTE, -minute);
        }

        return calendar.getTimeInMillis() - currentTime;
    }

    /**
     * uid를 이용해 사용자 custId mod divider 를 통해 알람설정
     */
    private int getMinute() {

        int divider = repository.getDivider();
        String uid = repository.getUid();
        return Math.abs(uid.hashCode()) % divider;

    }

}
