package com.tenqube.visual_third.ui;

import android.app.Dialog;
import android.app.DialogFragment;
import android.app.TimePickerDialog;
import android.content.Context;
import android.os.Bundle;
import android.text.format.DateFormat;
import android.widget.TimePicker;

import com.tenqube.visual_third.R;
import com.tenqube.visual_third.model.js.TimeRequest;
import com.tenqube.visual_third.util.Utils;

import java.util.Calendar;

public class TimePickerFragment extends DialogFragment
        implements TimePickerDialog.OnTimeSetListener {

    private static final String ARG_CAL = "calendar";

    private TimePickerFragment.Callback mListener;
    private Calendar calendar = Calendar.getInstance();
    private TimeRequest timeRequest;

    public static TimePickerFragment newInstance(TimeRequest timeRequest) {
        TimePickerFragment fragment = new TimePickerFragment();
        Bundle args = new Bundle();
        args.putSerializable(ARG_CAL, timeRequest);
        fragment.setArguments(args);
        return fragment;
    }

    public TimePickerFragment() {
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (getArguments() != null) {
            timeRequest = (TimeRequest) getArguments().getSerializable(ARG_CAL);
            if(timeRequest != null)
                calendar = Utils.toCalendarHMS(timeRequest.getTime());
        }
    }


    @Override
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        // Use the current time as the default values for the picker
        int hour = calendar.get(Calendar.HOUR_OF_DAY);
        int minute = calendar.get(Calendar.MINUTE);

        // Create a new instance of TimePickerDialog and return it
        return new TimePickerDialog(getActivity(), R.style.PickerTheme, this, hour, minute,
                DateFormat.is24HourFormat(getActivity()));
    }

    public void onTimeSet(TimePicker view, int hourOfDay, int minute) {
        calendar.set(Calendar.HOUR_OF_DAY,hourOfDay);
        calendar.set(Calendar.MINUTE,minute);
        onTimeCalendar(Utils.getHMS(calendar), timeRequest.getCallbackJS());

    }

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);
        if (context instanceof Callback) {
            mListener = (Callback) context;
        } else {
            throw new RuntimeException(context.toString()
                    + " must implement OnFragmentInteractionListener");
        }
    }
    public void onTimeCalendar(String time, String callback) {
        if (mListener != null) {
            mListener.onCalendar(time, callback);
        }
    }
    @Override
    public void onDetach() {
        super.onDetach();
        mListener = null;
    }

    public interface Callback {
        void onCalendar(String time, String callback);
    }
}
