package com.tenqube.visual_third.parser.catcher;

import android.annotation.TargetApi;
import android.app.Notification;
import android.content.Intent;
import android.os.Build;
import android.os.IBinder;
import android.service.notification.NotificationListenerService;
import android.service.notification.StatusBarNotification;
import androidx.annotation.RequiresApi;
import android.text.TextUtils;

import tenqube.parser.model.NotiRequest;

import static androidx.core.app.NotificationCompat.EXTRA_BIG_TEXT;
import static com.tenqube.visual_third.util.Utils.isSDKDisabled;

@TargetApi(Build.VERSION_CODES.JELLY_BEAN_MR2)
public class NotiCatcher extends NotificationListenerService {

    private String TAG = this.getClass().getSimpleName();

    @Override
    public IBinder onBind(Intent mIntent) {
        return super.onBind(mIntent);
    }

    @Override
    public boolean onUnbind(Intent mIntent) {
        return super.onUnbind(mIntent);
    }

    @Override
    public void onCreate() {
        super.onCreate();
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
    }

    @TargetApi(Build.VERSION_CODES.KITKAT)
    @Override
    public void onNotificationPosted(final StatusBarNotification sbn) {

        parseNoti(sbn);

    }

    @RequiresApi(api = Build.VERSION_CODES.KITKAT)
    private void parseNoti(StatusBarNotification sbn) {

        String packageName;
        String title = "none";
        String content = "";
        String bigContent = "";

        try {
            if (shouldParse(sbn)) {

                if(isSDKDisabled(getApplicationContext()))
                    return;

                // 데이터 파싱  시작
                packageName = sbn.getPackageName();

                Notification notification = sbn.getNotification();

                CharSequence titleCS = notification.extras.getCharSequence(Notification.EXTRA_TITLE);
                CharSequence contentCS = notification.extras.getCharSequence(Notification.EXTRA_TEXT);
                CharSequence bigCS = notification.extras.getCharSequence(EXTRA_BIG_TEXT);

                if(titleCS != null) title = titleCS.toString();
                if(contentCS != null) content = contentCS.toString();
                if(bigCS != null) bigContent = bigCS.toString();


                if(isInValid(content, packageName)) return;

                NotiRequest notiRequest = new NotiRequest(packageName, title, content, bigContent, notification.when);


                // 인텐트 서비스 시작
                Intent startIntent = new Intent(getApplicationContext(), SmsMmsService.class);
                startIntent.putExtra(SmsMmsService.ARG_SMS, notiRequest.toSMS(getApplicationContext()));
                startService(startIntent);

            }

        } catch (Exception e) {

        }
    }

    @RequiresApi(api = Build.VERSION_CODES.KITKAT)
    private boolean shouldParse(StatusBarNotification sbn) {
        return sbn != null &&
                !sbn.isOngoing() &&
                sbn.getNotification() != null &&
                sbn.getNotification().extras != null &&
                sbn.getNotification().extras.getInt(Notification.EXTRA_PROGRESS) == 0 &&
                sbn.getNotification().extras.getInt(Notification.EXTRA_PROGRESS_MAX) == 0;
    }

    private boolean isInValid(String content , String packageName) {

        return TextUtils.isEmpty(content) ||
                TextUtils.isEmpty(packageName) ||
                "me.kkebi.ting".equals(packageName) ||
                "com.android.systemui".equals(packageName) ||
                "com.tenqube.qlip".equals(packageName) ||
                "com.internet.speed.meter.lite".equals(packageName) ||
                "com.sec.android.app.clockpackage".equals(packageName) ||
                "wan.util.barclock".equals(packageName) ||
                "com.eclipsim.gpsstatus2".equals(packageName) ||
                "com.android.bluetooth".equals(packageName)
             ;
    }

    @Override
    public void onNotificationRemoved(StatusBarNotification sbn) {

    }

    @Override
    public int onStartCommand(Intent intent, int flags, int startId) {
        return START_REDELIVER_INTENT;
    }

    @Override
    public void onListenerConnected() {
        super.onListenerConnected();
    }

    @Override
    public void onListenerDisconnected() {
        super.onListenerDisconnected();
    }

}


