/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.manager;

import android.content.Context;
import androidx.work.Data;
import androidx.work.ExistingWorkPolicy;
import androidx.work.OneTimeWorkRequest;
import androidx.work.WorkManager;
import com.tenqube.visual_third.entity.VisualNotification;
import com.tenqube.visual_third.repository.RepositoryHolder;
import com.tenqube.visual_third.repository.ResourceRepository;
import com.tenqube.visual_third.repository.VisualRepository;
import com.tenqube.visual_third.worker.ReportWorker;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;

public class VisualAlarmManager {
    public static final String TAG = VisualAlarmManager.class.getSimpleName();
    private static final int ALARM_SET = 0;
    private static final int ALARM_REPEAT = 1;
    private Context context;
    private static VisualAlarmManager mInstance = null;
    private VisualRepository repository;
    private ResourceRepository resourceRepository;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VisualAlarmManager getInstance(Context ctx) {
        Class<VisualAlarmManager> clazz = VisualAlarmManager.class;
        synchronized (VisualAlarmManager.class) {
            if (mInstance == null) {
                mInstance = new VisualAlarmManager(ctx.getApplicationContext());
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return mInstance;
        }
    }

    private VisualAlarmManager(Context context) {
        this.context = context;
        this.repository = RepositoryHolder.getInstance(context).getVisualRepository();
        this.resourceRepository = RepositoryHolder.getInstance(context).getResourceRepository();
    }

    public void setReportTest(String type, int second) {
        boolean isAppNoti = this.repository.isAppNoti();
        ArrayList<VisualNotification> notifications = this.repository.loadNotifications();
        for (VisualNotification notification : notifications) {
            if (!notification.getName().contains(type) || !notification.isEnable() || !isAppNoti) continue;
            notification.isTest = true;
            this.startWorker(notification.getName(), notification.getId(), true, second * 1000);
        }
    }

    public VisualNotification getNotification(int id2) {
        return this.repository.loadNotification(id2);
    }

    public void syncNotification() {
        this.resourceRepository.syncNotification();
    }

    public void setAlarms() {
        try {
            boolean isAppNoti = this.repository.isAppNoti();
            int minute = this.getMinute();
            ArrayList<VisualNotification> notifications = this.repository.loadNotifications();
            for (VisualNotification notification : notifications) {
                if (!notification.isEnable() || !isAppNoti) continue;
                long alarmTime = this.calculateAlarmTime(notification, minute);
                this.startWorker(notification.getName(), notification.getId(), false, alarmTime);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setAlarm(VisualNotification notification) {
        try {
            boolean isAppNoti = this.repository.isAppNoti();
            int minute = this.getMinute();
            if (notification.isEnable() && isAppNoti) {
                long alarmTime = this.calculateAlarmTime(notification, minute);
                this.startWorker(notification.getName(), notification.getId(), false, alarmTime);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void startWorker(String reportName, int notiId, boolean isTest, long duration) {
        Data myData = new Data.Builder().putString("ARG_ACTION", "ACTION_TENQUBE_NOTIFICATION_HANA").putInt("TENQUBE_ARG_NOTI_ID", notiId).putBoolean("TENQUBE_ARG_NOTI_TEST", isTest).build();
        OneTimeWorkRequest mathWork = (OneTimeWorkRequest)((OneTimeWorkRequest.Builder)((OneTimeWorkRequest.Builder)((OneTimeWorkRequest.Builder)new OneTimeWorkRequest.Builder(ReportWorker.class).setInputData(myData)).addTag(reportName)).setInitialDelay(duration / 1000L, TimeUnit.SECONDS)).build();
        WorkManager.getInstance((Context)this.context).enqueueUniqueWork(reportName, ExistingWorkPolicy.REPLACE, mathWork);
    }

    private long calculateAlarmTime(VisualNotification notification, int minute) {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        long currentTime = calendar.getTimeInMillis();
        int currentDay = calendar.get(5);
        int currentHour = calendar.get(11);
        calendar.set(12, 0);
        calendar.set(13, 0);
        int day = notification.getDay();
        int dayOfWeek = notification.getDayOfWeek();
        int hour = notification.getHour();
        switch (notification.getName()) {
            case "monthly": {
                if (day == currentDay) {
                    if (currentHour >= hour) {
                        calendar.add(2, 1);
                    }
                } else {
                    calendar.add(2, 1);
                }
                calendar.set(5, day);
                calendar.set(11, hour);
                break;
            }
            case "weekly_mon": 
            case "weekly_fri": {
                calendar.set(11, hour);
                calendar.set(7, dayOfWeek);
                if (currentTime < calendar.getTimeInMillis()) break;
                calendar.add(3, 1);
                break;
            }
            case "daily": {
                calendar.set(11, hour);
                if (currentTime < calendar.getTimeInMillis()) break;
                calendar.add(5, 1);
            }
        }
        int beforeDay = calendar.get(5);
        calendar.add(12, minute);
        int afterDay = calendar.get(5);
        if (beforeDay < afterDay) {
            calendar.add(12, -minute);
        }
        return calendar.getTimeInMillis() - currentTime;
    }

    private int getMinute() {
        int divider = this.repository.getDivider();
        String uid = this.repository.getUid();
        return Math.abs(uid.hashCode()) % divider;
    }
}

