package com.tenqube.visual_third.analysis;

import com.tenqube.visual_third.Constants;
import com.tenqube.visual_third.model.analysis.AggregationValue;
import com.tenqube.visual_third.model.analysis.Transaction;

import java.util.ArrayList;
import java.util.HashMap;

import static com.tenqube.visual_third.analysis.AnalysisHelper.aggregate;
import static com.tenqube.visual_third.analysis.AnalysisHelper.filterTransactionsDaily;
import static com.tenqube.visual_third.analysis.AnalysisHelper.filterTransactionsMcode;
import static com.tenqube.visual_third.analysis.AnalysisHelper.getMaxKeyword;

/**
 * Created by sagwangjin on 2018. 7. 22..
 */

public class DailyAnalysis implements Runnable {

    private final int before;
    private final ArrayList<Transaction> transactions;
    public Transaction maxTransaction;

    public HashMap<String, AggregationValue> alcohol;

    public HashMap<String, AggregationValue> yesterday;

    public DailyAnalysis(ArrayList<Transaction> transactions, int before) {
        this.transactions = transactions;
        this.before = before;
    }

    @Override
    public void run() {
        // 일간
        ArrayList<Transaction> filteredTransactions = filterTransactionsDaily(transactions, before); //이번달
        yesterday = aggregate(filteredTransactions, Constants.AggregateType.NONE);

        // 알콜합
        alcohol = aggregate(filterTransactionsMcode(filteredTransactions, Constants.MCODE.ALCOHOL), Constants.AggregateType.NONE);

        // 최대 지출
        maxTransaction = getMaxKeyword(filteredTransactions);

    }
}
