package com.tenqube.visual_third.ui;

import android.app.Dialog;
import android.app.DialogFragment;
import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.ContextThemeWrapper;
import android.view.View;
import android.view.Window;
import android.widget.ProgressBar;
import android.widget.TextView;

import com.tenqube.visual_third.R;

import static tenqube.parser.core.ParserService.mIsDebug;
import static tenqube.parser.util.LogUtil.LOGI;


public class VisualProgressDialogFragment extends DialogFragment {

    public static final String TAG = VisualProgressDialogFragment.class.getSimpleName();
    private Context context;

    private ProgressBar progressBar;
    private TextView percentTextView;
    private TextView titleTextView;

    public VisualProgressDialogFragment() {
        super();
    }

    public static VisualProgressDialogFragment newInstance() {
        return new VisualProgressDialogFragment();
    }

    public void setProgressValue(int progress, boolean isSync) {
        progressBar.setProgress(progress);
        if(progress == 100) {
            getDialog().setCancelable(true);
        }
        percentTextView.setText(progress + "%");

        if(isSync) {
            titleTextView.setText(getString(R.string.visual_restore_progress_description));
        } else {
            titleTextView.setText(getString(R.string.visual_progress_description));
        }
    }

    @Override
    public Dialog onCreateDialog(Bundle savedInstanceState) {

        try {
            LOGI("VisualFlow", "show bulk progress popup", mIsDebug);

            if (context == null)
                context = getActivity();

            android.app.AlertDialog.Builder builder = new android.app.AlertDialog.Builder(new ContextThemeWrapper(context, R.style.AlertDialogCustom));
            View view = getActivity().getLayoutInflater().inflate(R.layout.visual_dialog_progress,null);

            progressBar = view.findViewById(R.id.visual_progress);
            percentTextView = view.findViewById(R.id.visual_percent);
            titleTextView = view.findViewById(R.id.visual_title);
            builder.setView(view);
            Dialog dialog = builder.create();
            dialog.requestWindowFeature(Window.FEATURE_NO_TITLE);
//        dialog.getWindow().setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));
            dialog.setCanceledOnTouchOutside(true);
            if(dialog.getWindow() != null) dialog.getWindow().requestFeature(Window.FEATURE_NO_TITLE);
            return dialog;
        } catch (Exception e) {
            LOGI("VisualFlow", "show bulk progress popup", mIsDebug);

            e.printStackTrace();
            dismissAllowingStateLoss();
        }

        return null;

    }

    @Override
    public void onStart() {
        super.onStart();

    }

}
