package com.tenqube.visual_third.model.js;

import com.tenqube.visual_third.exception.ParameterException;
import com.tenqube.visual_third.util.Validator;

import java.io.Serializable;
import java.util.ArrayList;

import static com.tenqube.visual_third.util.Validator.notNull;

public class TransactionByIdsRequest extends Request implements Serializable {

    private ArrayList<Integer> tranIds;
    private String callbackJS;

    public TransactionByIdsRequest(ArrayList<Integer> tranIds, String callbackJS) {
        this.tranIds = tranIds;
        this.callbackJS = callbackJS;
    }

    @Override
    public void checkParams() throws ParameterException {
        notNull(tranIds);
        Validator.notNull(callbackJS);
    }

    public ArrayList<Integer> getTranIds() {
        return tranIds;
    }

    public String getCallbackJS() {
        return callbackJS;
    }
}
