/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.manager.downloader;

import android.content.Context;
import android.util.Log;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;

public class FileDownloader {
    private final Context context;
    private int BUFFER_SIZE = 4096;

    public FileDownloader(Context context) {
        this.context = context;
    }

    public File downloadFile(String fileURL) {
        File targetFile = null;
        URL url = null;
        try {
            url = new URL(fileURL);
            Log.i((String)"VisualFlow", (String)("downloadFile fileURL " + fileURL));
            HttpURLConnection httpConn = (HttpURLConnection)url.openConnection();
            int responseCode = httpConn.getResponseCode();
            if (responseCode == 200) {
                int bytesRead;
                String fileName = "";
                String disposition = httpConn.getHeaderField("Content-Disposition");
                if (disposition != null) {
                    int index = disposition.indexOf("filename=");
                    if (index > 0) {
                        fileName = disposition.substring(index + 10, disposition.length() - 1);
                    }
                } else {
                    fileName = fileURL.substring(fileURL.lastIndexOf("/") + 1, fileURL.length());
                }
                fileName = fileName.replace("2", "");
                Log.i((String)"VisualFlow", (String)("downloadFile fileName " + fileName));
                InputStream inputStream = httpConn.getInputStream();
                targetFile = new File(this.context.getFilesDir(), fileName);
                FileOutputStream outputStream = new FileOutputStream(targetFile, false);
                byte[] buffer = new byte[this.BUFFER_SIZE];
                while ((bytesRead = inputStream.read(buffer)) != -1) {
                    outputStream.write(buffer, 0, bytesRead);
                }
                outputStream.close();
                inputStream.close();
            }
            httpConn.disconnect();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Log.i((String)"VisualFlow", (String)("downloadFile targetFile" + targetFile));
        return targetFile;
    }
}

