package com.tenqube.visual_third;

import android.app.Activity;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.tenqube.visual_third.exception.ParameterException;
import com.tenqube.visual_third.ui.OnResultListener;

public interface VisualService {

    /**
     *
     * @param activity Activity activity.startActivityForResult(intent, VISUAL_REQUEST_CODE);
     *                앱 finish 전달해줌 / acitivity 가 null 인경우 startActivity
     *
     * @param serviceId 사용자 아이디
     * @param userInfo  성별과 태어낸 해를 받아옵니다.
     * @param syncService  동기화에 필요한 서비스를 주입합니다.
     * @param onResultListener 사용자 등록시 전달받을 콜백 값
     * @throws ParameterException 파라미터가 올바르지 않은경우 예외 발생
     */
    void startVisual(@NonNull Activity activity,
                     @NonNull String serviceId,
                     @NonNull VisualUserInfo userInfo,
                     @Nullable SyncService syncService,
                     @NonNull OnResultListener onResultListener) throws ParameterException;


    String getNotificationServiceName();

    /**
     * 월별 합, 설명 조회 인터페이스
     * @param callback 요약 정보 응답
     */
    void getVisualSummary(Callback<VisualSummary> callback);


    /**
     * @param from 이상
     * @param to 미만
     * @param callback
     */
    void getSum(long from, long to, Callback<Double> callback);

    /**
     * 사용자 초기화 함수
     * @param callback
     */
    void signOut(Callback<Boolean> callback);

    /**
     * 팝업 보여질지 여부를 확인 합니다.
     * @return 팝업 보여질 여부 (true : 보여짐 , false : 안보여짐)
     */
    boolean isActiveTranPopup();

    /**
     * 팝업 호출 여부
     * @param isActive 팝업 보여질 여부 (true : 보여짐 , false : 안보여짐)
     */
    void setTranPopup(boolean isActive);


    /**
     * 알람 설정
     * @param type  ReportAlarmType.Daily, ReportAlarmType.Weekly, ReportAlarmType.Monthly 설정하고자 하는 타입
     * @param isActive 활성화 여부
     */
    void setReportAlarm(Constants.ReportAlarmType type, boolean isActive);

    /**
     *
     * @param type ReportAlarmType.Daily, ReportAlarmType.Weekly, ReportAlarmType.Monthly 설정하고자 하는 타입
     * @return 리포트 알람 활성화 여부
     */
    boolean isActiveReportAlarm(Constants.ReportAlarmType type);

    /**
     * 알림 테스트
     * @param type 리포트 타입
     * @param second 몇초후 알림 발생할지
     */
    void setReportTest(Constants.ReportAlarmType type, int second);

    /**
     * 앱 알림 설정 여부 저장
     * @param isActive 활성화 여부
     */
    void setAppNoti(boolean isActive);

    /**
     * @return 앱알림 활성화 여부
     */
    boolean isActiveAppNoti();


    /**
     * SDK 사용 여부 판단 플레그
     * @param enabled true : 동작 / false : 동작 안함.
     */
    void setEnabled(boolean enabled);

    /**
     * 가입 여부
     * @return 가입여부 결과 리턴
     */
    boolean isJoined();


}
