package com.tenqube.visual_third.api.auth;

import android.content.Context;

import com.tenqube.visual_third.Constants;
import com.tenqube.visual_third.api.data.ResultBody;
import com.tenqube.visual_third.api.data.Token;
import com.tenqube.visual_third.manager.PrefManager;
import com.tenqube.visual_third.manager.SecretKeyManager;
import com.tenqube.visual_third.model.api.UserRequest;
import com.tenqube.visual_third.model.api.UserResult;
import com.tenqube.visual_third.util.Validator;

import java.io.IOException;
import java.util.Calendar;

public class AuthServiceImpl implements AuthService {

    private static final String TAG = AuthServiceImpl.class.getSimpleName();

    private final AuthApi authApi;
    private final PrefManager prefManager;
    private final SecretKeyManager secretKeyManager;
    private final Context context;

    private AuthServiceImpl(Context context, AuthApi authApi, PrefManager prefManager, SecretKeyManager secretKeyManager) {
        this.context = context;
        this.authApi = authApi;
        this.prefManager = prefManager;
        this.secretKeyManager = secretKeyManager;
    }

    private static AuthService mInstance;

    public static AuthService getInstance(Context context, AuthApi authApi, PrefManager prefManager, SecretKeyManager secretKeyManager) {
        synchronized (AuthService.class) {
            if (mInstance == null) {
                mInstance = new AuthServiceImpl(context, authApi, prefManager, secretKeyManager);
            }
        }
        return mInstance;
    }

    @Override
    public boolean signUp(UserRequest request) throws IOException {

        UserResult result;
        if(Constants.PROD.equals(prefManager.loadStringValue(PrefManager.QUALIFIER, Constants.PROD))) {
            result = makeProdUserResult(request.getUid());
        } else {
            result = makeDevUserResult(request.getUid());
        }
        saveUserInfo(request, result);
        return true;


    }

    private UserResult makeProdUserResult(String uId) {



        com.tenqube.visual_third.model.api.UserResult.ExternalApi search = new UserResult.ExternalApi("https://3gcjeeijjd.execute-api.ap-northeast-2.amazonaws.com/prod/search/company/hana1QPay", "AWqYLDaHxB9FpncQG5Xaptyrou52pkD3FpguxvW3");
        UserResult.ExternalApi resource = new UserResult.ExternalApi("https://73978j1585.execute-api.ap-northeast-2.amazonaws.com/prod", "azxTVLJ6J56pgrVZM3Oq5YMBXc8eLS6d934OIrb0");

        UserResult.Web web = new UserResult.Web( "https://1qpay-view.tenqube.kr");
        UserResult.Authorization authorization = new UserResult.Authorization(new Token(uId,
                uId));


        UserResult result = new UserResult( "TENQUBE&SKPSQS!@",
                search,
                resource,
                web,
                authorization

        );

        return result;
    }

    private UserResult makeDevUserResult(String uId) {

        com.tenqube.visual_third.model.api.UserResult.ExternalApi search = new UserResult.ExternalApi("https://3gcjeeijjd.execute-api.ap-northeast-2.amazonaws.com/dev/search/company/hana1QPay", "xzJm4PSIPz3GK5G4M78nhabMHxsxTWke5Vxf7rXU");
        UserResult.ExternalApi resource = new UserResult.ExternalApi("https://73978j1585.execute-api.ap-northeast-2.amazonaws.com/dev", "4wjjC9TxHg3KaUEWqXl3f7uCIzmEsbgj5UBGg6eO");

        UserResult.Web web = new UserResult.Web("https://dev-1qpay-view.tenqube.kr");
        UserResult.Authorization authorization = new UserResult.Authorization(new Token(uId,
                uId));

        UserResult result = new UserResult("TENQUBE&SKPSQS!@",
                search,
                resource,
                web,
                authorization

        );

        return result;
    }

    @Override
    public boolean reissueToken() throws Exception {

        String refreshToken = secretKeyManager.getKey(PrefManager.REFRESH_TOKEN);

        Validator.isNotEmpty(refreshToken);

        retrofit2.Response<ResultBody<Token>> result = authApi.reissueToken(refreshToken).execute();
        if (result.isSuccessful()) {
            ResultBody<Token> results = result.body();
            if(results != null && results.results != null) {
                saveToken(results.results);
                return true;
            }
        } else {
            int statusCode = result.code();
            if(statusCode == 403) {
                signOut();
            } else if(statusCode == 401) {
                UserRequest userRequest = new UserRequest(prefManager.loadStringValue(PrefManager.USER_ID, ""),
                        prefManager.loadStringValue(PrefManager.USER_AD_ID, ""));
                boolean success = signUp(userRequest);
                if(success) {
                    return true;
                }
            }
        }

        return false;
    }

    @Override
    public String getAccessToken() {
        // 401 test token
      return secretKeyManager.getKey(PrefManager.ACCESS_TOKEN);
    }

    private void saveUserInfo(UserRequest user, UserResult response) {

        if(user != null) {
            prefManager.saveStringValue(PrefManager.USER_ID, user.getUid());
            prefManager.saveStringValue(PrefManager.USER_AD_ID, user.getAdId());
        }

        tenqube.parser.core.SecretKeyManager.getInstance(context).saveKey(response.getSecretKey());

        saveToken(response.getAuthorization().getSdk());

        prefManager.saveStringValue(PrefManager.RESOURCE_URL, response.getResource().getUrl());
        prefManager.saveStringValue(PrefManager.RESOURCE_API_KEY, response.getResource().getApiKey());

        prefManager.saveStringValue(PrefManager.SEARCH_URL, response.getSearch().getUrl());
        prefManager.saveStringValue(PrefManager.SEARCH_API_KEY, response.getSearch().getApiKey());

        prefManager.saveLongValue(PrefManager.SIGN_UP_TIME, Calendar.getInstance().getTimeInMillis());
        if (response.getWeb() != null)
            prefManager.saveStringValue(PrefManager.WEB_URL, response.getWeb().getUrl());

    }

    private void saveToken(Token token) {
        if(token == null) return;
        secretKeyManager.save(PrefManager.REFRESH_TOKEN, token.getAccess());
        secretKeyManager.save(PrefManager.ACCESS_TOKEN, token.getRefresh());
    }

    @Override
    public void signOut() {
        prefManager.saveStringValue(PrefManager.REFRESH_TOKEN, "");
        prefManager.saveStringValue(PrefManager.ACCESS_TOKEN, "");

    }
}
