package com.tenqube.visual_third.model.service;


import androidx.annotation.Nullable;

import com.tenqube.visual_third.util.Utils;

import java.util.HashMap;
import java.util.Map;

public class ApiInfo {

    private final String smsUrl;

    @Nullable
    private final Map<String, String> smsHeader;

    private final String versionUrl;

    @Nullable
    private final Map<String, String> versionHeader;


    private final String transactionUrl;

    @Nullable
    private final Map<String, String> tranHeader;


    public ApiInfo(String smsUrl, @Nullable Map<String, String> smsHeader,
                   String versionUrl, @Nullable Map<String, String> versionHeader,

                   String transactionUrl, @Nullable Map<String, String> tranHeader) {


        this.smsUrl = smsUrl;
        this.smsHeader = smsHeader;
        this.versionUrl = versionUrl;
        this.versionHeader = versionHeader;
        this.transactionUrl = transactionUrl;
        this.tranHeader = tranHeader;
    }

    public String toJson() {
        return Utils.toJson(this);
    }


    public String getSmsUrl() {
        return smsUrl;
    }

    public String getVersionUrl() {
        return versionUrl;
    }

    @Nullable
    public Map<String, String> getSmsHeader() {

        if(smsHeader == null) {
            return new HashMap<>();
        }
        return smsHeader;
    }

    @Nullable
    public Map<String, String> getVersionHeader() {

        if(versionHeader == null) {
            return new HashMap<>();
        }
        return versionHeader;
    }

    public String getTransactionUrl() {
        return transactionUrl;
    }

    @Nullable
    public Map<String, String> getTranHeader() {
        if(tranHeader == null) {
            return new HashMap<>();
        }
        return tranHeader;
    }
}
