package com.tenqube.visual_third.model.api;

import com.tenqube.visual_third.api.data.Token;

import java.io.Serializable;

public class UserResult implements Serializable {

    private String secretKey;

    private ExternalApi search;
    private ExternalApi resource;

    private Web web;
    private Authorization authorization;

    public String getSecretKey() {
        return secretKey;
    }

    public Web getWeb() {
        return web;
    }

    public ExternalApi getResource() {
        return resource;
    }

    public ExternalApi getSearch() {
        return search;
    }

    public Authorization getAuthorization() {
        return authorization;
    }

    public UserResult(String secretKey, ExternalApi search, ExternalApi resource, Web web, Authorization authorization) {
        this.secretKey = secretKey;
        this.search = search;
        this.resource = resource;
        this.web = web;
        this.authorization = authorization;
    }

    public static class ExternalApi implements Serializable {
        private String url;
        private String apiKey;

        public String getUrl() {
            return url;
        }

        public String getApiKey() {
            return apiKey;
        }

        public ExternalApi(String url, String apiKey) {
            this.url = url;
            this.apiKey = apiKey;
        }

        @Override
        public String toString() {
            return "Search{" +
                    "url='" + url + '\'' +
                    ", apiKey='" + apiKey + '\'' +
                    '}';
        }
    }

    public static class Web implements Serializable {
        private String url;

        public Web(String url) {
            this.url = url;
        }

        public String getUrl() {
            return url;
        }
    }

    public static class Authorization implements Serializable {

        private Token sdk;

        public Authorization(Token sdk) {
            this.sdk = sdk;
        }

        public Token getSdk() {
            return sdk;
        }

        @Override
        public String toString() {
            return "Authorization{" +
                    "sdk='" + sdk + '\'' +
                    '}';
        }
    }


}
