/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.api.visual;

import android.content.Context;
import android.text.TextUtils;
import com.tenqube.visual_third.api.resource.ResourceServiceImpl;
import com.tenqube.visual_third.api.visual.VisualApi;
import com.tenqube.visual_third.api.visual.VisualApiService;
import com.tenqube.visual_third.manager.PrefManager;
import com.tenqube.visual_third.model.api.AdInfoResponse;
import com.tenqube.visual_third.model.api.AdResponse;
import com.tenqube.visual_third.model.api.CurrencyResponse;
import com.tenqube.visual_third.model.api.TransactionRequest;
import com.tenqube.visual_third.model.api.UserInfoRequest;
import com.tenqube.visual_third.model.service.ApiInfo;
import com.tenqube.visual_third.util.Utils;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class VisualApiServiceImpl
implements VisualApiService {
    private static final String TAG = ResourceServiceImpl.class.getSimpleName();
    private final VisualApi visualApi;
    private final PrefManager prefManager;
    private final Context context;
    private static VisualApiService mInstance;

    private VisualApiServiceImpl(Context context, VisualApi visualApi, PrefManager prefManager) {
        this.context = context;
        this.visualApi = visualApi;
        this.prefManager = prefManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VisualApiService getInstance(Context context, VisualApi visualApi, PrefManager prefManager) {
        Class<VisualApiServiceImpl> clazz = VisualApiServiceImpl.class;
        synchronized (VisualApiServiceImpl.class) {
            if (mInstance == null) {
                mInstance = new VisualApiServiceImpl(context, visualApi, prefManager);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return mInstance;
        }
    }

    @Override
    public boolean saveUserInfo(UserInfoRequest userInfoRequest) {
        try {
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public CurrencyResponse getCurrencyRate(String from, String to) {
        try {
            Response response = this.visualApi.callCurrencyRate(from.toLowerCase(), to.toLowerCase()).execute();
            if (response.isSuccessful()) {
                return (CurrencyResponse)response.body();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Override
    public void saveTransactions(TransactionRequest transactionRequest, Callback<Void> callback) {
        String apiInfoJson = this.prefManager.loadStringValue("TENQUBE_API_INFO", "");
        if (TextUtils.isEmpty((CharSequence)apiInfoJson)) {
            callback.onResponse(null, null);
        } else {
            ApiInfo apiInfo = Utils.fromJson(apiInfoJson, ApiInfo.class);
            if (apiInfo != null) {
                Call<Void> call = this.visualApi.saveTransactions(apiInfo.getTransactionUrl(), apiInfo.getTranHeader(), transactionRequest);
                call.enqueue(callback);
            } else {
                callback.onResponse(null, null);
            }
        }
    }

    @Override
    public AdInfoResponse getAdInfo() {
        try {
            AdInfoResponse response;
            Response res = this.visualApi.getAdInfo().execute();
            if (res.isSuccessful() && (response = (AdInfoResponse)res.body()) != null) {
                return response;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Override
    public AdResponse getAds(int version) {
        try {
            AdResponse response;
            Response res = this.visualApi.getAds(version).execute();
            if (res.isSuccessful() && (response = (AdResponse)res.body()) != null) {
                return response;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

