/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.api.resource;

import android.text.TextUtils;
import com.tenqube.visual_third.api.resource.ResourceApi;
import com.tenqube.visual_third.api.resource.ResourceService;
import com.tenqube.visual_third.manager.PrefManager;
import com.tenqube.visual_third.manager.SignatureManager;
import com.tenqube.visual_third.model.api.AnalysisResponse;
import com.tenqube.visual_third.model.api.NotificationPkgResponse;
import com.tenqube.visual_third.model.api.NotificationResponse;
import com.tenqube.visual_third.model.api.ParsingRuleKey;
import com.tenqube.visual_third.model.api.ParsingRuleResponse;
import com.tenqube.visual_third.model.api.SyncCategoryResponse;
import com.tenqube.visual_third.model.api.VersionResponse;
import com.tenqube.visual_third.model.service.ApiInfo;
import com.tenqube.visual_third.util.Utils;
import java.io.IOException;
import java.util.HashMap;
import okhttp3.ResponseBody;
import org.json.JSONException;
import org.json.JSONObject;
import retrofit2.Response;
import tenqube.parser.core.ParserService;
import tenqube.parser.model.ParsingRule;
import tenqube.parser.util.LogUtil;

public class ResourceServiceImpl
implements ResourceService {
    private static final String TAG = ResourceServiceImpl.class.getSimpleName();
    private final ResourceApi resourceApi;
    private final SignatureManager signatureManager;
    private final PrefManager prefManager;
    private static ResourceService mInstance;

    private ResourceServiceImpl(ResourceApi resourceApi, SignatureManager signatureManager, PrefManager prefManager) {
        this.resourceApi = resourceApi;
        this.signatureManager = signatureManager;
        this.prefManager = prefManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResourceService getInstance(ResourceApi resourceApi, SignatureManager signatureManager, PrefManager prefManager) {
        Class<ResourceServiceImpl> clazz = ResourceServiceImpl.class;
        synchronized (ResourceServiceImpl.class) {
            if (mInstance == null) {
                mInstance = new ResourceServiceImpl(resourceApi, signatureManager, prefManager);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return mInstance;
        }
    }

    private ApiInfo getApiInfo() {
        try {
            String apiInfoJson = this.prefManager.loadStringValue("TENQUBE_API_INFO", "");
            if (TextUtils.isEmpty((CharSequence)apiInfoJson)) {
                HashMap<String, String> headers = new HashMap<String, String>();
                headers.put("x-api-key", this.prefManager.loadStringValue("TENQUBE_RESOURCE_API_KEY", ""));
                return new ApiInfo(this.prefManager.loadStringValue("TENQUBE_RESOURCE_URL", ""), headers, this.prefManager.loadStringValue("TENQUBE_RESOURCE_URL", ""), headers);
            }
            return Utils.fromJson(apiInfoJson, ApiInfo.class);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public VersionResponse syncVersion() {
        try {
            ApiInfo apiInfo = this.getApiInfo();
            Response response = this.resourceApi.syncVersion(apiInfo.getSmsUrl(), apiInfo.getSmsHeader()).execute();
            if (response != null && response.isSuccessful()) {
                return (VersionResponse)response.body();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Override
    public SyncCategoryResponse syncCategory(int clientVersion, int serverVersion) {
        if (serverVersion > clientVersion) {
            try {
                Response response = this.resourceApi.syncCategory("category", clientVersion, serverVersion).execute();
                if (response.isSuccessful()) {
                    return (SyncCategoryResponse)response.body();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public NotificationPkgResponse syncNotificationApps() {
        try {
            Response response = this.resourceApi.syncNotificationApps().execute();
            if (response.isSuccessful()) {
                return (NotificationPkgResponse)response.body();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public AnalysisResponse syncAnalysis(int clientVersion, int serverVersion) {
        if (serverVersion > clientVersion) {
            try {
                Response response = this.resourceApi.syncAnalysis("analysis", clientVersion, serverVersion).execute();
                if (response.isSuccessful()) {
                    return (AnalysisResponse)response.body();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public NotificationResponse syncNotification() {
        try {
            Response response = this.resourceApi.syncNotification().execute();
            if (response.isSuccessful()) {
                return (NotificationResponse)response.body();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Override
    public ParsingRule syncParsingRule(int clientVersion, int serverVersion) {
        block5: {
            try {
                ResponseBody response;
                LogUtil.LOGI((String)"ResourceService", (String)("syncParsingRule" + clientVersion + "server" + serverVersion), (boolean)ParserService.mIsDebug);
                if (serverVersion <= clientVersion) break block5;
                ApiInfo apiInfo = this.getApiInfo();
                Response ruleResponse = this.resourceApi.syncParsingRule(apiInfo.getSmsUrl(), apiInfo.getSmsHeader(), "parsingRule", clientVersion, serverVersion).execute();
                LogUtil.LOGI((String)"ResourceService", (String)("ruleResponse.isSuccessful()" + ruleResponse.isSuccessful()), (boolean)ParserService.mIsDebug);
                if (!ruleResponse.isSuccessful() || (response = (ResponseBody)ruleResponse.body()) == null) break block5;
                try {
                    JSONObject jsonObject = new JSONObject(response.string());
                    String signature = jsonObject.getString("signature");
                    String resource = jsonObject.getString("resource");
                    ParsingRuleResponse parsingRuleResponse = Utils.fromJson(resource, ParsingRuleResponse.class);
                    boolean isValid = this.signatureManager.isValid(clientVersion, parsingRuleResponse.securityKey, serverVersion, resource, signature);
                    LogUtil.LOGI((String)"ResourceService", (String)("isValid" + isValid), (boolean)ParserService.mIsDebug);
                    if (isValid) {
                        ParsingRule parsingRule = new ParsingRule(parsingRuleResponse.securityKey, parsingRuleResponse.tranCount, parsingRuleResponse.ruleVersion, parsingRuleResponse.regDatas, parsingRuleResponse.senders, parsingRuleResponse.banks);
                        LogUtil.LOGI((String)"ResourceService", (String)("parsingRule" + parsingRule.toString()), (boolean)ParserService.mIsDebug);
                        return parsingRule;
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public ParsingRuleKey syncParsingRuleKey() {
        try {
            Response response = this.resourceApi.syncParsingRuleKey().execute();
            if (response != null && response.isSuccessful()) {
                return (ParsingRuleKey)response.body();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }
}

