/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.NonNull;
import com.tenqube.visual_third.Callback;
import com.tenqube.visual_third.Constants;
import com.tenqube.visual_third.VisualCallback;
import com.tenqube.visual_third.VisualService;
import com.tenqube.visual_third.VisualSummary;
import com.tenqube.visual_third.VisualUserInfo;
import com.tenqube.visual_third.analysis.AnalysisHelper;
import com.tenqube.visual_third.analysis.AnalysisService;
import com.tenqube.visual_third.analysis.AnalysisServiceImpl;
import com.tenqube.visual_third.exception.AuthException;
import com.tenqube.visual_third.exception.ParameterException;
import com.tenqube.visual_third.manager.AnswerManager;
import com.tenqube.visual_third.manager.VisualAlarmManager;
import com.tenqube.visual_third.model.analysis.Analysis;
import com.tenqube.visual_third.model.analysis.Transaction;
import com.tenqube.visual_third.model.js.LogRequest;
import com.tenqube.visual_third.model.js.TransactionRequest;
import com.tenqube.visual_third.model.service.ApiInfo;
import com.tenqube.visual_third.repository.RepositoryHolder;
import com.tenqube.visual_third.repository.VisualRepository;
import com.tenqube.visual_third.ui.OnResultListener;
import com.tenqube.visual_third.ui.VisualWebActivity;
import com.tenqube.visual_third.util.AppExecutors;
import com.tenqube.visual_third.util.Utils;
import com.tenqube.visual_third.util.Validator;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import tenqube.parser.constants.Constants;

public class VisualServiceImpl
implements VisualService {
    public static final String TAG = VisualServiceImpl.class.getSimpleName();
    private Context context;
    private AnalysisService service;
    private VisualRepository repository;
    private VisualAlarmManager alarmManager;
    private AppExecutors appExecutors = new AppExecutors();
    public static boolean logger = false;

    private VisualServiceImpl(Builder builder) throws ParameterException {
        Validator.notNull(builder.context);
        Validator.isNotEmpty(builder.apiKey);
        Validator.isNotEmpty(builder.authority);
        Validator.notZero(builder.smallIcon);
        Validator.notNull(builder.channel);
        Validator.in(builder.qualifier, "dev", "prod");
        this.context = builder.context;
        logger = builder.logger;
        this.repository = RepositoryHolder.getInstance(this.context).getVisualRepository();
        this.repository.saveSDKInfo(builder.apiKey, builder.qualifier, builder.authority, builder.apiInfo);
        this.repository.settingNotification(builder.smallIcon, builder.channel, builder.color);
        this.alarmManager = VisualAlarmManager.getInstance(this.context);
        this.service = new AnalysisServiceImpl(this.context, builder.qualifier);
    }

    @Override
    public void initialize(@NonNull String serviceId, @NonNull VisualUserInfo userInfo, final @NonNull OnResultListener resultListener) throws ParameterException {
        Validator.isNotEmpty(serviceId);
        Validator.notNull(userInfo);
        this.repository.signUp(serviceId, userInfo, new OnResultListener(){

            @Override
            public void onResult(int signUpResult, String msg) {
                resultListener.onResult(signUpResult, msg);
            }
        });
    }

    @Override
    public void startVisual(final @NonNull Activity activity, @NonNull String serviceId, @NonNull VisualUserInfo visualUserInfo, @NonNull VisualCallback visualCallback, final @NonNull OnResultListener resultListener) throws ParameterException {
        Validator.notNull(activity);
        Validator.isNotEmpty(serviceId);
        Validator.notNull(resultListener);
        Validator.notNull(visualUserInfo);
        Validator.notNull(visualCallback);
        this.repository.setVisualCallback(visualCallback);
        this.repository.signUp(serviceId, visualUserInfo, new OnResultListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void onResult(int signUpResult, String msg) {
                try {
                    switch (signUpResult) {
                        case 0: 
                        case 3: {
                            VisualWebActivity.startActivity(activity, "");
                            return;
                        }
                    }
                    return;
                }
                catch (AuthException e) {
                    signUpResult = 1;
                    msg = e.toString();
                    return;
                }
                finally {
                    resultListener.onResult(signUpResult, msg);
                }
            }
        });
    }

    @Override
    public String getNotificationServiceName() {
        return "com.tenqube.visual_third.parser.catcher.NotiCatcher";
    }

    @Override
    public void signOut(Callback<Boolean> callback) {
        this.repository.signOut(new Callback<Boolean>(){

            @Override
            public void onDataLoaded(Boolean value) {
                VisualServiceImpl.this.alarmManager.setAlarms();
            }
        });
    }

    @Override
    public boolean isActiveTranPopup() {
        AnswerManager.onKeyMetric(new LogRequest("isActiveTranPopup"));
        return this.repository.isActiveTranPopup();
    }

    @Override
    public void setTranPopup(boolean isActive) {
        AnswerManager.onKeyMetric(new LogRequest("setTranPopup"));
        this.repository.setTranPopup(isActive);
    }

    @Override
    public void setReportAlarm(Constants.ReportAlarmType type, boolean isActive) {
        this.repository.setActiveNoti(type.name().toLowerCase(), isActive);
        this.alarmManager.setAlarms();
    }

    @Override
    public boolean isActiveReportAlarm(Constants.ReportAlarmType type) {
        return this.repository.isActiveNoti(type.name().toLowerCase());
    }

    @Override
    public void setReportTest(Constants.ReportAlarmType type, int second) {
        this.alarmManager.setReportTest(type.name().toLowerCase(), second);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.repository.setEnabled(enabled);
        if (!enabled) {
            this.repository.setNotiAll(false);
            this.alarmManager.setAlarms();
        }
    }

    @Override
    public boolean isJoined() {
        return this.repository.isJoined();
    }

    @Override
    public void getVisualSummary(final Callback<VisualSummary> callback) {
        this.appExecutors.diskIO().execute(new Runnable(){

            @Override
            public void run() {
                if (!VisualServiceImpl.this.repository.isJoined()) {
                    VisualServiceImpl.this.appExecutors.mainThread().execute(new Runnable(){

                        @Override
                        public void run() {
                            callback.onDataLoaded(null);
                        }
                    });
                } else {
                    VisualSummary visualSummary;
                    Calendar calendar = Calendar.getInstance();
                    int year = calendar.get(1);
                    int month = calendar.get(2) + 1;
                    TransactionRequest request = new TransactionRequest(year, month, 3, true, "");
                    request.setDwType(Constants.DWType.WITHDRAW.ordinal());
                    request.setExceptType(0);
                    ArrayList<Transaction> transactions = VisualServiceImpl.this.repository.loadAnalysisTransactions(request);
                    ArrayList<Analysis> monthly = VisualServiceImpl.this.service.loadAnalysisList(transactions, VisualServiceImpl.this.repository.getStartDay(), true);
                    double sum = VisualServiceImpl.this.getCurrentMonthSum(year, month);
                    if (monthly.isEmpty()) {
                        visualSummary = new VisualSummary(sum, String.format("\uc774\ubc88 \ub2ec \uc9c0\ucd9c\uc740 %1$s \uc785\ub2c8\ub2e4.", AnalysisHelper.getLv0Currency(sum)));
                    } else {
                        Collections.shuffle(monthly);
                        Analysis analysis = monthly.get(0);
                        visualSummary = new VisualSummary(sum, analysis.getlContent());
                    }
                    VisualServiceImpl.this.appExecutors.mainThread().execute(new Runnable(){

                        @Override
                        public void run() {
                            callback.onDataLoaded(visualSummary);
                        }
                    });
                }
            }
        });
    }

    private double getCurrentMonthSum(int year, int month) {
        TransactionRequest currentRequest = new TransactionRequest(year, month, 0, true, "");
        currentRequest.setDwType(Constants.DWType.WITHDRAW.ordinal());
        currentRequest.setExceptType(0);
        ArrayList<Transaction> currentMonthTransactions = this.repository.loadAnalysisTransactions(currentRequest);
        return Utils.sumBy(currentMonthTransactions);
    }

    @Override
    public void setAppNoti(boolean isActive) {
        this.repository.setAppNoti(isActive);
        this.alarmManager.setAlarms();
    }

    @Override
    public boolean isActiveAppNoti() {
        return this.repository.isAppNoti();
    }

    private boolean isActive() {
        return this.context != null;
    }

    public static class Builder {
        Context context;
        String apiKey;
        ApiInfo apiInfo;
        String qualifier;
        String authority;
        int smallIcon;
        String channel;
        int color;
        boolean logger;

        public Builder withContext(Context context) {
            this.context = context;
            return this;
        }

        public Builder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public Builder apiInfo(ApiInfo apiInfo) {
            this.apiInfo = apiInfo;
            return this;
        }

        public Builder qualifier(String qualifier) {
            this.qualifier = qualifier;
            return this;
        }

        public Builder authority(String authority) {
            this.authority = authority;
            return this;
        }

        public Builder notification(int smallIcon, @NonNull String channel, int color) {
            this.smallIcon = smallIcon;
            this.channel = channel;
            this.color = color;
            return this;
        }

        public Builder logger(boolean logger) {
            this.logger = logger;
            return this;
        }

        public VisualService build() throws ParameterException {
            return new VisualServiceImpl(this);
        }
    }
}

