/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.parser.catcher;

import android.app.Notification;
import android.content.Context;
import android.content.Intent;
import android.service.notification.StatusBarNotification;
import android.support.annotation.RequiresApi;
import android.text.TextUtils;
import com.tenqube.visual_third.parser.catcher.SmsMmsService;
import com.tenqube.visual_third.util.Utils;
import java.io.Serializable;
import tenqube.parser.model.NotiRequest;

public class NotiManager {
    private static NotiManager mInstance = null;
    private final Context context;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NotiManager getInstance(Context ctx) {
        Class<NotiManager> clazz = NotiManager.class;
        synchronized (NotiManager.class) {
            if (mInstance == null) {
                mInstance = new NotiManager(ctx.getApplicationContext());
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return mInstance;
        }
    }

    private NotiManager(Context context) {
        this.context = context;
    }

    private boolean isInValid(String content, String packageName) {
        return TextUtils.isEmpty((CharSequence)content) || TextUtils.isEmpty((CharSequence)packageName) || "me.kkebi.ting".equals(packageName) || "com.android.systemui".equals(packageName) || "com.tenqube.qlip".equals(packageName) || "com.internet.speed.meter.lite".equals(packageName) || "com.sec.android.app.clockpackage".equals(packageName) || "wan.util.barclock".equals(packageName) || "com.eclipsim.gpsstatus2".equals(packageName) || "com.android.bluetooth".equals(packageName);
    }

    @RequiresApi(api=19)
    public void parseNoti(StatusBarNotification sbn) {
        String title = "none";
        String content = "";
        String bigContent = "";
        try {
            if (this.shouldParse(sbn)) {
                if (Utils.isSDKDisabled(this.context)) {
                    return;
                }
                String packageName = sbn.getPackageName();
                Notification notification = sbn.getNotification();
                CharSequence titleCS = notification.extras.getCharSequence("android.title");
                CharSequence contentCS = notification.extras.getCharSequence("android.text");
                CharSequence bigCS = notification.extras.getCharSequence("android.bigText");
                if (titleCS != null) {
                    title = titleCS.toString();
                }
                if (contentCS != null) {
                    content = contentCS.toString();
                }
                if (bigCS != null) {
                    bigContent = bigCS.toString();
                }
                if (this.isInValid(content, packageName)) {
                    return;
                }
                NotiRequest notiRequest = new NotiRequest(packageName, title, content, bigContent, notification.when);
                Intent startIntent = new Intent(this.context, SmsMmsService.class);
                startIntent.putExtra("ARG_SMS", (Serializable)notiRequest.toSMS(null));
                this.context.startService(startIntent);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @RequiresApi(api=19)
    private boolean shouldParse(StatusBarNotification sbn) {
        return sbn != null && !sbn.isOngoing() && sbn.getNotification() != null && sbn.getNotification().extras != null && sbn.getNotification().extras.getInt("android.progress") == 0 && sbn.getNotification().extras.getInt("android.progressMax") == 0;
    }
}

