package com.tenqube.visual_third.model.parser;

import android.text.TextUtils;

import com.tenqube.visual_third.exception.ParameterException;

import java.io.Serializable;

public class Transaction implements Serializable {

    private final tenqube.parser.model.Transaction parsedTransaction;
    private int cardId;
    private int userCateId;
    private double spentMoney;

    public Transaction(tenqube.parser.model.Transaction parsedTransaction) throws ParameterException {
        if(parsedTransaction == null) throw new ParameterException("parsedTransaction is empty");
        this.parsedTransaction = parsedTransaction;
    }

    public String getCardName()  {
        String cardName = parsedTransaction.cardName;
        if(cardName == null) {
            cardName = "";
        }

        String cardNum = parsedTransaction.cardNum;
        if(cardNum == null) {
            cardNum = "";
        } else {
            cardNum = cardNum.replace("(", "")
                    .replace(")", "");

            if(!TextUtils.isEmpty(cardNum)) {
                cardNum = "(" + cardNum + ")";
            }
        }

        return cardName + cardNum;
    }

    public void setCardId(int cardId) {
        this.cardId = cardId;
    }

    public void setUserCateId(int userCateId) {
        this.userCateId = userCateId;
    }

    public void setSpentMoney(double spentMoney) {
        this.spentMoney = spentMoney;
    }

    public tenqube.parser.model.Transaction getParsedTransaction() {
        return parsedTransaction;
    }

    public int getCardId() {
        return cardId;
    }

    public int getUserCateId() {
        return userCateId;
    }

    public double getSpentMoney() {
        return spentMoney;
    }

    public String getCategoryCode() {
        String categoryCode = "" + parsedTransaction.categoryCode;
        if(categoryCode.length() == 2) {
            categoryCode += "1010";
        }
        return categoryCode;
    }
}