//package com.tenqube.visual_third;
//
//import android.Manifest;
//import android.app.Activity;
//import android.content.Intent;
//import android.content.IntentFilter;
//import android.content.pm.PackageManager;
//import android.os.Bundle;
//import android.support.v4.app.ActivityCompat;
//import android.support.v4.content.ContextCompat;
//import android.text.TextUtils;
//import android.view.View;
//import android.widget.CompoundButton;
//import android.widget.Switch;
//import android.widget.Toast;
//
//import com.tenqube.visual_third.exception.ParameterException;
//import com.tenqube.visual_third.ui.OnResultListener;
//
//import static com.tenqube.visual_third.Constants.ACTION_TRAN_POPUP;
//import static com.tenqube.visual_third.ui.VisualWebActivity.ARG_PATH;
//import static com.tenqube.visual_third.ui.VisualWebActivity.VISUAL_REQUEST_CODE;
//
//
//public class MainActivity extends Activity {
//
//    public static final String API_KEY = ""; //api 키정보
//    private VisualService visualService;// 비주얼 서비스 객체
//    private String visualPath = "";
//
//    @Override
//    protected void onCreate(Bundle savedInstanceState) {
//        super.onCreate(savedInstanceState);
//        setContentView(R.layout.activity_main_test);
//
//        try {
//            // visual service 생성
//            visualService = new VisualServiceImpl(this,
//                    API_KEY,// 전달받은 api key devKey, prodKey
//                    Constants.DEV,// or Constants.PROD
//                    BuildConfig.APPLICATION_ID);
//
//
//            visualService.setLogger(true); // 개발자 모드 설정 (로그 확인이 가능합니다.)
//
//            // 팝업 설정
//            Switch popup = findViewById(R.id.popup);
//            popup.setChecked(visualService.isActiveTranPopup());
//            popup.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
//                @Override
//                public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
//                    visualService.setTranPopup(isChecked);
//                }
//            });
//
//            // daily 알림 설정
//            Switch daily = findViewById(R.id.daily);
//            daily.setChecked(visualService.isActiveReportAlarm(Constants.ReportAlarmType.DAILY));
//            daily.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
//                @Override
//                public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
//
//                    visualService.setReportAlarm(Constants.ReportAlarmType.DAILY, isChecked);
//                }
//            });
//
//            // weekly 알림 설정
//            Switch weekly = findViewById(R.id.weekly);
//            weekly.setChecked(visualService.isActiveReportAlarm(Constants.ReportAlarmType.WEEKLY));
//
//            weekly.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
//                @Override
//                public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
//                    visualService.setReportAlarm(Constants.ReportAlarmType.WEEKLY, isChecked);
//                }
//            });
//
//            // monthly 알림설정
//            Switch monthly = findViewById(R.id.monthly);
//            monthly.setChecked(visualService.isActiveReportAlarm(Constants.ReportAlarmType.MONTHLY));
//            monthly.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
//                @Override
//                public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
//                    visualService.setReportAlarm(Constants.ReportAlarmType.MONTHLY, isChecked);
//                }
//            });
//
//            IntentFilter filter = new IntentFilter();
//            filter.addAction(ACTION_TRAN_POPUP);
//
//            findViewById(R.id.lv0).setOnClickListener(new View.OnClickListener() {
//                @Override
//                public void onClick(View v) {
//                    visualService.getVisualSummary(new Callback<VisualSummary>() {
//                        @Override
//                        public void onDataLoaded(VisualSummary value) {
//                            Toast.makeText(getApplicationContext(), value.toString(), Toast.LENGTH_LONG).show();
//                        }
//                    });
//                }
//            });
//
//            findViewById(R.id.web).setOnClickListener(new View.OnClickListener() {
//                @Override
//                public void onClick(View v) {
//                    startVisual();
//                }
//            });
//
//
//            visualPath = getVisualPath();
//            if(!TextUtils.isEmpty(visualPath)) {
//                startVisual();
//            }
//
//        } catch (ParameterException e) {
//            e.printStackTrace();
//        }
//    }
//
//    private void startVisual() {
//
//
//        if (ContextCompat.checkSelfPermission(MainActivity.this,
//                Manifest.permission.READ_SMS)
//                != PackageManager.PERMISSION_GRANTED) {
//
//            // Should we show an explanation?
//            if (ActivityCompat.shouldShowRequestPermissionRationale(MainActivity.this,
//                    Manifest.permission.READ_SMS
//            )) {
//
//            } else {
//
//                ActivityCompat.requestPermissions(MainActivity.this,
//                        new String[]{Manifest.permission.READ_SMS, Manifest.permission.RECEIVE_SMS},
//                        0);
//
//            }
//        } else {
//            try {
//                // MainActivity.this 값을 통해 startActivityForResult로 호출합니다.
//                // IBK user 고유 아이디 정보를 추가해 주세요.
//                // getVisualPath() 함수를 통해 딥링크를 통해 들어온 값을 전달합니다.
//                visualService.startVisual(MainActivity.this, ":userUniqueId", visualPath, new VisualUserInfo(Constants.Gender.FEMALE, 1987),  new OnResultListener() {
//                    @Override
//                    public void onResult(int signUpResult, String msg) {
//
//                        Toast.makeText(getApplicationContext(), "result:" + signUpResult + "msg" + msg, Toast.LENGTH_LONG).show();
//
//                    }
//                });
//            } catch (ParameterException e) {
//                e.printStackTrace();
//            }
//        }
//
//    }
//
//    @Override
//    public void onRequestPermissionsResult(int requestCode,
//                                           String permissions[], int[] grantResults) {
//        switch (requestCode) {
//            case 0: {
//                // If request is cancelled, the result arrays are empty.
//                if (grantResults.length > 0
//                        && grantResults[0] == PackageManager.PERMISSION_GRANTED) {
//                    startVisual();
//                }
//            }
//        }
//    }
//
//
//    @Override
//    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
//        super.onActivityResult(requestCode, resultCode, data);
//
//        switch (requestCode) {
//
//            case VISUAL_REQUEST_CODE:
//                // 화면 종료시 해당 code로 콜백
//                break;
//        }
//    }
//    /**
//     * 딥링크를 통해 함수 가져오기
//     * @return 딥링크를 통해 전달받은 인텐트 정보(경로)
//     */
//    private String getVisualPath() {
//        Intent intent = getIntent();
//
//        if (intent != null && Intent.ACTION_VIEW.equals(intent.getAction())) {
//            String path = intent.getStringExtra(ARG_PATH);
//            intent.removeExtra(ARG_PATH);
//            return path;
//        }
//
//        return "";
//    }
//}