/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.parser.loader;

import android.content.Context;
import android.os.Handler;
import android.support.v4.app.NotificationManagerCompat;
import android.util.SparseIntArray;
import com.tenqube.visual_third.analysis.AnalysisServiceImpl;
import com.tenqube.visual_third.entity.Category;
import com.tenqube.visual_third.entity.Transaction;
import com.tenqube.visual_third.manager.AdManager;
import com.tenqube.visual_third.model.api.SearchCompanyRequest;
import com.tenqube.visual_third.model.api.SearchCompanyResponse;
import com.tenqube.visual_third.model.ui.TransactionPopupInfo;
import com.tenqube.visual_third.parser.loader.BaseLoader;
import com.tenqube.visual_third.ui.TransactionPopupActivity;
import com.tenqube.visual_third.util.Mapper;
import com.tenqube.visual_third.util.Utils;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import tenqube.parser.constants.Constants;
import tenqube.parser.core.ParserService;
import tenqube.parser.model.ParserResult;
import tenqube.parser.model.ResultCode;
import tenqube.parser.model.SMS;
import tenqube.parser.util.LogUtil;

public class OneLoader
extends BaseLoader {
    private static final String TAG = OneLoader.class.getSimpleName();
    private static OneLoader mInstance = null;
    private AdManager adManager;
    private int mServerCnt = 0;
    private Timer timer;
    private TimerTask timerTask;
    private SparseIntArray tranIds = new SparseIntArray();

    private OneLoader(Context context) {
        super(context);
        this.adManager = AdManager.getInstance(context);
    }

    public synchronized void doParsing(final SMS sms) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                LogUtil.LOGI((String)TAG, (String)("doParsing" + sms.toString()), (boolean)ParserService.mIsDebug);
                ParserResult parserResult = OneLoader.this.parserService.parse(sms);
                if (parserResult.resultCode != 1 && "com.samsung.android.spay".equals(sms.getSender())) {
                    SMS newSMS = new SMS(sms.getSmsId(), sms.getTitle(), sms.getSender(), sms.getDisplaySender(), sms.getSmsDate(), sms.getSmsType(), sms.getTitle());
                    parserResult = OneLoader.this.parserService.parse(newSMS);
                }
                LogUtil.LOGI((String)TAG, (String)("parserResult" + parserResult.resultCode + ResultCode.stringValueOf((Integer)parserResult.resultCode)), (boolean)ParserService.mIsDebug);
                switch (parserResult.resultCode) {
                    case -4: {
                        OneLoader.this.syncParsingRule(null);
                        break;
                    }
                    case -6: {
                        if (!Utils.shouldParsing(sms.getFullSms())) break;
                        OneLoader.this.syncParsingRuleAndNoSender();
                        break;
                    }
                    case -5: {
                        break;
                    }
                    case 1: {
                        OneLoader.this.parsedSMS(parserResult.transactions);
                    }
                }
            }
        }).start();
    }

    private void syncParsingRuleAndNoSender() {
        ++this.mServerCnt;
        if (this.mServerCnt == 10) {
            this.mServerCnt = 0;
            this.syncParsingRule(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OneLoader getInstance(Context context) {
        Class<OneLoader> clazz = OneLoader.class;
        synchronized (OneLoader.class) {
            if (mInstance == null) {
                mInstance = new OneLoader(context.getApplicationContext());
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return mInstance;
        }
    }

    private void parsedSMS(ArrayList<tenqube.parser.model.Transaction> parsedTransactions) {
        try {
            ArrayList<com.tenqube.visual_third.model.parser.Transaction> transactions = Mapper.toParserTransactions(parsedTransactions);
            com.tenqube.visual_third.model.parser.Transaction currentTran = this.getCurrentTransaction(transactions);
            if (currentTran == null || currentTran.getParsedTransaction() == null) {
                return;
            }
            this.addLocationInfo(currentTran);
            this.setCurrency(transactions);
            this.repository.mergeTransactions(transactions);
            int tranId = this.repository.loadTranId(currentTran.getParsedTransaction().identifier);
            if (tranId == 0) {
                return;
            }
            Transaction applyAllTran = this.repository.loadApplyAllTran(currentTran.getParsedTransaction().keyword);
            SearchCompanyResponse searchCompanyResponse = null;
            if (applyAllTran != null) {
                ArrayList<SearchCompanyResponse.TranCompany> results = new ArrayList<SearchCompanyResponse.TranCompany>();
                SearchCompanyResponse.Company company = new SearchCompanyResponse.Company(applyAllTran.getCompanyId(), applyAllTran.getFranchise(), "");
                SearchCompanyResponse.Category category = new SearchCompanyResponse.Category(applyAllTran.getCategoryCode() + "");
                SearchCompanyResponse.Keyword keyword = new SearchCompanyResponse.Keyword(applyAllTran.getKeyword(), applyAllTran.getSearchKeyword());
                SearchCompanyResponse.TranCompany tranCompany = new SearchCompanyResponse.TranCompany("" + applyAllTran.getIdentifier(), applyAllTran.getClassCode(), company, category, keyword);
                results.add(tranCompany);
                searchCompanyResponse = new SearchCompanyResponse(results);
            } else {
                ArrayList<SearchCompanyRequest.Transaction> apiTransactions = Mapper.toSearchTransaction(transactions);
                if (!Utils.isEmpty(apiTransactions)) {
                    searchCompanyResponse = this.repository.searchCompany(new SearchCompanyRequest(apiTransactions));
                }
            }
            if (searchCompanyResponse != null) {
                this.repository.updateTransactions(searchCompanyResponse);
            }
            this.repository.syncTransactions(null);
            AnalysisServiceImpl.shouldRefresh = true;
            this.repository.onTransactionReceived(tranId);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void startTimer(final int tranId, final com.tenqube.visual_third.model.parser.Transaction currentTran, final SearchCompanyResponse.TranCompany company, final Category category) {
        this.timer = new Timer();
        this.timerTask = new TimerTask(){

            @Override
            public void run() {
                OneLoader.this.stopTimer();
                OneLoader.this.startTranPopup(tranId, currentTran, company, category);
            }
        };
        this.timer.schedule(this.timerTask, 5000L);
    }

    private void stopTimer() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer.purge();
            this.timer = null;
            this.timerTask = null;
        }
    }

    private Category loadCategory(String categoryCode, int dwType, int cardType) {
        Category category = this.repository.loadCategory(categoryCode);
        if (category == null) {
            category = this.getDefaultCategory(dwType == Constants.DWType.DEPOSIT.ordinal(), cardType == Constants.CardType.BANK_ACCOUNT.ordinal());
        }
        return category;
    }

    private Category getDefaultCategory(boolean isDeposit, boolean isBank) {
        if (isDeposit) {
            return new Category(451, 901010, "\uae30\ud0c0\uc218\uc785", "\uae30\ud0c0", "\uc77c\ubc18");
        }
        if (isBank) {
            return new Category(444, 841010, "\ucd9c\uae08", "\uae30\ud0c0", "\uc77c\ubc18");
        }
        return new Category(72, 101010, "\ubbf8\ubd84\ub958", "\uae30\ud0c0", "\uc77c\ubc18");
    }

    private SearchCompanyResponse.TranCompany getDefaultTranCompany(tenqube.parser.model.Transaction currentTran) {
        String classCode;
        SearchCompanyResponse.Category category;
        SearchCompanyResponse.Company company;
        boolean isDeposit = currentTran.dwType == Constants.DWType.DEPOSIT.ordinal();
        boolean isBank = currentTran.cardType == Constants.CardType.BANK_ACCOUNT.ordinal();
        SearchCompanyResponse.Keyword keyword = new SearchCompanyResponse.Keyword(currentTran.keyword, currentTran.keyword);
        String identifier = currentTran.identifier;
        if (isDeposit) {
            company = new SearchCompanyResponse.Company(3983462, "\uae30\ud0c0", "");
            category = new SearchCompanyResponse.Category("901010");
            classCode = "DP";
        } else if (isBank) {
            company = new SearchCompanyResponse.Company(3983436, "\uae30\ud0c0", "");
            category = new SearchCompanyResponse.Category("841010");
            classCode = "WFDW";
        } else {
            company = new SearchCompanyResponse.Company(1260117, "\ubbf8\ubd84\ub958", "");
            category = new SearchCompanyResponse.Category("101010");
            classCode = "NF";
        }
        return new SearchCompanyResponse.TranCompany(identifier, classCode, company, category, keyword);
    }

    private com.tenqube.visual_third.model.parser.Transaction getCurrentTransaction(ArrayList<com.tenqube.visual_third.model.parser.Transaction> transactions) {
        for (com.tenqube.visual_third.model.parser.Transaction transaction : transactions) {
            if (!transaction.getParsedTransaction().isCurrentTran) continue;
            return transaction;
        }
        return null;
    }

    private void addLocationInfo(com.tenqube.visual_third.model.parser.Transaction currentTran) {
        currentTran.getParsedTransaction().spentLatitude = -1.0;
        currentTran.getParsedTransaction().spentLongitude = -1.0;
    }

    private SearchCompanyResponse.TranCompany findSearchedCompany(SearchCompanyResponse searchCompanyResponse, tenqube.parser.model.Transaction currentTran) {
        if (searchCompanyResponse != null && currentTran != null) {
            for (SearchCompanyResponse.TranCompany company : searchCompanyResponse.getResults()) {
                if (!company.getIdentifier().equals(currentTran.identifier)) continue;
                return company;
            }
        }
        return this.getDefaultTranCompany(currentTran);
    }

    private void startTranPopup(final int tranId, final com.tenqube.visual_third.model.parser.Transaction currentTran, final SearchCompanyResponse.TranCompany company, final Category category) {
        if (this.tranIds.get(tranId) != 0) {
            this.tranIds.delete(tranId);
            new Handler(this.mContext.getMainLooper()).post(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (OneLoader.this.repository.isAppNoti() && OneLoader.this.repository.isActiveTranPopup() && NotificationManagerCompat.from((Context)OneLoader.this.mContext).areNotificationsEnabled()) {
                            TransactionPopupInfo transactionPopupInfo = new TransactionPopupInfo(tranId, currentTran, company, category);
                            TransactionPopupActivity.startActivity(OneLoader.this.mContext, transactionPopupInfo);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
    }
}

