/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.parser.loader;

import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import com.tenqube.visual_third.Callback;
import com.tenqube.visual_third.VisualServiceImpl;
import com.tenqube.visual_third.model.api.SearchCompanyRequest;
import com.tenqube.visual_third.model.api.SearchCompanyResponse;
import com.tenqube.visual_third.model.parser.SyncTransaction;
import com.tenqube.visual_third.model.parser.Transaction;
import com.tenqube.visual_third.parser.loader.BaseLoader;
import com.tenqube.visual_third.util.Mapper;
import com.tenqube.visual_third.util.Utils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import tenqube.parser.BulkSmsAdapter;
import tenqube.parser.OnNetworkResultListener;
import tenqube.parser.constants.Constants;
import tenqube.parser.core.ParserService;
import tenqube.parser.model.SMS;
import tenqube.parser.util.LogUtil;

public class BulkLoader
extends BaseLoader
implements BulkSmsAdapter {
    private static final String TAG = BulkLoader.class.getSimpleName();
    private static final int BULK_MONTH = -3;
    private Cursor mCursor;
    private final Handler mHandler;
    private final OnSmsLoadFinished onSmsLoadFinished;
    private long lastSmsDate;

    public BulkLoader(Context context, Handler handler, OnSmsLoadFinished onSmsLoadFinished) {
        super(context);
        this.mHandler = handler;
        this.onSmsLoadFinished = onSmsLoadFinished;
    }

    public void doParsing() {
        this.initCursor();
        this.syncParsingRule(new Callback<Boolean>(){

            @Override
            public void onDataLoaded(Boolean value) {
                BulkLoader.this.parserService.parseBulk((BulkSmsAdapter)BulkLoader.this);
            }
        });
    }

    private long getLastSmsDate(List<SyncTransaction> transactions) {
        long maxTime = 0L;
        long today = new Date().getTime();
        for (SyncTransaction tran : transactions) {
            long time = Utils.toTime(tran.spentDate);
            if (time > today || time <= maxTime) continue;
            maxTime = time;
        }
        return maxTime;
    }

    private void initCursor() {
        try {
            LogUtil.LOGI((String)TAG, (String)"initCursor: start", (boolean)VisualServiceImpl.logger);
            Uri uri = Uri.parse((String)"content://sms/inbox");
            this.mCursor = this.mContext.getContentResolver().query(uri, null, this.getWhere(), null, "date asc");
            if (this.mCursor != null) {
                this.mCursor.moveToFirst();
            }
        }
        catch (Exception e) {
            LogUtil.LOGI((String)TAG, (String)("initCursor: " + e.toString()), (boolean)VisualServiceImpl.logger);
            this.onError(1);
        }
    }

    private String getWhere() {
        Calendar calendar = Calendar.getInstance();
        long time = this.prefManager.loadLongValue("TENQUBE_SIGN_UP_TIME", 0L);
        if (time == 0L) {
            time = calendar.getTimeInMillis();
        } else {
            calendar.setTimeInMillis(time);
        }
        LogUtil.LOGI((String)TAG, (String)("BulkTime toDate: " + Utils.getStringDateAsYYYYMMddHHmmss(calendar)), (boolean)VisualServiceImpl.logger);
        int month = calendar.get(2);
        calendar.set(2, month);
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        calendar.add(2, -3);
        LogUtil.LOGI((String)TAG, (String)("BulkTime fromDate: " + Utils.getStringDateAsYYYYMMddHHmmss(calendar)), (boolean)ParserService.mIsDebug);
        String where = this.lastSmsDate == 0L ? "date >= " + calendar.getTimeInMillis() + " and date <= " + time : "date > " + this.lastSmsDate + " and date <= " + time;
        LogUtil.LOGI((String)TAG, (String)("getWhere: " + where), (boolean)VisualServiceImpl.logger);
        return where;
    }

    public int getSmsCount() {
        int cnt = this.mCursor == null ? 0 : this.mCursor.getCount();
        LogUtil.LOGI((String)TAG, (String)("getSmsCount: " + cnt), (boolean)VisualServiceImpl.logger);
        return cnt;
    }

    public SMS getSmsAt(int n) {
        return this.getSMS();
    }

    private SMS getSMS() {
        SMS sms = null;
        if (this.mCursor != null) {
            sms = new SMS(this.mCursor.getInt(this.mCursor.getColumnIndex("_id")), this.mCursor.getString(this.mCursor.getColumnIndex("body")), this.mCursor.getString(this.mCursor.getColumnIndex("address")), this.mCursor.getString(this.mCursor.getColumnIndex("address")), Utils.getConvertedDate(this.mCursor.getLong(this.mCursor.getColumnIndex("date"))), Constants.SMSType.SMS.ordinal());
            this.mCursor.moveToNext();
        }
        return sms;
    }

    public void onProgress(int now, int total) {
        int percent = this.lastSmsDate == 0L ? now * 100 / total + 1 : 10 + (now * 90 / total + 1);
        Bundle data = new Bundle();
        data.putInt("percent", percent);
        data.putInt("now", now);
        data.putInt("total", total);
        this.sendHandlerMsg(data, 11, percent);
    }

    public void sendToServerTransactions(ArrayList<tenqube.parser.model.Transaction> parsedTransactions, OnNetworkResultListener callback) {
        try {
            SearchCompanyResponse response;
            LogUtil.LOGI((String)TAG, (String)("sendToServerTransactions: " + parsedTransactions.size()), (boolean)VisualServiceImpl.logger);
            ArrayList subParsedTransactions = parsedTransactions.size() > 30 ? (ArrayList)parsedTransactions.subList(0, 30) : parsedTransactions;
            ArrayList<Transaction> transactions = Mapper.toParserTransactions(subParsedTransactions);
            this.setCurrency(transactions);
            this.repository.mergeTransactions(transactions);
            ArrayList<SearchCompanyRequest.Transaction> apiTransactions = Mapper.toSearchTransaction(transactions);
            if (!Utils.isEmpty(apiTransactions) && (response = this.repository.searchCompany(new SearchCompanyRequest(apiTransactions))) != null) {
                this.repository.updateTransactions(response);
            }
            this.repository.syncTransactions(callback);
        }
        catch (Exception e) {
            callback.onResult(true);
        }
    }

    public void onCompleted() {
        this.sendHandlerMsg(null, 10, 0);
        if (this.mCursor != null) {
            this.mCursor.close();
        }
        if (this.onSmsLoadFinished != null) {
            this.onSmsLoadFinished.onFinished(false);
        }
    }

    public void onError(int resultCode) {
        this.sendHandlerMsg(null, 10, 0);
        if (this.mCursor != null) {
            this.mCursor.close();
        }
        if (this.onSmsLoadFinished != null) {
            this.onSmsLoadFinished.onFinished(true);
        }
    }

    private void sendHandlerMsg(Bundle data, int what, int arg1) {
        if (this.mHandler != null) {
            Message hMsg = this.mHandler.obtainMessage();
            if (data != null) {
                hMsg.setData(data);
            }
            hMsg.what = what;
            hMsg.arg1 = arg1;
            this.mHandler.sendMessage(hMsg);
        }
    }

    public static interface OnSmsLoadFinished {
        public void onFinished(boolean var1);
    }
}

