package com.tenqube.visual_third.parser.catcher;

import android.annotation.TargetApi;
import android.content.Intent;
import android.os.Build;
import android.os.IBinder;
import android.service.notification.NotificationListenerService;
import android.service.notification.StatusBarNotification;

@TargetApi(Build.VERSION_CODES.JELLY_BEAN_MR2)
public class NotiCatcher extends NotificationListenerService {

    private String TAG = this.getClass().getSimpleName();

    private NotiManager notiManager;

    @Override
    public IBinder onBind(Intent mIntent) {
        return super.onBind(mIntent);
    }

    @Override
    public boolean onUnbind(Intent mIntent) {
        return super.onUnbind(mIntent);
    }

    @Override
    public void onCreate() {
        super.onCreate();
        notiManager = NotiManager.getInstance(getApplicationContext());
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
    }

    @TargetApi(Build.VERSION_CODES.KITKAT)
    @Override
    public void onNotificationPosted(final StatusBarNotification sbn) {

        notiManager.parseNoti(sbn);

    }



    @Override
    public void onNotificationRemoved(StatusBarNotification sbn) {

    }

    @Override
    public int onStartCommand(Intent intent, int flags, int startId) {
        return START_REDELIVER_INTENT;
    }

    @Override
    public void onListenerConnected() {
        super.onListenerConnected();
    }

    @Override
    public void onListenerDisconnected() {
        super.onListenerDisconnected();
    }

}


