/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.util;

import android.app.Activity;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.net.Uri;
import android.os.Build;
import android.support.v4.app.NotificationManagerCompat;
import android.support.v4.content.FileProvider;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.widget.LinearLayout;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.tenqube.visual_third.R;
import com.tenqube.visual_third.manager.PrefManager;
import com.tenqube.visual_third.manager.SecretKeyManager;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class Utils {
    public static final SimpleDateFormat timeDf = new SimpleDateFormat("HH:mm:ss", Locale.KOREA);
    public static final SimpleDateFormat ymdDF = new SimpleDateFormat("yyyy-MM-dd", Locale.KOREA);
    public static final SimpleDateFormat fullDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.KOREA);
    public static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("00");
    private static final DecimalFormat THREE_COMMA_FORMAT = new DecimalFormat("###,###");

    public static InputStream toInputStream(Object data) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(data);
        oos.flush();
        oos.close();
        return new ByteArrayInputStream(baos.toByteArray());
    }

    public static String getApplicationName(Context context) {
        try {
            ApplicationInfo applicationInfo = context.getApplicationInfo();
            int stringId = applicationInfo.labelRes;
            return stringId == 0 ? applicationInfo.nonLocalizedLabel.toString() : context.getString(stringId);
        }
        catch (Exception e) {
            return "\ud574\ub2f9 \uc571";
        }
    }

    public static String makeDialogPath(int tranId, String keyword, String lCategory, String mCategory, String lCode, String mCode, String spentDate, double amount, int installmentCnt, int cardId, String memo, String dwType, String prevPage) {
        return String.format(Locale.KOREA, "&id=%1$d&keyword=%2$s&lCategory=%3$s&mCategory=%4$s&lCode=%5$s&mCode=%6$s&date=%7$s&amount=%8$f&installmentCnt=%9$d&cardId=%10$d&memo=%11$s&dwType=%12$s&prevPage=%13$s", tranId, keyword, lCategory, mCategory, lCode, mCode, spentDate, amount, installmentCnt, cardId, memo, dwType, prevPage);
    }

    public static Uri getUri(Context context, String authority, File file) throws Exception {
        if (Build.VERSION.SDK_INT >= 24) {
            return FileProvider.getUriForFile((Context)context.getApplicationContext(), (String)authority, (File)file);
        }
        return Uri.fromFile((File)file);
    }

    public static String getAdId(Context context) {
        try {
            AdvertisingIdClient.Info info = AdvertisingIdClient.getAdvertisingIdInfo((Context)context);
            if (info != null && !info.isLimitAdTrackingEnabled()) {
                return info.getId();
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    public static boolean isSDKDisabled(Context context) {
        try {
            boolean isEnabled = PrefManager.getInstance(context).isEnabled("TENQUBE_SDK_ENABLED", true);
            boolean isAuth = !TextUtils.isEmpty((CharSequence)SecretKeyManager.getInstance(context).getKey("TENQUBE_ACCESS_TOKEN"));
            return !isEnabled || !isAuth;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static <T> boolean isEmpty(ArrayList<T> list) {
        return list == null || list.size() == 0;
    }

    public static <T> T fromJson(String param, Class<T> classOfT) {
        Gson gson = new Gson();
        return (T)gson.fromJson(param, classOfT);
    }

    public static String toJson(Object object) {
        Gson gson = new GsonBuilder().disableHtmlEscaping().create();
        return gson.toJson(object);
    }

    public static boolean shouldParsing(String msg) {
        int cnt = 0;
        if (TextUtils.isEmpty((CharSequence)msg)) {
            return false;
        }
        if (msg.contains("\uc6d0")) {
            ++cnt;
        }
        if (msg.contains(".")) {
            ++cnt;
        }
        if (msg.contains(",")) {
            ++cnt;
        }
        if (cnt == 3) {
            return true;
        }
        if (msg.contains("/")) {
            ++cnt;
        }
        return cnt > 2;
    }

    public static String getConvertedDate(long date) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(date);
        return Utils.getStringDateAsYYYYMMddHHmmss(cal);
    }

    public static String getStringDateAsYYYYMMddHHmmss(Calendar cal) {
        try {
            if (cal == null) {
                cal = Calendar.getInstance();
            }
            return cal.get(1) + "-" + DECIMAL_FORMAT.format(cal.get(2) + 1) + "-" + DECIMAL_FORMAT.format(cal.get(5)) + " " + DECIMAL_FORMAT.format(cal.get(11)) + ":" + DECIMAL_FORMAT.format(cal.get(12)) + ":" + DECIMAL_FORMAT.format(cal.get(13));
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static String threeComma(double value) {
        return THREE_COMMA_FORMAT.format((long)value) + "\uc6d0";
    }

    public static String[] getDateRange(int year, int month, int before) {
        String[] dates = new String[2];
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, year);
        calendar.set(2, month - 1);
        calendar.add(2, -1 * before);
        dates[0] = "'" + calendar.get(1) + "-" + DECIMAL_FORMAT.format(calendar.get(2) + 1) + "-01 00:00:00'";
        calendar = Calendar.getInstance();
        calendar.set(1, year);
        calendar.set(2, month - 1);
        calendar.add(2, 1);
        dates[1] = "'" + calendar.get(1) + "-" + DECIMAL_FORMAT.format(calendar.get(2) + 1) + "-01 00:00:00'";
        return dates;
    }

    public static int getCategoryIcon(int categoryCode) {
        switch (categoryCode) {
            case 10: {
                return R.drawable.ic_withdraw_etc;
            }
            case 22: {
                return R.drawable.ic_withdraw_food;
            }
            case 24: {
                return R.drawable.ic_withdraw_cafe;
            }
            case 26: {
                return R.drawable.ic_withdraw_alcohol;
            }
            case 32: {
                return R.drawable.ic_withdraw_mart;
            }
            case 34: {
                return R.drawable.ic_withdraw_online;
            }
            case 36: {
                return R.drawable.ic_withdraw_shopping;
            }
            case 42: {
                return R.drawable.ic_withdraw_finance;
            }
            case 44: {
                return R.drawable.ic_withdraw_health_care;
            }
            case 46: {
                return R.drawable.ic_withdraw_beauty;
            }
            case 52: {
                return R.drawable.ic_withdraw_livings;
            }
            case 54: {
                return R.drawable.ic_withdraw_education;
            }
            case 56: {
                return R.drawable.ic_withdraw_culture;
            }
            case 62: {
                return R.drawable.ic_withdraw_transport;
            }
            case 64: {
                return R.drawable.ic_withdraw_leports;
            }
            case 66: {
                return R.drawable.ic_withdraw_travel;
            }
            case 82: {
                return R.drawable.ic_withdraw_family_event;
            }
            case 84: {
                return R.drawable.ic_withdraw;
            }
            case 88: {
                return R.drawable.ic_withdraw_moving_asset;
            }
            case 90: {
                return R.drawable.visual_ic_deposit_etc;
            }
            case 92: {
                return R.drawable.visual_ic_deposit_income_main;
            }
            case 94: {
                return R.drawable.ic_deposit_income_sub;
            }
            case 96: {
                return R.drawable.visual_ic_deposit_loan;
            }
            case 98: {
                return R.drawable.ic_deposit_moving_asset;
            }
        }
        return 0;
    }

    public static boolean isNotiEnabled(Context context) {
        return NotificationManagerCompat.getEnabledListenerPackages((Context)context).contains(context.getPackageName());
    }

    public static ArrayList<String> getDailyDateRanges(int before) {
        ArrayList<String> resultItems = new ArrayList<String>();
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -1 * before);
        String startStr = calendar.get(1) + "-" + DECIMAL_FORMAT.format(calendar.get(2) + 1) + "-" + DECIMAL_FORMAT.format(calendar.get(5));
        resultItems.add(startStr);
        resultItems.add(startStr);
        return resultItems;
    }

    public static ArrayList<String> getWeeklyDateRanges(int before) {
        int endDateNum;
        int startDateNum;
        ArrayList<String> resultItems = new ArrayList<String>();
        Calendar startCal = Calendar.getInstance();
        Calendar endCal = Calendar.getInstance();
        Calendar todayCal = Calendar.getInstance();
        int dayOfWeek = todayCal.get(7);
        if (dayOfWeek == 1) {
            startDateNum = -7 * before - 6;
            endDateNum = -7 * before;
        } else {
            startDateNum = -7 * before - (dayOfWeek - 2);
            endDateNum = -7 * before + 8 - dayOfWeek;
        }
        startCal.add(5, startDateNum);
        String startStr = startCal.get(1) + "-" + DECIMAL_FORMAT.format(startCal.get(2) + 1) + "-" + DECIMAL_FORMAT.format(startCal.get(5));
        resultItems.add(startStr);
        endCal.add(5, endDateNum);
        String endStr = endCal.get(1) + "-" + DECIMAL_FORMAT.format(endCal.get(2) + 1) + "-" + DECIMAL_FORMAT.format(endCal.get(5));
        resultItems.add(endStr);
        return resultItems;
    }

    public static boolean compareDate(Calendar beforeDate, Calendar afterDate) {
        try {
            return beforeDate.before(afterDate) || beforeDate.equals(afterDate);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean compareDate(String beforeDate, String afterDate) {
        try {
            Date before = fullDF.parse(Utils.getYMD(beforeDate) + " 00:00:00");
            Date after = fullDF.parse(Utils.getYMD(afterDate) + " 00:00:00");
            return before.before(after) || before.equals(after);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean compareDateBefore(String beforeDate, String afterDate) {
        try {
            Date before = fullDF.parse(Utils.getYMD(beforeDate) + " 00:00:00");
            Date after = fullDF.parse(Utils.getYMD(afterDate) + " 00:00:00");
            return before.before(after);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean compareDatetime(String beforeDate, String afterDate) {
        try {
            Date before = fullDF.parse(beforeDate);
            Date after = fullDF.parse(afterDate);
            return before.before(after);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean equalsDatetime(String beforeDate, String afterDate) {
        try {
            Date before = fullDF.parse(beforeDate);
            Date after = fullDF.parse(afterDate);
            return before.equals(after);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean equalsDate(String beforeDate, String afterDate) {
        try {
            Date before = fullDF.parse(Utils.getYMD(beforeDate) + " 00:00:00");
            Date after = fullDF.parse(Utils.getYMD(afterDate) + " 00:00:00");
            return before.equals(after);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean ltDate(String beforeDate, String afterDate) {
        try {
            Date before = fullDF.parse(Utils.getYMD(beforeDate) + " 00:00:00");
            Date after = fullDF.parse(Utils.getYMD(afterDate) + " 00:00:00");
            return before.before(after);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean gtDate(String beforeDate, String afterDate) {
        try {
            Date before = fullDF.parse(Utils.getYMD(beforeDate) + " 00:00:00");
            Date after = fullDF.parse(Utils.getYMD(afterDate) + " 00:00:00");
            return before.after(after);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String getYMD(String date) {
        return date.substring(0, 10);
    }

    public static String getYMD(Calendar date) {
        int year = date.get(1);
        int month = date.get(2) + 1;
        int day = date.get(5);
        return "" + year + "-" + DECIMAL_FORMAT.format(month) + "-" + DECIMAL_FORMAT.format(day);
    }

    public static String getHMS(Calendar date) {
        int hour = date.get(11);
        int minute = date.get(12);
        int second = date.get(13);
        return "" + DECIMAL_FORMAT.format(hour) + ":" + DECIMAL_FORMAT.format(minute) + ":" + DECIMAL_FORMAT.format(second);
    }

    public static String getYM(String date) {
        return date.substring(0, 7);
    }

    public static String getYM(Calendar date) {
        int year = date.get(1);
        int month = date.get(2) + 1;
        return "" + year + "-" + DECIMAL_FORMAT.format(month);
    }

    public static Calendar toCalendar(String dateStr) {
        Calendar calendar = Calendar.getInstance();
        try {
            Date date = fullDF.parse(dateStr);
            calendar.setTime(date);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return calendar;
    }

    public static Calendar toCalendarYMD(String dateStr) {
        Calendar calendar = Calendar.getInstance();
        try {
            Date date = ymdDF.parse(dateStr);
            calendar.setTime(date);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return calendar;
    }

    public static Calendar toCalendarHMS(String time) {
        Calendar calendar = Calendar.getInstance();
        try {
            Date date = timeDf.parse(time);
            calendar.setTime(date);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return calendar;
    }

    public static int getDiffDay(Calendar before, Calendar after) {
        before.set(11, 0);
        before.set(12, 0);
        before.set(13, 0);
        after.set(11, 0);
        after.set(12, 0);
        after.set(13, 0);
        long start = before.getTimeInMillis();
        long end = after.getTimeInMillis();
        Long diff = (end - start) / 86400000L;
        return diff.intValue() + 1;
    }

    public static boolean isOddDay() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(5) % 2 != 0;
    }

    public static boolean isEvenDay() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(5) % 2 == 0;
    }

    public static int getDeviceHeight(Activity activity) {
        DisplayMetrics dm = new DisplayMetrics();
        activity.getWindowManager().getDefaultDisplay().getMetrics(dm);
        return dm.heightPixels;
    }

    public static double calculateCurrency(double money, String currency) {
        if ("USD".equals(currency)) {
            return money * 1063.25;
        }
        if ("THB".equals(currency)) {
            return money * 33.29;
        }
        if ("JPY".equals(currency)) {
            return money * 9.6;
        }
        if ("CNY".equals(currency)) {
            return money * 165.08;
        }
        if ("RUB".equals(currency)) {
            return money * 18.88;
        }
        if ("TWD".equals(currency)) {
            return money * 36.0;
        }
        if ("AUD".equals(currency)) {
            return money * 845.22;
        }
        if ("NZD".equals(currency)) {
            return money * 773.95;
        }
        if ("SGD ".equals(currency)) {
            return money * 804.24;
        }
        if ("HKD".equals(currency)) {
            return money * 135.91;
        }
        if ("PHP".equals(currency)) {
            return money * 21.09;
        }
        if ("IDR".equals(currency)) {
            return money * 0.079;
        }
        if ("INR ".equals(currency)) {
            return money * 16.759;
        }
        if ("MYR".equals(currency)) {
            return money * 269.73;
        }
        if ("EUR".equals(currency)) {
            return money * 1298.8;
        }
        if ("GBP".equals(currency)) {
            return money * 1462.11;
        }
        if ("VND".equals(currency)) {
            return money * 0.047;
        }
        if ("CAD".equals(currency)) {
            return money * 854.42;
        }
        if ("DKK".equals(currency)) {
            return money * 174.36;
        }
        return money;
    }

    public static void changeColor(LinearLayout container, int color2) {
        Drawable background = container.getBackground();
        if (background instanceof GradientDrawable) {
            ((GradientDrawable)background).setStroke(3, color2);
        }
    }

    public static int dpToPx(int dp) {
        return (int)((float)dp * Resources.getSystem().getDisplayMetrics().density);
    }

    public static Calendar convertStringToCalendarFULL(String date) {
        Calendar resultCal = Calendar.getInstance();
        if (date == null || TextUtils.isEmpty((CharSequence)date)) {
            return resultCal;
        }
        try {
            Date d = fullDF.parse(date);
            resultCal.setTime(d);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return resultCal;
    }
}

