package com.tenqube.visual_third.api.visual;

import android.content.Context;

import com.tenqube.visual_third.api.resource.ResourceServiceImpl;
import com.tenqube.visual_third.manager.PrefManager;
import com.tenqube.visual_third.model.api.AdInfoResponse;
import com.tenqube.visual_third.model.api.AdResponse;
import com.tenqube.visual_third.model.api.CurrencyResponse;
import com.tenqube.visual_third.model.api.TransactionRequest;

import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class VisualApiServiceImpl implements VisualApiService {

    private static final String TAG = ResourceServiceImpl.class.getSimpleName();

    private final VisualApi visualApi;
    private final PrefManager prefManager;
    private final Context context;

    private VisualApiServiceImpl(Context context, VisualApi visualApi, PrefManager prefManager) {
        this.context = context;
        this.visualApi = visualApi;
        this.prefManager = prefManager;
    }

    private static VisualApiService mInstance;

    public static VisualApiService getInstance(Context context, VisualApi visualApi, PrefManager prefManager) {
        synchronized (VisualApiServiceImpl.class) {
            if (mInstance == null) {
                mInstance = new VisualApiServiceImpl(context, visualApi, prefManager);
            }
        }
        return mInstance;
    }


    @Override
    public CurrencyResponse getCurrencyRate(String from, String to) {
        try {

            Response<CurrencyResponse> response = visualApi.callCurrencyRate(
                    from.toLowerCase(), to.toLowerCase()).execute();

            if(response.isSuccessful()) {
                return response.body();
//                if(currencyResponse != null) {
//                    repository.mergeCurrency(from, to, currencyResponse.getRate(), Utils.getStringDateAsYYYYMMddHHmmss(Calendar.getInstance()));
//                    return currencyResponse.getRate();
//                }
            }
        } catch (Exception e) {

        }

        return null;
    }

    @Override
    public void saveTransactions(TransactionRequest transactionRequest, Callback<Void> callback) {
        Call<Void> call = visualApi.saveTransactions(transactionRequest);
        call.enqueue(callback);
    }

    @Override
    public AdInfoResponse getAdInfo() {
        try {

            Response<AdInfoResponse> res = visualApi.getAdInfo().execute();

            if(res.isSuccessful()) {
                AdInfoResponse response = res.body();
                if(response != null) {
                    return response;
                }
            }
        } catch (Exception e) {

        }

        return null;
    }

    public AdResponse getAds(int version) {
        try {
            Response<AdResponse> res = visualApi.getAds(version).execute();

            if(res.isSuccessful()) {
                AdResponse response = res.body();
                if(response != null) {
                    return response;
                }
            }
        } catch (Exception e) {

        }

        return null;
    }
}
