/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.ui;

import android.app.Activity;
import android.graphics.Color;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v7.widget.CardView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebResourceRequest;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import com.tenqube.visual_third.Callback;
import com.tenqube.visual_third.Constants;
import com.tenqube.visual_third.R;
import com.tenqube.visual_third.analysis.AnalysisServiceImpl;
import com.tenqube.visual_third.manager.AdManager;
import com.tenqube.visual_third.manager.PrefManager;
import com.tenqube.visual_third.manager.VisualAlarmManager;
import com.tenqube.visual_third.model.ui.TransactionPopupInfo;
import com.tenqube.visual_third.parser.loader.BulkLoader;
import com.tenqube.visual_third.repository.RepositoryHolder;
import com.tenqube.visual_third.repository.VisualRepository;
import com.tenqube.visual_third.ui.ActivityCallback;
import com.tenqube.visual_third.ui.BottomDialog;
import com.tenqube.visual_third.ui.OnResultListener;
import com.tenqube.visual_third.ui.VisualWebActivity;
import com.tenqube.visual_third.util.Utils;
import com.tenqube.visual_third.util.WebViewHelper;
import com.tenqube.visual_third.web.ActionImpl;
import com.tenqube.visual_third.web.ErrorImpl;
import com.tenqube.visual_third.web.LogImpl;
import com.tenqube.visual_third.web.RepoImpl;
import com.tenqube.visual_third.web.SystemImpl;
import com.tenqube.visual_third.web.UiImpl;
import com.tenqube.visual_third.web.VisualInterface;
import tenqube.parser.core.ParserService;
import tenqube.parser.util.LogUtil;

public class VisualWebFragment
extends Fragment
implements ActivityCallback {
    private static final String ARG_UID = "ARG_UID";
    private BulkLoader bulkLoader;
    private WebView webview;
    private VisualRepository repository;
    private VisualAlarmManager alarmManager;
    private String mFailingUrl;
    private VisualInterface.Repo repoInterface;
    private VisualInterface.UI uiInterface;
    private VisualInterface.System systemInterface;
    private VisualInterface.Error errorInterface;
    private VisualInterface.Log logInterface;
    private VisualInterface.Action actionInterface;
    private LinearLayout errorView;
    private boolean isError;
    private String baseUrl = "";
    private CardView adContainer;
    private FrameLayout webContainer;
    private String uid;
    private Handler handler = new Handler(new Handler.Callback(){

        public boolean handleMessage(Message msg) {
            try {
                LogUtil.LOGI((String)"VisualFlow", (String)("startBulk handleMessage" + msg.what), (boolean)ParserService.mIsDebug);
                switch (msg.what) {
                    case 11: {
                        Bundle bundle;
                        LogUtil.LOGI((String)"VisualFlow", (String)"startBulk handleMessage PROGRESS", (boolean)ParserService.mIsDebug);
                        if (VisualWebFragment.this.webview != null && (bundle = msg.getData()) != null) {
                            VisualWebFragment.this.webview.loadUrl("javascript:window.onProgress(" + bundle.getInt("now") + "," + bundle.getInt("total") + ");");
                        }
                        break;
                    }
                    case 12: {
                        LogUtil.LOGI((String)"VisualFlow", (String)"startBulk handleMessage SHOW_PROGRESS_BAR", (boolean)ParserService.mIsDebug);
                        VisualWebFragment.this.loadProgress();
                        break;
                    }
                    default: {
                        LogUtil.LOGI((String)"VisualFlow", (String)"startBulk handleMessage onBulkFinish", (boolean)ParserService.mIsDebug);
                        VisualWebFragment.this.onBulkFinish();
                    }
                }
            }
            catch (Exception e) {
                LogUtil.LOGI((String)"VisualFlow", (String)("startBulk handleMessage Exception" + e.toString()), (boolean)ParserService.mIsDebug);
                VisualWebFragment.this.onBulkFinish();
            }
            return false;
        }
    });

    public static VisualWebFragment newInstance(@NonNull String uid) {
        VisualWebFragment fragment = new VisualWebFragment();
        Bundle args = new Bundle();
        args.putString(ARG_UID, uid);
        fragment.setArguments(args);
        return fragment;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.getArguments() != null) {
            this.uid = this.getArguments().getString(ARG_UID);
        }
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_visual_web, container, false);
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        try {
            this.repository = RepositoryHolder.getInstance(this.getContext()).getVisualRepository();
            this.alarmManager = VisualAlarmManager.getInstance(this.getContext());
            this.errorView = (LinearLayout)view.findViewById(R.id.error_container);
            this.errorView.setVisibility(8);
            view.findViewById(R.id.retry).setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    VisualWebFragment.this.startVisual();
                }
            });
            this.webview = (WebView)view.findViewById(R.id.visual_web_view);
            this.webContainer = (FrameLayout)view.findViewById(R.id.web_container);
            this.errorInterface = new ErrorImpl(this, this.webview);
            this.logInterface = new LogImpl(this, this.webview, this.errorInterface);
            this.repoInterface = new RepoImpl(this, this.webview, this.errorInterface, this.repository, new AnalysisServiceImpl(this.getContext(), ""), this.alarmManager);
            this.uiInterface = new UiImpl(this, this.webview, this.errorInterface, new BottomDialog((Activity)this.getActivity()), AdManager.getInstance(this.getContext()));
            this.systemInterface = new SystemImpl(this, this.webview, this.errorInterface);
            this.actionInterface = new ActionImpl(this, this.webview);
            this.webview.addJavascriptInterface((Object)this.errorInterface, "visualError");
            this.webview.addJavascriptInterface((Object)this.repoInterface, "visualRepo");
            this.webview.addJavascriptInterface((Object)this.uiInterface, "visualUI");
            this.webview.addJavascriptInterface((Object)this.systemInterface, "visualSystem");
            this.webview.addJavascriptInterface((Object)this.logInterface, "visualLog");
            this.webview.addJavascriptInterface((Object)this.actionInterface, "visualAction");
            WebViewHelper.settings(this.webview, this.repository.isDev());
            this.webview.setWebViewClient(new WebViewClient(){

                public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
                    return super.shouldOverrideUrlLoading(view, request);
                }

                public boolean shouldOverrideUrlLoading(WebView view, String url) {
                    return super.shouldOverrideUrlLoading(view, url);
                }

                public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
                    VisualWebFragment.this.isError = true;
                    VisualWebFragment.this.mFailingUrl = failingUrl;
                    VisualWebFragment.this.loadErrorUrl();
                }

                public void onPageFinished(WebView view, String url) {
                    if (!VisualWebFragment.this.isError) {
                        VisualWebFragment.this.errorView.setVisibility(8);
                    }
                    VisualWebFragment.this.isError = false;
                    super.onPageFinished(view, url);
                }
            });
            this.startVisual();
        }
        catch (Exception e) {
            this.loadErrorUrl();
        }
    }

    private void startVisual() {
        this.repository.signUp(this.uid, new OnResultListener(){

            @Override
            public void onResult(Constants.SignUpResponse signUpResult, String msg) {
                if (signUpResult == Constants.SignUpResponse.SUCCESS) {
                    VisualWebFragment.this.loadUrl();
                    if (VisualWebFragment.this.repository.shouldBulk()) {
                        VisualWebFragment.this.startBulkParsing();
                    }
                } else {
                    VisualWebFragment.this.loadErrorUrl();
                }
            }
        });
    }

    private void startBulkParsing() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    LogUtil.LOGI((String)"VisualFlow", (String)"startBulk parsing", (boolean)ParserService.mIsDebug);
                    VisualWebFragment.this.bulkLoader = new BulkLoader(VisualWebFragment.this.getContext(), VisualWebFragment.this.handler, new BulkLoader.OnSmsLoadFinished(){

                        @Override
                        public void onFinished(boolean isError) {
                            try {
                                if (VisualWebFragment.this.handler != null) {
                                    VisualWebFragment.this.handler.sendEmptyMessage(10);
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
                    VisualWebFragment.this.handler.sendEmptyMessage(12);
                    LogUtil.LOGI((String)VisualWebActivity.TAG, (String)"3. \uc9c0\ub09c 6\uac1c\uc6d4 \ubb38\uc790 \ud30c\uc2f1 \uc2dc\uc791", (boolean)ParserService.mIsDebug);
                    VisualWebFragment.this.bulkLoader.doParsing();
                }
                catch (Exception e) {
                    VisualWebFragment.this.handler.sendEmptyMessage(13);
                }
            }
        }).start();
    }

    private void onBulkFinish() {
        this.repository.saveBulk();
        this.webview.postDelayed(new Runnable(){

            @Override
            public void run() {
                VisualWebFragment.this.loadUrl();
            }
        }, 500L);
    }

    private void loadErrorUrl() {
        this.errorView.setVisibility(0);
    }

    private void loadUrl() {
        if (this.webview != null) {
            this.baseUrl = WebViewHelper.getReportUrl(PrefManager.getInstance(this.getContext()));
            this.webview.loadUrl(this.baseUrl);
        }
    }

    private void loadProgress() {
        if (this.webview != null) {
            this.baseUrl = WebViewHelper.getProgressUrl(PrefManager.getInstance(this.getContext()), Constants.ProgressType.Bulk);
            this.webview.loadUrl(this.baseUrl);
        }
    }

    @Override
    public void exportExcel(Callback<Boolean> callback) {
    }

    @Override
    public void onPagedLoaded() {
    }

    @Override
    public void onScrollChanged(int pos) {
    }

    @Override
    public void reload() {
        if (this.webview != null) {
            this.webview.post(new Runnable(){

                @Override
                public void run() {
                    VisualWebFragment.this.webview.reload();
                }
            });
        }
    }

    @Override
    public void retry() {
        if (this.webview != null) {
            this.webview.post(new Runnable(){

                @Override
                public void run() {
                    VisualWebFragment.this.webview.loadUrl(VisualWebFragment.this.mFailingUrl);
                }
            });
        }
    }

    @Override
    public void setRefreshEnabled(boolean enabled) {
    }

    @Override
    public void addAd(View view) {
        try {
            this.webContainer.addView((View)this.createCardView(view));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private CardView createCardView(View view) {
        this.adContainer = new CardView(this.getContext());
        this.adContainer.setCardElevation(this.getResources().getDimension(R.dimen.elevation));
        if (Build.VERSION.SDK_INT >= 21) {
            this.adContainer.setElevation(this.getResources().getDimension(R.dimen.elevation));
        }
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-2, -2);
        params.setMargins(Utils.dpToPx(10), Utils.dpToPx(16), Utils.dpToPx(10), Utils.dpToPx(16));
        params.gravity = 80;
        this.adContainer.setLayoutParams((ViewGroup.LayoutParams)params);
        this.adContainer.setRadius((float)Utils.dpToPx(13));
        this.adContainer.setCardBackgroundColor(Color.parseColor((String)"#00000000"));
        this.adContainer.addView(view);
        return this.adContainer;
    }

    @Override
    public void hideAd() {
        try {
            this.getActivity().runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (VisualWebFragment.this.adContainer != null) {
                        VisualWebFragment.this.webContainer.removeView((View)VisualWebFragment.this.adContainer);
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public TransactionPopupInfo getPopUpInfo() {
        return null;
    }

    @Override
    public void setStatusBarColor(String color2) {
        if (Build.VERSION.SDK_INT >= 21) {
            try {
                this.getActivity().getWindow().setStatusBarColor(Color.parseColor((String)color2));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

