package com.tenqube.visual_third.ui;

import android.graphics.Color;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v7.widget.CardView;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebResourceRequest;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import android.widget.LinearLayout;

import com.tenqube.visual_third.Callback;
import com.tenqube.visual_third.Constants;
import com.tenqube.visual_third.R;
import com.tenqube.visual_third.analysis.AnalysisServiceImpl;
import com.tenqube.visual_third.manager.AdManager;
import com.tenqube.visual_third.manager.PrefManager;
import com.tenqube.visual_third.manager.VisualAlarmManager;
import com.tenqube.visual_third.model.ui.TransactionPopupInfo;
import com.tenqube.visual_third.parser.loader.BulkLoader;
import com.tenqube.visual_third.repository.RepositoryHolder;
import com.tenqube.visual_third.repository.VisualRepository;
import com.tenqube.visual_third.util.Utils;
import com.tenqube.visual_third.web.ActionImpl;
import com.tenqube.visual_third.web.ErrorImpl;
import com.tenqube.visual_third.web.LogImpl;
import com.tenqube.visual_third.web.RepoImpl;
import com.tenqube.visual_third.web.SystemImpl;
import com.tenqube.visual_third.web.UiImpl;
import com.tenqube.visual_third.web.VisualInterface;

import static com.tenqube.visual_third.ui.VisualWebActivity.ERROR;
import static com.tenqube.visual_third.ui.VisualWebActivity.FINISH;
import static com.tenqube.visual_third.ui.VisualWebActivity.PROGRESS;
import static com.tenqube.visual_third.ui.VisualWebActivity.SHOW_PROGRESS_BAR;
import static com.tenqube.visual_third.ui.VisualWebActivity.TAG;
import static com.tenqube.visual_third.util.WebViewHelper.getReportUrl;
import static com.tenqube.visual_third.util.WebViewHelper.settings;
import static tenqube.parser.core.ParserService.mIsDebug;
import static tenqube.parser.util.LogUtil.LOGI;

/**
 * A simple {@link Fragment} subclass.
 * Use the {@link VisualWebFragment#newInstance} factory method to
 * create an instance of this fragment.
 */
public class VisualWebFragment extends Fragment implements ActivityCallback {

    private static final String ARG_UID = "ARG_UID";

    private VisualProgressDialogFragment progressDialog;
    private BulkLoader bulkLoader;

    private WebView webview;
    private VisualRepository repository;
    private VisualAlarmManager alarmManager;
    private String mFailingUrl;

    private VisualInterface.Repo repoInterface;
    private VisualInterface.UI uiInterface;
    private VisualInterface.System systemInterface;
    private VisualInterface.Error errorInterface;
    private VisualInterface.Log logInterface;
    private VisualInterface.Action actionInterface;

    private LinearLayout errorView;
    private boolean isError;

    private String baseUrl = "";
    private CardView adContainer;
    private FrameLayout webContainer;
    private String uid;

    public VisualWebFragment() {
        // Required empty public constructor
    }

    public static VisualWebFragment newInstance(@NonNull String uid) {
        VisualWebFragment fragment = new VisualWebFragment();
        Bundle args = new Bundle();
        args.putString(ARG_UID, uid);
        fragment.setArguments(args);
        return fragment;
    }


    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (getArguments() != null) {
            uid = getArguments().getString(ARG_UID);
        }
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        // Inflate the layout for this fragment
        return inflater.inflate(R.layout.fragment_visual_web, container, false);
    }

    @Override
    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);

        try {

            repository = RepositoryHolder.getInstance(getContext()).getVisualRepository();

            alarmManager = VisualAlarmManager.getInstance(getContext());

            //error view 처리
            errorView = view.findViewById(R.id.error_container);
            errorView.setVisibility(View.GONE);

            view.findViewById(R.id.retry).setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    startVisual();
                }
            });

            webview = view.findViewById(R.id.visual_web_view);
            webContainer = view.findViewById(R.id.web_container);
            // javascriptInterface
            errorInterface = new ErrorImpl(this, webview);
            logInterface = new LogImpl(this, webview, errorInterface);

            repoInterface = new RepoImpl(this, webview, errorInterface, repository, new AnalysisServiceImpl(getContext(), ""), alarmManager);
            uiInterface = new UiImpl(this,
                    webview,
                    errorInterface,
                    new BottomDialog(getActivity()),
                    AdManager.getInstance(getContext()));

            systemInterface = new SystemImpl(this, webview, errorInterface);
            actionInterface = new ActionImpl(this, webview);

            webview.addJavascriptInterface(errorInterface, "visualError");
            webview.addJavascriptInterface(repoInterface, "visualRepo");
            webview.addJavascriptInterface(uiInterface, "visualUI");
            webview.addJavascriptInterface(systemInterface, "visualSystem");
            webview.addJavascriptInterface(logInterface, "visualLog");
            webview.addJavascriptInterface(actionInterface, "visualAction");

            // settings
            settings(webview, repository.isDev());

            // error
            webview.setWebViewClient(new WebViewClient() {

                @Override
                public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {

                    return super.shouldOverrideUrlLoading(view, request);
                }

                @Override
                public boolean shouldOverrideUrlLoading(WebView view, String url) {

                    return super.shouldOverrideUrlLoading(view, url);
                }

                public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
                    isError = true;
                    mFailingUrl = failingUrl;
                    loadErrorUrl();
                }

                @Override
                public void onPageFinished(WebView view, String url) {
                    if (!isError) errorView.setVisibility(View.GONE);
                    isError = false;
                    super.onPageFinished(view, url);
                }
            });

            startVisual();

        } catch (Exception e) {
            loadErrorUrl();
        }
    }

    private void startVisual() {

        repository.signUp(uid, new OnResultListener() {
            @Override
            public void onResult(Constants.SignUpResponse signUpResult, String msg) {

                if(signUpResult == Constants.SignUpResponse.SUCCESS) {
                    loadUrl();

                    if(repository.shouldBulk()) { // 벌크 파싱 진행
                        // 벌크 파싱 시작
                        startBulkParsing();
                    }
                } else {
                    loadErrorUrl();
                }

            }
        });

    }

    /**
     * 1. 퍼미션 체크
     * 2. 프로그레스 다이얼로그 show
     * 3. 지난 6개월 문자 파싱 시작
     */
    private void startBulkParsing() {

        new Thread(new Runnable() {
            @Override
            public void run() {
                try {

                    LOGI("VisualFlow", "startBulk parsing", mIsDebug);

                    bulkLoader = new BulkLoader(getContext(), handler, new BulkLoader.OnSmsLoadFinished() {
                        @Override
                        public void onFinished(boolean isError) {
                            try {
                                if(handler != null) handler.sendEmptyMessage(FINISH);
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
                    // 2. 프로그레스 다이얼로그 show
                    handler.sendEmptyMessage(SHOW_PROGRESS_BAR);

                    // 3. 지난 6개월 문자 파싱 시작
                    LOGI(TAG, "3. 지난 6개월 문자 파싱 시작", mIsDebug);
                    bulkLoader.doParsing();

                } catch (Exception e) {
                    handler.sendEmptyMessage(ERROR);
                }

            }
        }).start();
    }

    private Handler handler = new Handler(new Handler.Callback() { // 핸들러로 전달받은 값 progress 값 세팅해주기
        @Override
        public boolean handleMessage(final Message msg) {

            try {

                LOGI("VisualFlow", "startBulk handleMessage" + msg.what, mIsDebug);

                switch (msg.what) {
                    case PROGRESS:
                        LOGI("VisualFlow", "startBulk handleMessage PROGRESS" , mIsDebug);

                        if(progressDialog != null && progressDialog.isAdded()) {
                            Bundle bundle = msg.getData();
                            if(bundle != null) {
                                progressDialog.setProgressValue(bundle.getInt("now"), bundle.getInt("total"), bundle.getInt("percent"));
                            }
                        }
                        break;

                    case SHOW_PROGRESS_BAR:
                        LOGI("VisualFlow", "startBulk handleMessage SHOW_PROGRESS_BAR" , mIsDebug);

                        try {
                            if(progressDialog == null) {
                                progressDialog = VisualProgressDialogFragment.newInstance();
                                progressDialog.setCancelable(false);
                            }
                            if(!progressDialog.isAdded()) {
                                FragmentManager fragmentManager = getFragmentManager();
                                if(fragmentManager != null) {
                                    LOGI("VisualFlow", "startBulk handleMessage  progress beginTransaction" , mIsDebug);
                                    progressDialog.show(fragmentManager, "dialog");
                                } else {
                                    LOGI("VisualFlow", "startBulk handleMessage fragmentManager null" , mIsDebug);

                                }
                            } else {
                                LOGI("VisualFlow", "startBulk handleMessage progressDialog.isAdded() false" , mIsDebug);

                            }

                        } catch (Exception e) {
                            LOGI("VisualFlow", "startBulk handleMessage  progress Exception" + e.toString() , mIsDebug);

                            progressDialog = null;
                        }

                        break;
                    case FINISH:
                    case ERROR:
                    default:
                        LOGI("VisualFlow", "startBulk handleMessage onBulkFinish" , mIsDebug);

                        onBulkFinish();
                        break;
                }
            } catch (Exception e) {

                LOGI("VisualFlow", "startBulk handleMessage Exception" + e.toString() , mIsDebug);
                onBulkFinish();
            }

            return false;
        }
    });

    private void onBulkFinish() {
        repository.saveBulk();
        if(progressDialog != null && progressDialog.isAdded()) progressDialog.dismissAllowingStateLoss();
        webview.postDelayed(new Runnable() {
            @Override
            public void run() {
                loadUrl();

            }
        }, 500);

    }

    private void loadErrorUrl() {
        errorView.setVisibility(View.VISIBLE);
    }

    private void loadUrl() {
        if(webview != null) {
            baseUrl = getReportUrl(PrefManager.getInstance(getContext()));
            webview.loadUrl(baseUrl);
        }
    }

    @Override
    public void exportExcel(Callback<Boolean> callback) {

    }

    @Override
    public void onPagedLoaded() {

    }

    @Override
    public void onScrollChanged(int pos) {

    }

    @Override
    public void reload() {
        if(webview != null)  {
            webview.post(new Runnable() {
                @Override
                public void run() {
                    webview.reload();
                }
            });
        }
    }

    @Override
    public void retry() {
        if(webview != null)  {
            webview.post(new Runnable() {
                @Override
                public void run() {
                    webview.loadUrl(mFailingUrl);
                }
            });
        }
    }

    @Override
    public void setRefreshEnabled(boolean enabled) {

    }

    @Override
    public void addAd(View view) {
        try {
            webContainer.addView(createCardView(view));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private CardView createCardView(View view) {
        adContainer = new CardView(getContext());
        adContainer.setCardElevation(getResources().getDimension(R.dimen.elevation));
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
            adContainer.setElevation(getResources().getDimension(R.dimen.elevation));
        }

        // Set the CardView layoutParams
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(
                FrameLayout.LayoutParams.WRAP_CONTENT,
                FrameLayout.LayoutParams.WRAP_CONTENT
        );



        params.setMargins(Utils.dpToPx(10), Utils.dpToPx(16), Utils.dpToPx(10), Utils.dpToPx(16));
        params.gravity = Gravity.BOTTOM;
        adContainer.setLayoutParams(params);

        // Set CardView corner radius
        adContainer.setRadius(Utils.dpToPx(13));

        // Set a background color for CardView
        adContainer.setCardBackgroundColor(Color.parseColor("#00000000"));


        adContainer.addView(view);

        return adContainer;

    }

    public void hideAd() {
        try {
            getActivity().runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    if(adContainer != null) {
                        webContainer.removeView(adContainer);
                    }

                }
            });

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public TransactionPopupInfo getPopUpInfo() {
        return null;
    }

    @Override
    public void setStatusBarColor(String color) {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
            try {
                getActivity().getWindow().setStatusBarColor(Color.parseColor(color));
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}
