package com.tenqube.visual_third.parser.loader;

import android.content.Context;

import com.tenqube.visual_third.Callback;
import com.tenqube.visual_third.manager.CurrencyManager;
import com.tenqube.visual_third.manager.PrefManager;
import com.tenqube.visual_third.model.api.ParsingRuleKey;
import com.tenqube.visual_third.repository.RepositoryHolder;
import com.tenqube.visual_third.repository.ResourceRepository;
import com.tenqube.visual_third.repository.VisualRepository;

import java.util.ArrayList;

import tenqube.parser.core.ParserService;
import tenqube.parser.model.Bank;
import tenqube.parser.model.ParsingRule;
import tenqube.parser.model.RegData;
import tenqube.parser.model.Sender;

import static com.tenqube.visual_third.Constants.RULE_VERSION;
import static com.tenqube.visual_third.manager.PrefManager.PARSING_RULE_KEY;
import static com.tenqube.visual_third.manager.PrefManager.PARSING_RULE_VERSION;
import static tenqube.parser.util.LogUtil.LOGI;

class BaseLoader {

    final Context mContext;
    ParserService parserService;
    PrefManager prefManager;
    VisualRepository repository;
    ResourceRepository resourceRepository;

    private CurrencyManager currencyManager;

    BaseLoader(Context context) {
        this.mContext = context;

        this.parserService = ParserService.getInstance(context);
        parserService.setDebugMode(true);

        this.repository = RepositoryHolder.getInstance(context).getVisualRepository();
        this.resourceRepository = RepositoryHolder.getInstance(context).getResourceRepository();

        this.prefManager = PrefManager.getInstance(context);
        this.currencyManager = CurrencyManager.getInstance(context);

//        syncParsingRuleKey();
    }

    private void syncParsingRuleKey() {
        try {
            if(!prefManager.isEnabled(PARSING_RULE_KEY, false)) {
                ParsingRuleKey parsingRuleKey = resourceRepository.syncParsingRuleKey();
                if (parsingRuleKey != null) {
                    ParsingRule parsingRule = new ParsingRule(parsingRuleKey.getSecurityKey(), parsingRuleKey.getTranCount(), RULE_VERSION, new ArrayList<RegData>(), new ArrayList<Sender>(), new ArrayList<Bank>());
                    parserService.syncParsingRule(parsingRule);
                    prefManager.saveBoolean(PARSING_RULE_KEY, true);
                }
            }
        } catch (Exception e) {

        }
    }

    void syncParsingRule(final Callback<Boolean> callback) {
        LOGI("BulkLog", "syncParsingRule", true);
        resourceRepository.syncParsingRule(new Callback<ParsingRule>() {
            @Override
            public void onDataLoaded(ParsingRule parsingRule) {

                LOGI("BulkLog", "syncParsingRule onDataLoaded" + (parsingRule == null), true);

                if(parsingRule != null) {
                    parserService.syncParsingRule(parsingRule);
                    LOGI("BulkLog", "syncParsingRule parsingRule.ruleVersion" + (parsingRule.ruleVersion), true);
                    prefManager.saveIntValue(PARSING_RULE_VERSION, parsingRule.ruleVersion);
                }

                if(callback != null)
                    callback.onDataLoaded(true);
            }
        });

    }

    void setCurrency(ArrayList<com.tenqube.visual_third.model.parser.Transaction> transactions) {
        for(com.tenqube.visual_third.model.parser.Transaction parsedTran : transactions) {
            // 환율 계산
            parsedTran.setSpentMoney(currencyManager.calculateSpentMoney(parsedTran.getParsedTransaction().spentMoney, parsedTran.getParsedTransaction().currency));
        }
    }

}
