package com.tenqube.visual_third.manager;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;

public class SecretKeyManager {

    SharedPreferences preferences1;
    SharedPreferences preferences2;
    SharedPreferences preferences3;

    private static SecretKeyManager mInstance;

    private Context context;

    public static SecretKeyManager getInstance(Context context){
        synchronized (tenqube.parser.core.SecretKeyManager.class) {
            if(mInstance == null){
                mInstance = new SecretKeyManager(context.getApplicationContext());
            }

        }
        return mInstance;
    }

    private SecretKeyManager(Context context) {
        this.context = context;
        preferences1 = context.getSharedPreferences("VisualThirdFile", Context.MODE_PRIVATE);
        preferences2 = context.getSharedPreferences("VisualThirdResource", Context.MODE_PRIVATE);
        preferences3 = context.getSharedPreferences("VisualThirdKey", Context.MODE_PRIVATE);

    }

    public void save(String name, String value) {

        String first = "";
        String second = "";
        String third = "";

        if(!TextUtils.isEmpty(value)) {
            int len = value.length() / 3;
            first = value.substring(0, len);
            second = value.substring(len, 2*len);
            third = value.substring(2*len);
        }

        SharedPreferences.Editor editor1 = preferences1.edit();
        editor1.putString(name, first);
        editor1.apply();

        SharedPreferences.Editor editor2 = preferences2.edit();
        editor2.putString(name, second);
        editor2.apply();

        SharedPreferences.Editor editor3 = preferences3.edit();
        editor3.putString(name, third);
        editor3.apply();

    }

    public String getKey(String name) {
        return preferences1.getString(name, "") + preferences2.getString(name, "") + preferences3.getString(name, "");
    }


}
