package com.tenqube.visual_third.analysis;

import com.tenqube.visual_third.Constants;
import com.tenqube.visual_third.model.analysis.AggregationValue;
import com.tenqube.visual_third.model.analysis.Transaction;

import java.util.ArrayList;
import java.util.HashMap;

import static com.tenqube.visual_third.analysis.AnalysisHelper.aggregate;
import static com.tenqube.visual_third.analysis.AnalysisHelper.filterTransactionsWeekly;

/**
 * Created by sagwangjin on 2018. 7. 22..
 */

public class WeeklyAnalysis implements Runnable {
    private final int before;
    private final ArrayList<Transaction> transactions;
    public HashMap<String, AggregationValue> weekly;

    WeeklyAnalysis(ArrayList<Transaction> transactions, int before) {
        this.transactions = transactions;
        this.before = before;
    }

    @Override
    public void run() {
        // 월간
        ArrayList<Transaction> filteredTransactions = filterTransactionsWeekly(transactions, before); //이번주

        weekly = aggregate(filteredTransactions, Constants.AggregateType.NONE);

    }
}
