package com.tenqube.visual_third.db.dao;

import android.database.Cursor;
import android.database.sqlite.SQLiteException;

import com.tenqube.visual_third.db.Db;
import com.tenqube.visual_third.db.QueryGenerator;
import com.tenqube.visual_third.db.ReaderContract;
import com.tenqube.visual_third.entity.UserCategory;

import java.util.ArrayList;

public class UserCategoryDao {

    private final Db db;

    public UserCategoryDao(Db db) {
        this.db = db;
    }

    public ArrayList<UserCategory> loadUserCategories() {
        String query = QueryGenerator.userCategory();

        ArrayList<UserCategory> results = new ArrayList<>();
        Cursor c = null;

        try {
            c = db.runQuery(query);
            if(c != null) {
                if(c.moveToFirst()) {
                    while (!c.isAfterLast()) {
                        results.add(ReaderContract.UserCategoryTable.populateModel(c));
                        c.moveToNext();
                    }
                }
            }
        } catch (SQLiteException e) {

        } finally {
            if(c != null) {
                c.close();
            }
        }

        return results;
    }

    public int getCategoryId(String repCode) {
        String query = QueryGenerator.userCategoryByCode();
        Cursor c = null;

        try {
            c = db.runQuery(query, new String[]{repCode});
            if(c != null) {
                if(c.moveToFirst()) {
                    return c.getInt(c.getColumnIndex(ReaderContract.UserCategoryTable.COLUMN_USER_CATE_ID));
                }
            }
        } catch (SQLiteException e) {

        } finally {
            if(c != null) {
                c.close();
            }
        }

        return -1;
    }

}
