/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.manager;

import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.graphics.drawable.GradientDrawable;
import android.net.Uri;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.bumptech.glide.Glide;
import com.tenqube.visual_third.Callback;
import com.tenqube.visual_third.OnAdLoadedListener;
import com.tenqube.visual_third.R;
import com.tenqube.visual_third.entity.Advertisement;
import com.tenqube.visual_third.repository.RepositoryHolder;
import com.tenqube.visual_third.repository.VisualRepository;
import com.tenqube.visual_third.ui.VisualWebActivity;
import com.tenqube.visual_third.util.GoOpenMarketUtil;
import java.util.ArrayList;
import java.util.Collections;

public class AdManager {
    public static final String TAG = AdManager.class.getSimpleName();
    public static final String AD_ID = "ca-app-pub-1003660361092577~2912848112";
    public static final String UNIT_ID = "ca-app-pub-1003660361092577/1025051374";
    private static AdManager mInstance = null;
    private VisualRepository repository;
    private Context mContext;
    private View adContainer;
    private FrameLayout mAdView;
    private View resultAdView;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AdManager getInstance(Context ctx) {
        Class<AdManager> clazz = AdManager.class;
        synchronized (AdManager.class) {
            if (mInstance == null) {
                mInstance = new AdManager(ctx.getApplicationContext());
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return mInstance;
        }
    }

    public View getAdView() {
        try {
            return this.resultAdView;
        }
        catch (Exception e) {
            return null;
        }
    }

    private AdManager(Context context) {
        this.mContext = context;
        this.repository = RepositoryHolder.getInstance(context).getVisualRepository();
    }

    public void loadAd(@NonNull OnAdLoadedListener listener) {
        this.loadVisualAd(listener);
    }

    private void loadVisualAd(final OnAdLoadedListener listener) {
        try {
            this.repository.syncAd(new Callback<Boolean>(){

                @Override
                public void onDataLoaded(Boolean shouldLoad) {
                    if (shouldLoad.booleanValue()) {
                        AdManager.this.loadAdByAdmin(listener);
                    } else {
                        AdManager.this.resultAdView = null;
                        listener.onAdLoaded(null);
                    }
                }
            });
        }
        catch (Exception e) {
            this.loadThirdPartyAd(listener);
        }
    }

    private void loadAdByAdmin(final OnAdLoadedListener listener) {
        ArrayList<Advertisement> ads = this.repository.loadAds();
        final ArrayList<Advertisement> satisfiedAds = new ArrayList<Advertisement>();
        int priority = -1;
        for (Advertisement ad : ads) {
            if (priority != -1 && priority != ad.getPriority()) break;
            boolean isSatisfied = this.repository.isSatisfied(ad.getQuery());
            if (isSatisfied) {
                satisfiedAds.add(ad);
            }
            priority = ad.getPriority();
        }
        new Handler(this.mContext.getMainLooper()).post(new Runnable(){

            @Override
            public void run() {
                if (!satisfiedAds.isEmpty()) {
                    Collections.shuffle(satisfiedAds);
                    Advertisement advertisement = (Advertisement)satisfiedAds.get(0);
                    AdManager.this.populateView(advertisement);
                    AdManager.this.resultAdView = AdManager.this.adContainer;
                    listener.onAdLoaded(AdManager.this.adContainer);
                } else if (AdManager.this.mAdView == null) {
                    AdManager.this.loadThirdPartyAd(listener);
                } else {
                    AdManager.this.resultAdView = (View)AdManager.this.mAdView;
                    listener.onAdLoaded((View)AdManager.this.mAdView);
                }
            }
        });
    }

    private void populateView(final @NonNull Advertisement advertisement) {
        this.adContainer = LayoutInflater.from((Context)this.mContext).inflate(R.layout.visual_ad_view, null, false);
        this.setBgColor(this.adContainer, advertisement.getColors().getBgColor());
        ImageView imageTextView = (ImageView)this.adContainer.findViewById(R.id.image);
        RelativeLayout adTextContainer = (RelativeLayout)this.adContainer.findViewById(R.id.ad_text_container);
        this.adContainer.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                AdManager.this.goIntent(advertisement);
            }
        });
        if (!TextUtils.isEmpty((CharSequence)advertisement.getImage())) {
            imageTextView.setVisibility(0);
            Glide.with((Context)this.mContext).load(advertisement.getImage()).into(imageTextView);
            adTextContainer.setVisibility(8);
        } else {
            imageTextView.setVisibility(8);
            adTextContainer.setVisibility(0);
            ImageView iconImageView = (ImageView)this.adContainer.findViewById(R.id.icon_image);
            Glide.with((Context)this.mContext).load(advertisement.getIconImage()).into(iconImageView);
            TextView labelTextView = (TextView)this.adContainer.findViewById(R.id.label);
            labelTextView.setText((CharSequence)advertisement.getLabel());
            this.setTextColor(labelTextView, advertisement.getColors().getLabelColor());
            TextView titleTextView = (TextView)this.adContainer.findViewById(R.id.title);
            titleTextView.setText((CharSequence)advertisement.getTitle());
            this.setTextColor(titleTextView, advertisement.getColors().getTitleColor());
            TextView linktoTextView = (TextView)this.adContainer.findViewById(R.id.linkto);
            linktoTextView.setText((CharSequence)advertisement.getLinkToStr());
            this.setTextColor(linktoTextView, advertisement.getColors().getLinkToColor());
        }
    }

    private void loadThirdPartyAd(OnAdLoadedListener listener) {
        listener.onAdLoaded(null);
    }

    private String selectAdType() {
        try {
            int i;
            String ratio = this.repository.getAdType();
            String[] ratios = ratio.split(":");
            int mobon = Integer.parseInt(ratios[0]);
            int admob = Integer.parseInt(ratios[1]);
            ArrayList<String> items = new ArrayList<String>();
            for (i = 0; i < mobon; ++i) {
                items.add("mobon");
            }
            for (i = 0; i < admob; ++i) {
                items.add("admob");
            }
            if (!items.isEmpty()) {
                Collections.shuffle(items);
                String adType = (String)items.get(0);
                return adType;
            }
            return "admob";
        }
        catch (Exception e) {
            return "admob";
        }
    }

    private void goIntent(Advertisement ad) {
        try {
            if ("app".equals(ad.getLinkToType())) {
                VisualWebActivity.startActivity(this.mContext, "");
            } else if ("market".equals(ad.getLinkToType())) {
                GoOpenMarketUtil.openOnGooglePlayMarket(this.mContext, ad.getLinkTo());
            } else if ("web".equals(ad.getLinkToType())) {
                Intent i = new Intent("android.intent.action.VIEW");
                i.setData(Uri.parse((String)ad.getLinkTo()));
                this.mContext.startActivity(i);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setBgColor(View view, String bgColor) {
        try {
            if (!TextUtils.isEmpty((CharSequence)bgColor)) {
                view.setBackgroundResource(R.drawable.round);
                GradientDrawable drawable2 = (GradientDrawable)view.getBackground();
                drawable2.setColor(Color.parseColor((String)bgColor));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setTextColor(TextView view, String textColor) {
        try {
            if (!TextUtils.isEmpty((CharSequence)textColor)) {
                view.setTextColor(Color.parseColor((String)textColor));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

