/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.api.resource;

import android.text.TextUtils;
import com.tenqube.visual_third.manager.PrefManager;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class ResourceHeaderInterceptor
implements Interceptor {
    private static final String SERVICE = "service";
    private final PrefManager prefManager;

    public ResourceHeaderInterceptor(PrefManager prefManager) {
        this.prefManager = prefManager;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        String apiKey = this.prefManager.loadStringValue("TENQUBE_RESOURCE_API_KEY", "");
        if (TextUtils.isEmpty((CharSequence)apiKey)) {
            throw new IOException("apiKey is empty");
        }
        Request.Builder builder = chain.request().newBuilder().addHeader("x-api-key", apiKey).addHeader(SERVICE, "whowho");
        return chain.proceed(builder.build());
    }
}

