package com.tenqube.visual_third.web;

import android.webkit.JavascriptInterface;

public interface VisualInterface {

    interface Repo {

        @JavascriptInterface
        String getSyncStatus();

        @JavascriptInterface
        void saveStartDay(final String params);

        @JavascriptInterface
        int getStartDay();

        @JavascriptInterface
        void deleteTransactions(final String params);

        @JavascriptInterface
        void getCategories(final String callback);

        @JavascriptInterface
        void getCards(final String callback);

        @JavascriptInterface
        void getTransactions(final String params);

        @JavascriptInterface
        void getTransactionsByIds(final String callback);

        @JavascriptInterface
        void getLv0Contents(final String callback);

        @JavascriptInterface
        void insertTransaction(final String params);

        @JavascriptInterface
        void updateTransaction(final String params);

        @JavascriptInterface
        boolean shouldShowTranPopup();

        @JavascriptInterface
        void setTranPopup(boolean shouldShow);

        @JavascriptInterface
        void settingNotification(String params);

        @JavascriptInterface
        void getNotificationSettings(String callback);

        @JavascriptInterface
        void initialize(String callback);

        @JavascriptInterface
        void signOut(String callback);

        @JavascriptInterface
        void addPayment(final String params);


    }

    interface UI {

        @JavascriptInterface
        void setStatusBarColor(String color);


        @JavascriptInterface
        void openConfirmBox(String params);

        @JavascriptInterface
        void openSelectBox(String params);

        @JavascriptInterface
        void openNewView(String params);

        @JavascriptInterface
        void finish(String path);

        @JavascriptInterface
        void showSnackBar(String msg);

        @JavascriptInterface
        void showToast(String msg);

        @JavascriptInterface
        void onPageLoaded(String params);

        @JavascriptInterface
        void onScrollChanged(int pos);

        @JavascriptInterface
        void onFinish();

        @JavascriptInterface
        void showDatePicker(String callback);

        @JavascriptInterface
        void showTimePicker(String callback);

        @JavascriptInterface
        void reload();

        @JavascriptInterface
        void retry();

        void onCalendar(String date, String callback);

    }

    interface System {

        @JavascriptInterface
        void startNotiListener(final String params);

        @JavascriptInterface
        void goNotiSettings(final String callback);

        @JavascriptInterface
        boolean isNotiEnabled();

        @JavascriptInterface
        boolean isNetworkConnected();

        void onNotiCallback(String params);
    }

    interface Error {
        @JavascriptInterface
        void onError(String funcName, String msg);
    }

    interface Log {
        @JavascriptInterface
        void onKeyMetric(String parmas);
    }

    interface Action {
        @JavascriptInterface
        void requestSmsRecognition(String params);

        @JavascriptInterface
        void restore(String callback);

        @JavascriptInterface
        void exportExcel(String callback);





    }

}
