package com.tenqube.visual_third.repository;

import android.util.SparseArray;

import com.tenqube.visual_third.db.dao.ContentsDao;
import com.tenqube.visual_third.entity.Condition;
import com.tenqube.visual_third.entity.Content;
import com.tenqube.visual_third.entity.JoinedContent;

import java.util.ArrayList;

public class AnalysisRepository {

    private static AnalysisRepository mInstance;
    private final ContentsDao contentsDao;

    public static AnalysisRepository getInstance(ContentsDao contentsDao){
        synchronized (AnalysisRepository.class) {
            if(mInstance == null){
                mInstance = new AnalysisRepository(contentsDao);
            }
        }
        return mInstance;
    }

    private AnalysisRepository(ContentsDao contentsDao) {
        this.contentsDao = contentsDao;
    }

    public ArrayList<JoinedContent> loadContents() {
        ArrayList<Content>  contents = contentsDao.loadContents();
        SparseArray<ArrayList<Condition>> conditionMaps = contentsDao.loadConditions();
        ArrayList<JoinedContent> results = new ArrayList<>();

        for(Content content : contents) {
            results.add(new JoinedContent(content, conditionMaps.get(content.getId())));
        }

        return results;
    }


}
