package com.tenqube.visual_third.model.ui;

import android.text.TextUtils;

import com.tenqube.visual_third.entity.Category;
import com.tenqube.visual_third.model.api.SearchCompanyResponse;

import java.io.Serializable;

import static com.tenqube.visual_third.util.Utils.threeComma;

public class TransactionPopupInfo implements Serializable {

    private final int tranId;
    private final com.tenqube.visual_third.model.parser.Transaction transaction;
    private final SearchCompanyResponse.TranCompany tranCompany;
    private final Category category;


    public TransactionPopupInfo(int tranId, com.tenqube.visual_third.model.parser.Transaction transaction,
                                SearchCompanyResponse.TranCompany tranCompany, Category category) {
        this.tranId = tranId;
        this.transaction = transaction;
        this.tranCompany = tranCompany;
        this.category = category;

    }

    public int getTranId() {
        return tranId;
    }

    public Category getCategory() {
        return category;
    }



    public com.tenqube.visual_third.model.parser.Transaction getTransaction() {
        return transaction;
    }

    public int getLargeCode() {

        try {
            if(tranCompany != null) {
                return Integer.parseInt(tranCompany.getCategory().getLargeCode());
            }
        } catch (Exception e) {

        }

        return 0;

    }

    public String getCategoryCode() {
        if(tranCompany != null) {
            return tranCompany.getCategory().getCode();
        } else {
            return transaction.getCategoryCode();
        }
    }

    public String getCompanyTitle() {
        return tranCompany == null ? "" : tranCompany.isPopUpCompanyName() ? tranCompany.getCompany().getName() : transaction.getParsedTransaction().keyword;
    }

    public String getCompanyAddress() {
        return tranCompany == null ? "" : tranCompany.isPopUpCompanyName() ? tranCompany.getCompany().getAddress() : "";
    }

    public String getSpentDate() {
        return transaction == null ? "" : transaction.getParsedTransaction().spentDate;
    }

    public String getPayment() {
        if(transaction == null) return "";

        String payment = transaction.getParsedTransaction().cardName;
        if(!TextUtils.isEmpty(transaction.getParsedTransaction().cardNum)) {
            payment += " " + transaction.getParsedTransaction().cardNum;
        }
        return payment;
    }

    public int getInstallmentCnt() {
        return transaction == null ? 1 :transaction.getParsedTransaction().installmentCount;
    }

    public String getInstallmentStr() {
        int instCnt = getInstallmentCnt();
        return instCnt == 1 || instCnt == 0 ? "일시불" : instCnt + "개월";
    }

    public double getSpentMoney() {
        if(transaction == null) return 0;

        return transaction.getSpentMoney();
    }

    public String getSpentMoneyStr() {
        return threeComma(getSpentMoney());
    }

}
