package com.tenqube.visual_third.db;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;

public class Db {

    private final SQLiteDatabase wdb;
    private final SQLiteDatabase db;

    public Db(SQLiteDatabase wdb, SQLiteDatabase db) {
        this.wdb = wdb;
        this.db = db;
    }

    public SQLiteDatabase getDb() {
        return db;
    }

    public SQLiteDatabase getWritableDb() {
        return wdb;
    }


    /**
     * Called to insert an item.
     *
     * @param tableName 삽입 되는 테이블명
     * @param values    삽입 되는 값
     * @return return 삽입된 행수
     */
    public long insert(String tableName, ContentValues values) {
        try {
            return wdb.insert(tableName, null, values);
        } catch (SQLException e) {
            return 0;
        }
    }

    /**
     * Called to insert an item.
     *
     * @param tableName 삽입 되는 테이블명
     * @param values    삽입 되는 값
     * @return return 삽입된 행수
     */
    public long insertOnIgnore(String tableName, ContentValues values) {
        try {
            return wdb.insertWithOnConflict(tableName, null, values, SQLiteDatabase.CONFLICT_IGNORE);
        } catch (SQLException e) {
            return 0;
        }
    }

    /**
     * Called to insert an item.
     *
     * @param tableName 삽입 되는 테이블명
     * @param values    삽입 되는 값
     * @return return 삽입된 행수
     */
    public long insertOnReplace(String tableName, ContentValues values) {
        try {
            return wdb.insertWithOnConflict(tableName, null, values, SQLiteDatabase.CONFLICT_REPLACE);
        } catch (SQLException e) {
            return 0;
        }
    }

    /**
     * Called to update an item.
     *
     * @param tableName     업데이트 되는 테이블명
     * @param values        업데이트 되는 값
     * @param selection     where 조건 파라미터
     * @param selectionArgs where 조건 값
     * @return return 업데이트된 행수
     */
    public long update(String tableName, ContentValues values, String selection, String[] selectionArgs) {

        try {
            return wdb.update(tableName, values, selection, selectionArgs);
        } catch (SQLException e) {
            return 0;
        }
    }
    /**
     * Called to delete an item.
     *
     * @param tableName     삭제 되는 테이블명
     * @param selection     where 조건 파라미터
     * @param selectionArgs where 조건 값
     * @return return 삭제된 행수
     */
    public long delete(String tableName, String selection, String[] selectionArgs) {
        try {
            return wdb.delete(tableName, selection, selectionArgs);
        } catch (SQLException e) {
            return 0;
        }
    }

    public Cursor runQuery(final String query) {
        Cursor rows;
        rows = db.rawQuery(query, null);

        if (rows == null) {
            return null;
        }

        try {
            final int rowCount = rows.getCount();

            if (rowCount == 0 || !rows.moveToLast()) {
                rows.close();
                return null;
            }
        } catch (RuntimeException ex) {
            rows.close();
            return null;
        }
        return rows;
    }

    public Cursor runQuery(final String query, String[] args) {
        Cursor rows;
        rows = db.rawQuery(query, args);

        if (rows == null) {
            return null;
        }

        try {
            final int rowCount = rows.getCount();

            if (rowCount == 0 || !rows.moveToLast()) {
                rows.close();
                return null;
            }
        } catch (RuntimeException ex) {
            rows.close();
            return null;
        }
        return rows;
    }

}
