package com.tenqube.visual_third.analysis;

import android.text.TextUtils;

import com.tenqube.visual_third.Constants;
import com.tenqube.visual_third.model.analysis.AggregationValue;
import com.tenqube.visual_third.model.analysis.CAC;
import com.tenqube.visual_third.model.analysis.CategoryMax;
import com.tenqube.visual_third.model.analysis.Morning;
import com.tenqube.visual_third.model.analysis.Transaction;
import com.tenqube.visual_third.util.Utils;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;

import static com.tenqube.visual_third.analysis.AnalysisHelper.KEY_DELIMITER;
import static com.tenqube.visual_third.analysis.AnalysisHelper.aggregate;
import static com.tenqube.visual_third.analysis.AnalysisHelper.desc;
import static com.tenqube.visual_third.analysis.AnalysisHelper.descCAC;
import static com.tenqube.visual_third.analysis.AnalysisHelper.filterTransactions;
import static com.tenqube.visual_third.analysis.AnalysisHelper.filterTransactionsByDate;
import static com.tenqube.visual_third.analysis.AnalysisHelper.filterTransactionsMcode;
import static com.tenqube.visual_third.analysis.AnalysisHelper.getMaxKeyword;
import static com.tenqube.visual_third.analysis.AnalysisHelper.getMonth;
import static com.tenqube.visual_third.analysis.AnalysisHelper.getMorningSum;
import static com.tenqube.visual_third.analysis.AnalysisHelper.getPercent;
import static com.tenqube.visual_third.analysis.AnalysisHelper.getSamePeriodSum;
import static com.tenqube.visual_third.analysis.AnalysisHelper.getSumByLcode;
import static com.tenqube.visual_third.util.Utils.isEmpty;

/**
 * Created by sagwangjin on 2018. 7. 22..
 */

public class MonthlyAnalysis implements Runnable {
    private final int before;
    private final ArrayList<Transaction> transactions;

    String monthStr;

    public HashMap<String, AggregationValue> month;

    private HashMap<String, AggregationValue> aggregateByDate;

    public HashMap<String, AggregationValue> cardType;

    public HashMap<String, AggregationValue> lcode;
    public HashMap<String, AggregationValue> mcode;

    private HashMap<String, AggregationValue> lkeyword;

    HashMap<String, AggregationValue> fastfood;

    private Transaction maxTransaction;

    Morning morningCoffeeSum;
    Morning morningTaxiSum;

    String maxCoffeeDate;

    AggregationValue maxDateValue;
    String maxDate, maxKeyword;
    double maxSum;

    double samePeriodSum;

    private ArrayList<CAC> cacs = new ArrayList<>();

    HashMap<String, CategoryMax> maxKeywordsByCategory = new HashMap<>();

    MonthlyAnalysis(ArrayList<Transaction> transactions, int before) {
        this.transactions = transactions;
        this.before = before;
    }

    @Override
    public void run() {

        monthStr = getMonth(before) + "";
        // 월간
        ArrayList<Transaction> filteredTransactions = filterTransactions(transactions, before); //이번달

        month = aggregate(filteredTransactions, Constants.AggregateType.NONE);

        if(before == 0 || before == 1) {
            aggregateByDate = aggregate(filteredTransactions, Constants.AggregateType.DATE);

            try {
                setMaxKeywordByCategory(filteredTransactions);
            } catch (Exception e) {

            }

            Calendar calendar = Calendar.getInstance();
            calendar.add(Calendar.MONTH, -1 * before);
            calendar.add(Calendar.DATE, 1);

            double sum = getSumByLcode(filteredTransactions, Constants.LCODE.FOOD, Utils.getYMD(calendar));
            cacs.add(new CAC(Constants.LCODE.FOOD, sum));

            sum = getSumByLcode(filteredTransactions, Constants.LCODE.CAFE, Utils.getYMD(calendar));
            cacs.add(new CAC(Constants.LCODE.CAFE, sum));

            sum = getSumByLcode(filteredTransactions, Constants.LCODE.ALCOHOL, Utils.getYMD(calendar));
            cacs.add(new CAC(Constants.LCODE.ALCOHOL, sum));

            descCAC(cacs);

        }

        if(before != 0) {
            samePeriodSum = getSamePeriodSum(filteredTransactions, before); // month_1_sum_same_period
            maxTransaction = getMaxKeyword(filteredTransactions);

        } else {
            ArrayList<Transaction> coffeeTransactions = filterTransactionsMcode(filteredTransactions, Constants.MCODE.COFFEE);
            HashMap<String, AggregationValue> aggregateByMcodeDate = aggregate(coffeeTransactions, Constants.AggregateType.DATE);
            ArrayList<AggregationValue> coffees = new ArrayList<>(aggregateByMcodeDate.values());
            if(!isEmpty(coffees)) {
                desc(coffees);
                maxCoffeeDate = coffees.get(0).getTitle();
            }
        }

        cardType = aggregate(filteredTransactions, Constants.AggregateType.CARD_TYPE);

        lcode = aggregate(filteredTransactions, Constants.AggregateType.LCODE);
        mcode = aggregate(filteredTransactions, Constants.AggregateType.MCODE);

        fastfood = aggregate(filterTransactionsMcode(filteredTransactions, Constants.MCODE.FASTFOOD), Constants.AggregateType.KEYWORD);

        morningCoffeeSum = getMorningSum(filteredTransactions, Constants.MCODE.COFFEE);
        morningTaxiSum = getMorningSum(filteredTransactions, Constants.MCODE.TAXI);

        calculateMaxDate();

    }

    private void calculateMaxDate() {

        if(aggregateByDate != null) {
            ArrayList<AggregationValue> values = new ArrayList<>(aggregateByDate.values());
            if(!isEmpty(values)) {
                desc(values);
                maxDateValue = values.get(0);
                maxDate = maxDateValue.getTitle();
                maxSum = maxDateValue.getSum();

                ArrayList<Transaction> filteredTransactions = filterTransactionsByDate(transactions, maxDate);

                Transaction transaction  = getMaxKeyword(filteredTransactions);
                if(transaction != null) {
                    maxKeyword = transaction.getTransaction().getKeyword();
                }
            }
        }
    }

    private void setMaxKeywordByCategory(ArrayList<Transaction> filteredTransactions) {
        lkeyword = aggregate(filteredTransactions, Constants.AggregateType.LCODE, Constants.AggregateType.KEYWORD);

        if(lkeyword != null && !lkeyword.isEmpty()) {
            ArrayList<AggregationValue> sumBylKeyword = new ArrayList<>(lkeyword.values());

            desc(sumBylKeyword);

            for(AggregationValue value : sumBylKeyword) {
                CategoryMax maxValue = maxKeywordsByCategory.get(value.getTitle());
                if(maxValue == null) {
                    String[] values = value.getKey().split(KEY_DELIMITER);
                    if(values.length > 0) {
                        maxValue = new CategoryMax(value.getTitle(), value.getSum(), values[1]);
                        maxKeywordsByCategory.put(value.getTitle(), maxValue);
                    }
                }
            }
        }


    }

    double getCACSum() {
        double sum = 0;

        for(CAC cac : cacs) {
            sum += cac.getSum();
        }

        return sum;
    }

    String getCACStr(double monthSum) {
//        "식사 22%,\\n 카페/간식 23%,\\n 술/유흥 20%"

        ArrayList<String> values = new ArrayList<>();

        for(CAC cac : cacs) {

            String percentStr = monthSum == 0 ? "0.0%" : getPercent((cac.getSum() * 100 / monthSum));
            switch (cac.getLcode()) {
                case Constants.LCODE.FOOD:
                    values.add("식사 " + percentStr);
                    break;

                case Constants.LCODE.CAFE:
                    values.add("카페/간식 " + percentStr);
                    break;

                case Constants.LCODE.ALCOHOL:
                    values.add("술/유흥 " + percentStr);
                    break;

            }
        }

        return TextUtils.join(",\n", values);


    }


}
